/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.service.saleorder.SaleOrderComputeServiceImpl;
import com.axelor.apps.sale.service.saleorder.SaleOrderLineService;
import com.axelor.apps.sale.service.saleorder.SaleOrderLineTaxService;
import com.axelor.apps.supplychain.service.SaleOrderServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderComputeServiceSupplychainImpl
extends SaleOrderComputeServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public SaleOrderComputeServiceSupplychainImpl(SaleOrderLineService saleOrderLineService, SaleOrderLineTaxService saleOrderLineTaxService) {
        super(saleOrderLineService, saleOrderLineTaxService);
    }

    public void _computeSaleOrder(SaleOrder saleOrder) throws AxelorException {
        super._computeSaleOrder(saleOrder);
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return;
        }
        int maxDelay = 0;
        if (saleOrder.getSaleOrderLineList() != null && !saleOrder.getSaleOrderLineList().isEmpty()) {
            for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
                if (saleOrderLine.getSaleSupplySelect() != 3 && saleOrderLine.getSaleSupplySelect() != 2) continue;
                maxDelay = Integer.max(maxDelay, saleOrderLine.getStandardDelay() == null ? 0 : saleOrderLine.getStandardDelay());
            }
        }
        saleOrder.setStandardDelay(maxDelay);
        if (((AppAccountService)Beans.get(AppAccountService.class)).getAppAccount().getManageAdvancePaymentInvoice().booleanValue()) {
            saleOrder.setAdvanceTotal(this.computeTotalInvoiceAdvancePayment(saleOrder));
        }
        ((SaleOrderServiceSupplychainImpl)((Object)Beans.get(SaleOrderServiceSupplychainImpl.class))).updateAmountToBeSpreadOverTheTimetable(saleOrder);
    }

    protected BigDecimal computeTotalInvoiceAdvancePayment(SaleOrder saleOrder) {
        BigDecimal total = BigDecimal.ZERO;
        if (saleOrder.getId() == null) {
            return total;
        }
        List advancePaymentInvoiceList = ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).all().filter("self.saleOrder.id = :saleOrderId AND self.operationSubTypeSelect = :operationSubTypeSelect").bind("saleOrderId", (Object)saleOrder.getId()).bind("operationSubTypeSelect", (Object)2).fetch();
        if (advancePaymentInvoiceList == null || advancePaymentInvoiceList.isEmpty()) {
            return total;
        }
        for (Invoice advance : advancePaymentInvoiceList) {
            total = total.add(advance.getAmountPaid());
        }
        return total;
    }
}

