/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.SaleOrderLineTax;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface SaleOrderInvoiceService {
    @Transactional(rollbackOn={Exception.class})
    public Invoice generateInvoice(SaleOrder var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public Invoice generateInvoice(SaleOrder var1, List<SaleOrderLine> var2) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public Invoice generateInvoice(SaleOrder var1, List<SaleOrderLine> var2, Map<Long, BigDecimal> var3) throws AxelorException;

    public Invoice generateInvoice(SaleOrder var1, int var2, BigDecimal var3, boolean var4, Map<Long, BigDecimal> var5, List<Long> var6) throws AxelorException;

    public SaleOrder fillSaleOrder(SaleOrder var1, Invoice var2);

    public Invoice createInvoice(SaleOrder var1) throws AxelorException;

    public Invoice createInvoice(SaleOrder var1, List<SaleOrderLine> var2) throws AxelorException;

    public Invoice createInvoice(SaleOrder var1, List<SaleOrderLine> var2, Map<Long, BigDecimal> var3) throws AxelorException;

    public Invoice generateAdvancePayment(SaleOrder var1, BigDecimal var2, boolean var3) throws AxelorException;

    public List<InvoiceLine> createInvoiceLinesFromTax(Invoice var1, List<SaleOrderLineTax> var2, Product var3, BigDecimal var4) throws AxelorException;

    public Invoice generateInvoiceFromLines(SaleOrder var1, Map<Long, BigDecimal> var2, boolean var3) throws AxelorException;

    public InvoiceGenerator createInvoiceGenerator(SaleOrder var1) throws AxelorException;

    public InvoiceGenerator createInvoiceGenerator(SaleOrder var1, boolean var2) throws AxelorException;

    public List<InvoiceLine> createInvoiceLine(Invoice var1, SaleOrderLine var2, BigDecimal var3) throws AxelorException;

    public List<InvoiceLine> createInvoiceLines(Invoice var1, List<SaleOrderLine> var2, Map<Long, BigDecimal> var3) throws AxelorException;

    public void addSubLineQty(Map<Long, BigDecimal> var1, BigDecimal var2, Long var3);

    public BigDecimal computeAmountToInvoicePercent(SaleOrder var1, BigDecimal var2, boolean var3) throws AxelorException;

    public void update(SaleOrder var1, Long var2, boolean var3) throws AxelorException;

    public BigDecimal getInvoicedAmount(SaleOrder var1);

    public BigDecimal getInvoicedAmount(SaleOrder var1, Long var2, boolean var3);

    public List<Invoice> getInvoices(SaleOrder var1);

    @Transactional(rollbackOn={Exception.class})
    public Invoice mergeInvoice(List<Invoice> var1, Company var2, Currency var3, Partner var4, Partner var5, PriceList var6, PaymentMode var7, PaymentCondition var8, SaleOrder var9) throws AxelorException;

    public BigDecimal getInTaxInvoicedAmount(SaleOrder var1);

    public Map<String, Integer> getInvoicingWizardOperationDomain(SaleOrder var1);

    public void displayErrorMessageIfSaleOrderIsInvoiceable(SaleOrder var1, BigDecimal var2, boolean var3) throws AxelorException;

    public void displayErrorMessageBtnGenerateInvoice(SaleOrder var1) throws AxelorException;
}

