/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.AppSupplychain;
import com.axelor.apps.base.db.CancelReason;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.service.saleorder.SaleOrderServiceImpl;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.apps.supplychain.service.SaleOrderStockService;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.MoreObjects;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderServiceSupplychainImpl
extends SaleOrderServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppSupplychain appSupplychain;
    protected SaleOrderStockService saleOrderStockService;

    @Inject
    public SaleOrderServiceSupplychainImpl(AppSupplychainService appSupplychainService, SaleOrderStockService saleOrderStockService) {
        this.appSupplychain = appSupplychainService.getAppSupplychain();
        this.saleOrderStockService = saleOrderStockService;
    }

    public SaleOrder getClientInformations(SaleOrder saleOrder) {
        Partner client = saleOrder.getClientPartner();
        PartnerService partnerService = (PartnerService)Beans.get(PartnerService.class);
        if (client != null) {
            saleOrder.setPaymentCondition(client.getPaymentCondition());
            saleOrder.setPaymentMode(client.getInPaymentMode());
            saleOrder.setMainInvoicingAddress(partnerService.getInvoicingAddress(client));
            this.computeAddressStr(saleOrder);
            saleOrder.setDeliveryAddress(partnerService.getDeliveryAddress(client));
            saleOrder.setPriceList(((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(client, 1));
        }
        return saleOrder;
    }

    public void updateAmountToBeSpreadOverTheTimetable(SaleOrder saleOrder) {
        List<Timetable> timetableList = saleOrder.getTimetableList();
        BigDecimal totalHT = saleOrder.getExTaxTotal();
        BigDecimal sumTimetableAmount = BigDecimal.ZERO;
        if (timetableList != null) {
            for (Timetable timetable : timetableList) {
                sumTimetableAmount = sumTimetableAmount.add(timetable.getAmount());
            }
        }
        saleOrder.setAmountToBeSpreadOverTheTimetable(totalHT.subtract(sumTimetableAmount));
    }

    @Transactional(rollbackOn={Exception.class})
    public boolean enableEditOrder(SaleOrder saleOrder) throws AxelorException {
        boolean checkAvailabiltyRequest = super.enableEditOrder(saleOrder);
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return checkAvailabiltyRequest;
        }
        List allStockMoves = ((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).findAllBySaleOrderAndStatus("com.axelor.apps.sale.db.SaleOrder", saleOrder.getId(), 2).fetch();
        List stockMoves = !allStockMoves.isEmpty() ? allStockMoves.stream().filter(stockMove -> stockMove.getAvailabilityRequest() == false).collect(Collectors.toList()) : allStockMoves;
        boolean bl = checkAvailabiltyRequest = stockMoves.size() != allStockMoves.size() ? true : checkAvailabiltyRequest;
        if (!stockMoves.isEmpty()) {
            StockMoveService stockMoveService = (StockMoveService)Beans.get(StockMoveService.class);
            StockMoveRepository stockMoveRepository = (StockMoveRepository)((Object)Beans.get(StockMoveRepository.class));
            CancelReason cancelReason = this.appSupplychain.getCancelReasonOnChangingSaleOrder();
            if (cancelReason == null) {
                throw new AxelorException((Model)((Object)this.appSupplychain), 4, "You must configure a cancel reason on changing sale order in app supplychain.");
            }
            for (StockMove stockMove2 : stockMoves) {
                stockMoveService.cancel(stockMove2, cancelReason);
                stockMoveRepository.remove((Model)((Object)stockMove2));
            }
        }
        return checkAvailabiltyRequest;
    }

    public void checkModifiedConfirmedOrder(SaleOrder saleOrder, SaleOrder saleOrderView) throws AxelorException {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            super.checkModifiedConfirmedOrder(saleOrder, saleOrderView);
            return;
        }
        List saleOrderLineList = (List)MoreObjects.firstNonNull(saleOrder.getSaleOrderLineList(), Collections.emptyList());
        List saleOrderViewLineList = (List)MoreObjects.firstNonNull(saleOrderView.getSaleOrderLineList(), Collections.emptyList());
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            if (saleOrderLine.getDeliveryState() <= 1) continue;
            Optional<SaleOrderLine> optionalNewSaleOrderLine = saleOrderViewLineList.stream().filter(saleOrderLine::equals).findFirst();
            if (optionalNewSaleOrderLine.isPresent()) {
                SaleOrderLine newSaleOrderLine = optionalNewSaleOrderLine.get();
                if (newSaleOrderLine.getQty().compareTo(saleOrderLine.getDeliveredQty()) >= 0) continue;
                throw new AxelorException((Model)((Object)saleOrder), 5, I18n.get((String)"Quantity cannot be lower than already delivered quantity on detail line %s."), new Object[]{saleOrderLine.getFullName()});
            }
            throw new AxelorException((Model)((Object)saleOrder), 5, I18n.get((String)"Can't remove delivered detail line %s."), new Object[]{saleOrderLine.getFullName()});
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void validateChanges(SaleOrder saleOrder) throws AxelorException {
        super.validateChanges(saleOrder);
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return;
        }
        this.saleOrderStockService.fullyUpdateDeliveryState(saleOrder);
        saleOrder.setOrderBeingEdited(false);
        if (this.appSupplychain.getCustomerStockMoveGenerationAuto().booleanValue()) {
            this.saleOrderStockService.createStocksMovesFromSaleOrder(saleOrder);
        }
    }
}

