/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.stock.db.PartnerStockSettings;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.service.PartnerStockSettingsService;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.apps.supplychain.db.SupplyChainConfig;
import com.axelor.apps.supplychain.service.SaleOrderLineServiceSupplyChain;
import com.axelor.apps.supplychain.service.SaleOrderStockService;
import com.axelor.apps.supplychain.service.StockMoveLineServiceSupplychain;
import com.axelor.apps.supplychain.service.config.SupplyChainConfigService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class SaleOrderStockServiceImpl
implements SaleOrderStockService {
    protected StockMoveService stockMoveService;
    protected StockMoveLineService stockMoveLineService;
    protected StockConfigService stockConfigService;
    protected UnitConversionService unitConversionService;
    protected SaleOrderLineServiceSupplyChain saleOrderLineServiceSupplyChain;
    protected StockMoveLineServiceSupplychain stockMoveLineSupplychainService;
    protected StockMoveLineRepository stockMoveLineRepository;
    protected AppBaseService appBaseService;
    protected SaleOrderRepository saleOrderRepository;

    @Inject
    public SaleOrderStockServiceImpl(StockMoveService stockMoveService, StockMoveLineService stockMoveLineService, StockConfigService stockConfigService, UnitConversionService unitConversionService, SaleOrderLineServiceSupplyChain saleOrderLineServiceSupplyChain, StockMoveLineServiceSupplychain stockMoveLineSupplychainService, StockMoveLineRepository stockMoveLineRepository, AppBaseService appBaseService, SaleOrderRepository saleOrderRepository) {
        this.stockMoveService = stockMoveService;
        this.stockMoveLineService = stockMoveLineService;
        this.stockConfigService = stockConfigService;
        this.unitConversionService = unitConversionService;
        this.saleOrderLineServiceSupplyChain = saleOrderLineServiceSupplyChain;
        this.stockMoveLineSupplychainService = stockMoveLineSupplychainService;
        this.stockMoveLineRepository = stockMoveLineRepository;
        this.appBaseService = appBaseService;
        this.saleOrderRepository = saleOrderRepository;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public List<Long> createStocksMovesFromSaleOrder(SaleOrder saleOrder) throws AxelorException {
        if (!this.isSaleOrderWithProductsToDeliver(saleOrder)) {
            return null;
        }
        if (saleOrder.getStockLocation() == null) {
            throw new AxelorException((Model)((Object)saleOrder), 4, I18n.get((String)"Stock location is missing for the sale order %s."), new Object[]{saleOrder.getSaleOrderSeq()});
        }
        ArrayList<Long> stockMoveList = new ArrayList<Long>();
        Map<LocalDate, List<SaleOrderLine>> saleOrderLinePerDateMap = this.getAllSaleOrderLinePerDate(saleOrder);
        for (LocalDate estimatedDeliveryDate : saleOrderLinePerDateMap.keySet().stream().filter(x -> x != null).sorted((x, y) -> x.compareTo((ChronoLocalDate)y)).collect(Collectors.toList())) {
            List<SaleOrderLine> saleOrderLineList = saleOrderLinePerDateMap.get(estimatedDeliveryDate);
            Optional<StockMove> stockMove = this.createStockMove(saleOrder, estimatedDeliveryDate, saleOrderLineList);
            stockMove.map(StockMove::getId).ifPresent(stockMoveList::add);
        }
        Optional<List<SaleOrderLine>> saleOrderLineList = Optional.ofNullable(saleOrderLinePerDateMap.get(null));
        if (saleOrderLineList.isPresent()) {
            Optional<StockMove> stockMove = this.createStockMove(saleOrder, null, saleOrderLineList.get());
            stockMove.map(StockMove::getId).ifPresent(stockMoveList::add);
        }
        return stockMoveList;
    }

    protected Optional<StockMove> createStockMove(SaleOrder saleOrder, LocalDate estimatedDeliveryDate, List<SaleOrderLine> saleOrderLineList) throws AxelorException {
        SupplyChainConfig supplychainConfig;
        StockMove stockMove = this.createStockMove(saleOrder, saleOrder.getCompany(), estimatedDeliveryDate);
        stockMove.setDeliveryCondition(saleOrder.getDeliveryCondition());
        for (SaleOrderLine saleOrderLine : saleOrderLineList) {
            BigDecimal qty;
            if (saleOrderLine.getProduct() == null && !saleOrderLine.getTypeSelect().equals(2) || (qty = this.saleOrderLineServiceSupplyChain.computeUndeliveredQty(saleOrderLine)).signum() <= 0 || this.existActiveStockMoveForSaleOrderLine(saleOrderLine)) continue;
            this.createStockMoveLine(stockMove, saleOrderLine, qty);
        }
        if (stockMove.getStockMoveLineList() == null || stockMove.getStockMoveLineList().isEmpty()) {
            return Optional.empty();
        }
        if (stockMove.getStockMoveLineList().stream().noneMatch(stockMoveLine -> stockMoveLine.getSaleOrderLine() != null && stockMoveLine.getSaleOrderLine().getTypeSelect() == 0)) {
            stockMove.setFullySpreadOverLogisticalFormsFlag(true);
        }
        boolean isNeedingConformityCertificate = saleOrder.getIsNeedingConformityCertificate();
        stockMove.setIsNeedingConformityCertificate(isNeedingConformityCertificate);
        if (isNeedingConformityCertificate) {
            stockMove.setSignatoryUser(this.stockConfigService.getStockConfig(stockMove.getCompany()).getSignatoryUser());
        }
        if ((supplychainConfig = ((SupplyChainConfigService)Beans.get(SupplyChainConfigService.class)).getSupplyChainConfig(saleOrder.getCompany())).getDefaultEstimatedDate() != null && supplychainConfig.getDefaultEstimatedDate() == 0 && stockMove.getEstimatedDate() == null) {
            stockMove.setEstimatedDate(this.appBaseService.getTodayDate());
        } else if (supplychainConfig.getDefaultEstimatedDate() == 2 && stockMove.getEstimatedDate() == null) {
            stockMove.setEstimatedDate(this.appBaseService.getTodayDate().plusDays(supplychainConfig.getNumberOfDays().longValue()));
        }
        this.stockMoveService.plan(stockMove);
        if (((AppSaleService)Beans.get(AppSaleService.class)).getAppSale().getProductPackMgt().booleanValue()) {
            this.setParentStockMoveLine(stockMove);
        }
        return Optional.of(stockMove);
    }

    protected Map<LocalDate, List<SaleOrderLine>> getAllSaleOrderLinePerDate(SaleOrder saleOrder) {
        HashMap<LocalDate, List<SaleOrderLine>> saleOrderLinePerDateMap = new HashMap<LocalDate, List<SaleOrderLine>>();
        for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
            ArrayList<SaleOrderLine> saleOrderLineLists;
            if (this.saleOrderLineServiceSupplyChain.computeUndeliveredQty(saleOrderLine).signum() <= 0) continue;
            LocalDate dateKey = saleOrderLine.getEstimatedDelivDate();
            if (dateKey == null) {
                dateKey = saleOrderLine.getSaleOrder().getDeliveryDate();
            }
            if ((saleOrderLineLists = (ArrayList<SaleOrderLine>)saleOrderLinePerDateMap.get(dateKey)) == null) {
                saleOrderLineLists = new ArrayList<SaleOrderLine>();
                saleOrderLinePerDateMap.put(dateKey, saleOrderLineLists);
            }
            saleOrderLineLists.add(saleOrderLine);
        }
        return saleOrderLinePerDateMap;
    }

    @Transactional
    public void setParentStockMoveLine(StockMove stockMove) {
        for (StockMoveLine line : stockMove.getStockMoveLineList()) {
            if (line.getSaleOrderLine() == null) continue;
            line.setPackPriceSelect(line.getSaleOrderLine().getPackPriceSelect());
            StockMoveLine parentStockMoveLine = (StockMoveLine)((Object)((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).all().filter("self.saleOrderLine = ?1 and self.stockMove = ?2", new Object[]{line.getSaleOrderLine().getParentLine(), stockMove}).fetchOne());
            line.setParentLine(parentStockMoveLine);
        }
    }

    protected boolean isSaleOrderWithProductsToDeliver(SaleOrder saleOrder) throws AxelorException {
        if (saleOrder.getSaleOrderLineList() == null) {
            return false;
        }
        for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
            if (!this.isStockMoveProduct(saleOrderLine)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StockMove createStockMove(SaleOrder saleOrder, Company company, LocalDate estimatedDeliveryDate) throws AxelorException {
        StockLocation toStockLocation = this.stockConfigService.getCustomerVirtualStockLocation(this.stockConfigService.getStockConfig(company));
        StockMove stockMove = this.stockMoveService.createStockMove(null, saleOrder.getDeliveryAddress(), company, saleOrder.getClientPartner(), saleOrder.getStockLocation(), toStockLocation, null, estimatedDeliveryDate, saleOrder.getDescription(), saleOrder.getShipmentMode(), saleOrder.getFreightCarrierMode(), saleOrder.getCarrierPartner(), saleOrder.getForwarderPartner(), saleOrder.getIncoterm(), 2);
        stockMove.setToAddressStr(saleOrder.getDeliveryAddressStr());
        stockMove.setOriginId(saleOrder.getId());
        stockMove.setOriginTypeSelect("com.axelor.apps.sale.db.SaleOrder");
        stockMove.setOrigin(saleOrder.getSaleOrderSeq());
        stockMove.setStockMoveLineList(new ArrayList<StockMoveLine>());
        stockMove.setTradingName(saleOrder.getTradingName());
        stockMove.setSpecificPackage(saleOrder.getSpecificPackage());
        this.setReservationDateTime(stockMove, saleOrder);
        stockMove.setNote(saleOrder.getDeliveryComments());
        stockMove.setPickingOrderComments(saleOrder.getPickingOrderComments());
        if (stockMove.getPartner() != null) {
            this.setDefaultAutoMailSettings(stockMove);
        }
        return stockMove;
    }

    protected void setReservationDateTime(StockMove stockMove, SaleOrder saleOrder) {
        LocalDateTime reservationDateTime = saleOrder.getConfirmationDateTime();
        if (reservationDateTime == null) {
            reservationDateTime = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime();
        }
        stockMove.setReservationDateTime(reservationDateTime);
    }

    protected void setDefaultAutoMailSettings(StockMove stockMove) throws AxelorException {
        Partner partner = stockMove.getPartner();
        Company company = stockMove.getCompany();
        PartnerStockSettings mailSettings = ((PartnerStockSettingsService)Beans.get(PartnerStockSettingsService.class)).getOrCreateMailSettings(partner, company);
        stockMove.setRealStockMoveAutomaticMail(mailSettings.getRealStockMoveAutomaticMail());
        stockMove.setRealStockMoveMessageTemplate(mailSettings.getRealStockMoveMessageTemplate());
        stockMove.setPlannedStockMoveAutomaticMail(mailSettings.getPlannedStockMoveAutomaticMail());
        stockMove.setPlannedStockMoveMessageTemplate(mailSettings.getPlannedStockMoveMessageTemplate());
    }

    @Override
    public StockMoveLine createStockMoveLine(StockMove stockMove, SaleOrderLine saleOrderLine) throws AxelorException {
        return this.createStockMoveLine(stockMove, saleOrderLine, this.saleOrderLineServiceSupplyChain.computeUndeliveredQty(saleOrderLine));
    }

    @Override
    public StockMoveLine createStockMoveLine(StockMove stockMove, SaleOrderLine saleOrderLine, BigDecimal qty) throws AxelorException {
        if (this.isStockMoveProduct(saleOrderLine)) {
            Unit unit = saleOrderLine.getProduct().getUnit();
            BigDecimal priceDiscounted = saleOrderLine.getPriceDiscounted();
            BigDecimal requestedReservedQty = saleOrderLine.getRequestedReservedQty().subtract(saleOrderLine.getDeliveredQty());
            BigDecimal companyUnitPriceUntaxed = saleOrderLine.getProduct().getCostPrice();
            if (unit != null && !unit.equals((Object)saleOrderLine.getUnit())) {
                qty = this.unitConversionService.convert(saleOrderLine.getUnit(), unit, qty, qty.scale(), saleOrderLine.getProduct());
                priceDiscounted = this.unitConversionService.convert(unit, saleOrderLine.getUnit(), priceDiscounted, this.appBaseService.getNbDecimalDigitForUnitPrice(), saleOrderLine.getProduct());
                requestedReservedQty = this.unitConversionService.convert(saleOrderLine.getUnit(), unit, requestedReservedQty, requestedReservedQty.scale(), saleOrderLine.getProduct());
            }
            BigDecimal taxRate = BigDecimal.ZERO;
            TaxLine taxLine = saleOrderLine.getTaxLine();
            if (taxLine != null) {
                taxRate = taxLine.getValue();
            }
            if (saleOrderLine.getQty().signum() != 0) {
                companyUnitPriceUntaxed = saleOrderLine.getCompanyExTaxTotal().divide(saleOrderLine.getQty(), ((AppBaseService)Beans.get(AppBaseService.class)).getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_EVEN);
            }
            StockMoveLine stockMoveLine = this.stockMoveLineSupplychainService.createStockMoveLine(saleOrderLine.getProduct(), saleOrderLine.getProductName(), saleOrderLine.getDescription(), qty, requestedReservedQty, priceDiscounted, companyUnitPriceUntaxed, unit, stockMove, 1, saleOrderLine.getSaleOrder().getInAti(), taxRate, saleOrderLine, null);
            if (saleOrderLine.getDeliveryState() == 0) {
                saleOrderLine.setDeliveryState(1);
            }
            if (stockMoveLine != null) {
                this.updatePackInfo(saleOrderLine, stockMoveLine);
            }
            return stockMoveLine;
        }
        if (saleOrderLine.getTypeSelect() == 2) {
            StockMoveLine stockMoveLine = this.stockMoveLineService.createStockMoveLine(null, saleOrderLine.getProductName(), saleOrderLine.getDescription(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, stockMove, 1, saleOrderLine.getSaleOrder().getInAti().booleanValue(), null);
            saleOrderLine.setDeliveryState(1);
            this.updatePackInfo(saleOrderLine, stockMoveLine);
            stockMoveLine.setSaleOrderLine(saleOrderLine);
            return stockMoveLine;
        }
        return null;
    }

    private void updatePackInfo(SaleOrderLine saleOrderLine, StockMoveLine stockMoveLine) {
        stockMoveLine.setLineTypeSelect(saleOrderLine.getTypeSelect());
        stockMoveLine.setPackPriceSelect(saleOrderLine.getPackPriceSelect());
        stockMoveLine.setIsSubLine(saleOrderLine.getIsSubLine());
    }

    @Override
    public boolean isStockMoveProduct(SaleOrderLine saleOrderLine) throws AxelorException {
        return this.isStockMoveProduct(saleOrderLine, saleOrderLine.getSaleOrder());
    }

    @Override
    public boolean isStockMoveProduct(SaleOrderLine saleOrderLine, SaleOrder saleOrder) throws AxelorException {
        Company company = saleOrder.getCompany();
        SupplyChainConfig supplyChainConfig = ((SupplyChainConfigService)Beans.get(SupplyChainConfigService.class)).getSupplyChainConfig(company);
        Product product = saleOrderLine.getProduct();
        return product != null && ("service".equals(product.getProductTypeSelect()) && supplyChainConfig.getHasOutSmForNonStorableProduct() != false && product.getIsShippingCostsProduct() == false || "storable".equals(product.getProductTypeSelect()) && supplyChainConfig.getHasOutSmForStorableProduct() != false);
    }

    protected boolean existActiveStockMoveForSaleOrderLine(SaleOrderLine saleOrderLine) {
        long stockMoveLineCount = this.stockMoveLineRepository.all().filter("self.saleOrderLine.id = ?1 AND self.stockMove.statusSelect in (?2,?3)", new Object[]{saleOrderLine.getId(), 1, 2}).count();
        return stockMoveLineCount > 0L;
    }

    @Override
    public void updateDeliveryState(SaleOrder saleOrder) throws AxelorException {
        saleOrder.setDeliveryState(this.computeDeliveryState(saleOrder));
    }

    @Override
    public void fullyUpdateDeliveryState(SaleOrder saleOrder) throws AxelorException {
        this.saleOrderLineServiceSupplyChain.updateDeliveryStates(saleOrder.getSaleOrderLineList());
        this.updateDeliveryState(saleOrder);
    }

    private int computeDeliveryState(SaleOrder saleOrder) throws AxelorException {
        if (saleOrder.getSaleOrderLineList() == null || saleOrder.getSaleOrderLineList().isEmpty()) {
            return 1;
        }
        int deliveryState = -1;
        for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
            if (!this.isStockMoveProduct(saleOrderLine, saleOrder)) continue;
            if (saleOrderLine.getDeliveryState() == 3) {
                if (deliveryState == 1 || deliveryState == 2) {
                    return 2;
                }
                deliveryState = 3;
                continue;
            }
            if (saleOrderLine.getDeliveryState() == 1) {
                if (deliveryState == 3 || deliveryState == 2) {
                    return 2;
                }
                deliveryState = 1;
                continue;
            }
            if (saleOrderLine.getDeliveryState() != 2) continue;
            return 2;
        }
        return deliveryState;
    }

    @Override
    public Optional<SaleOrder> findSaleOrder(StockMove stockMove) {
        if ("com.axelor.apps.sale.db.SaleOrder".equals(stockMove.getOriginTypeSelect()) && stockMove.getOriginId() != null) {
            return Optional.ofNullable(this.saleOrderRepository.find(stockMove.getOriginId()));
        }
        return Optional.empty();
    }
}

