/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.supplychain.service.ReservedQtyService;
import com.axelor.apps.supplychain.service.StockLocationLineReservationService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.List;

public class StockLocationLineReservationServiceImpl
implements StockLocationLineReservationService {
    @Override
    @Transactional(rollbackOn={Exception.class})
    public void allocateAll(StockLocationLine stockLocationLine) throws AxelorException {
        BigDecimal qtyToAllocate = stockLocationLine.getRequestedReservedQty().min(stockLocationLine.getCurrentQty()).subtract(stockLocationLine.getReservedQty());
        BigDecimal qtyAllocated = ((ReservedQtyService)Beans.get(ReservedQtyService.class)).allocateReservedQuantityInSaleOrderLines(qtyToAllocate, stockLocationLine.getStockLocation(), stockLocationLine.getProduct(), stockLocationLine.getUnit());
        stockLocationLine.setReservedQty(stockLocationLine.getReservedQty().add(qtyAllocated));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void deallocateAll(StockLocationLine stockLocationLine) throws AxelorException {
        List stockMoveLineList = ((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).all().filter("self.product = :product AND self.stockMove.fromStockLocation = :stockLocation AND self.stockMove.statusSelect = :planned AND (self.stockMove.availabilityRequest IS FALSE OR self.stockMove.availabilityRequest IS NULL) AND self.reservedQty > 0").bind("product", (Object)stockLocationLine.getProduct()).bind("stockLocation", (Object)stockLocationLine.getStockLocation()).bind("planned", (Object)2).fetch();
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            stockMoveLine.setReservedQty(BigDecimal.ZERO);
            SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
            if (saleOrderLine == null) continue;
            saleOrderLine.setReservedQty(BigDecimal.ZERO);
        }
        ((ReservedQtyService)Beans.get(ReservedQtyService.class)).updateReservedQty(stockLocationLine);
    }
}

