/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockLocationServiceImpl;
import com.axelor.apps.supplychain.service.StockLocationServiceSupplychain;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.List;

public class StockLocationServiceSupplychainImpl
extends StockLocationServiceImpl
implements StockLocationServiceSupplychain {
    @Inject
    public StockLocationServiceSupplychainImpl(StockLocationRepository stockLocationRepo, StockLocationLineService stockLocationLineService, ProductRepository productRepo) {
        super(stockLocationRepo, stockLocationLineService, productRepo);
    }

    @Override
    public BigDecimal getReservedQty(Long productId, Long locationId, Long companyId) throws AxelorException {
        if (productId != null) {
            Product product = (Product)((Object)this.productRepo.find(productId));
            Unit productUnit = product.getUnit();
            UnitConversionService unitConversionService = (UnitConversionService)Beans.get(UnitConversionService.class);
            if (locationId == null || locationId == 0L) {
                List stockLocations = this.getNonVirtualStockLocations(companyId);
                if (!stockLocations.isEmpty()) {
                    BigDecimal reservedQty = BigDecimal.ZERO;
                    for (StockLocation stockLocation : stockLocations) {
                        StockLocationLine stockLocationLine = this.stockLocationLineService.getOrCreateStockLocationLine((StockLocation)((Object)this.stockLocationRepo.find(stockLocation.getId())), (Product)((Object)this.productRepo.find(productId)));
                        if (stockLocationLine == null) continue;
                        Unit stockLocationLineUnit = stockLocationLine.getUnit();
                        reservedQty = reservedQty.add(stockLocationLine.getReservedQty());
                        if (productUnit == null || productUnit.equals((Object)stockLocationLineUnit)) continue;
                        reservedQty = unitConversionService.convert(stockLocationLineUnit, productUnit, reservedQty, reservedQty.scale(), product);
                    }
                    return reservedQty;
                }
            } else {
                StockLocationLine stockLocationLine = this.stockLocationLineService.getOrCreateStockLocationLine((StockLocation)((Object)this.stockLocationRepo.find(locationId)), (Product)((Object)this.productRepo.find(productId)));
                if (stockLocationLine != null) {
                    Unit stockLocationLineUnit = stockLocationLine.getUnit();
                    if (productUnit != null && !productUnit.equals((Object)stockLocationLineUnit)) {
                        return unitConversionService.convert(stockLocationLineUnit, productUnit, stockLocationLine.getReservedQty(), stockLocationLine.getReservedQty().scale(), product);
                    }
                    return stockLocationLine.getReservedQty();
                }
            }
        }
        return BigDecimal.ZERO;
    }
}

