/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface StockMoveInvoiceService {
    public Invoice createInvoice(StockMove var1, Integer var2, List<Map<String, Object>> var3) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public Invoice createInvoiceFromSaleOrder(StockMove var1, SaleOrder var2, Map<Long, BigDecimal> var3) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public Invoice createInvoiceFromPurchaseOrder(StockMove var1, PurchaseOrder var2, Map<Long, BigDecimal> var3) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public Invoice createInvoiceFromOrderlessStockMove(StockMove var1, Map<Long, BigDecimal> var2) throws AxelorException;

    public Invoice extendInternalReference(StockMove var1, Invoice var2);

    public List<InvoiceLine> createInvoiceLines(Invoice var1, List<StockMoveLine> var2, Map<Long, BigDecimal> var3) throws AxelorException;

    public List<InvoiceLine> createInvoiceLine(Invoice var1, StockMoveLine var2, BigDecimal var3) throws AxelorException;

    public List<Map<String, Object>> getStockMoveLinesToInvoice(StockMove var1);

    public BigDecimal getNonCanceledInvoiceQty(StockMoveLine var1);

    public void computeStockMoveInvoicingStatus(StockMove var1);
}

