/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.InvoiceLineRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.StockMoveInvoiceService;
import com.axelor.apps.supplychain.service.StockMoveLineServiceSupplychain;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceGeneratorSupplyChain;
import com.axelor.apps.supplychain.service.invoice.generator.InvoiceLineGeneratorSupplyChain;
import com.axelor.apps.tool.StringTool;
import com.axelor.common.ObjectUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StockMoveInvoiceServiceImpl
implements StockMoveInvoiceService {
    private SaleOrderInvoiceService saleOrderInvoiceService;
    private PurchaseOrderInvoiceService purchaseOrderInvoiceService;
    private StockMoveLineServiceSupplychain stockMoveLineServiceSupplychain;
    private InvoiceRepository invoiceRepository;
    private SaleOrderRepository saleOrderRepo;
    private PurchaseOrderRepository purchaseOrderRepo;
    private StockMoveLineRepository stockMoveLineRepository;
    private InvoiceLineRepository invoiceLineRepository;

    @Inject
    public StockMoveInvoiceServiceImpl(SaleOrderInvoiceService saleOrderInvoiceService, PurchaseOrderInvoiceService purchaseOrderInvoiceService, StockMoveLineServiceSupplychain stockMoveLineServiceSupplychain, InvoiceRepository invoiceRepository, SaleOrderRepository saleOrderRepo, PurchaseOrderRepository purchaseOrderRepo, StockMoveLineRepository stockMoveLineRepository, InvoiceLineRepository invoiceLineRepository) {
        this.saleOrderInvoiceService = saleOrderInvoiceService;
        this.purchaseOrderInvoiceService = purchaseOrderInvoiceService;
        this.stockMoveLineServiceSupplychain = stockMoveLineServiceSupplychain;
        this.invoiceRepository = invoiceRepository;
        this.saleOrderRepo = saleOrderRepo;
        this.purchaseOrderRepo = purchaseOrderRepo;
        this.stockMoveLineRepository = stockMoveLineRepository;
        this.invoiceLineRepository = invoiceLineRepository;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice createInvoice(StockMove stockMove, Integer operationSelect, List<Map<String, Object>> stockMoveLineListContext) throws AxelorException {
        HashMap<Long, BigDecimal> qtyToInvoiceMap = new HashMap<Long, BigDecimal>();
        if (operationSelect == 2) {
            for (Map map : stockMoveLineListContext) {
                if (map.get("qtyToInvoice") == null) continue;
                BigDecimal qtyToInvoiceItem = new BigDecimal(map.get("qtyToInvoice").toString());
                BigDecimal remainingQty = new BigDecimal(map.get("remainingQty").toString());
                if (qtyToInvoiceItem.compareTo(BigDecimal.ZERO) == 0) continue;
                if (qtyToInvoiceItem.compareTo(remainingQty) > 0) {
                    qtyToInvoiceItem = remainingQty;
                }
                Long stockMoveLineId = Long.parseLong(map.get("stockMoveLineId").toString());
                StockMoveLine stockMoveLine = (StockMoveLine)((Object)this.stockMoveLineRepository.find(stockMoveLineId));
                this.addSubLineQty(qtyToInvoiceMap, qtyToInvoiceItem, stockMoveLineId);
                qtyToInvoiceMap.put(stockMoveLine.getId(), qtyToInvoiceItem);
            }
        } else {
            for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
                qtyToInvoiceMap.put(stockMoveLine.getId(), stockMoveLine.getRealQty().subtract(this.getNonCanceledInvoiceQty(stockMoveLine)));
            }
        }
        Long origin = stockMove.getOriginId();
        Invoice invoice = "com.axelor.apps.sale.db.SaleOrder".equals(stockMove.getOriginTypeSelect()) ? this.createInvoiceFromSaleOrder(stockMove, (SaleOrder)((Object)this.saleOrderRepo.find(origin)), qtyToInvoiceMap) : ("com.axelor.apps.purchase.db.PurchaseOrder".equals(stockMove.getOriginTypeSelect()) ? this.createInvoiceFromPurchaseOrder(stockMove, (PurchaseOrder)((Object)this.purchaseOrderRepo.find(origin)), qtyToInvoiceMap) : this.createInvoiceFromOrderlessStockMove(stockMove, qtyToInvoiceMap));
        return invoice;
    }

    private void addSubLineQty(Map<Long, BigDecimal> qtyToInvoiceMap, BigDecimal qtyToInvoiceItem, Long stockMoveLineId) {
        StockMoveLine stockMoveLine = (StockMoveLine)((Object)this.stockMoveLineRepository.find(stockMoveLineId));
        if (stockMoveLine.getProductTypeSelect().equals("pack")) {
            for (StockMoveLine subLine : stockMoveLine.getSubLineList()) {
                BigDecimal qty = BigDecimal.ZERO;
                if (stockMoveLine.getQty().compareTo(BigDecimal.ZERO) != 0) {
                    qty = qtyToInvoiceItem.multiply(subLine.getQty()).divide(stockMoveLine.getQty(), 2, RoundingMode.HALF_EVEN);
                }
                qty = qty.setScale(2, RoundingMode.HALF_EVEN);
                qtyToInvoiceMap.put(subLine.getId(), qty);
            }
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice createInvoiceFromSaleOrder(StockMove stockMove, SaleOrder saleOrder, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        InvoiceGenerator invoiceGenerator = this.saleOrderInvoiceService.createInvoiceGenerator(saleOrder, stockMove.getIsReversion());
        Invoice invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, stockMove.getStockMoveLineList(), qtyToInvoiceMap));
        if (invoice != null) {
            invoice.setSaleOrder(saleOrder);
            this.extendInternalReference(stockMove, invoice);
            invoice.setAddressStr(saleOrder.getMainInvoicingAddressStr());
            if (invoice.getOperationSubTypeSelect() != 2) {
                invoice.setAdvancePaymentInvoiceSet(((InvoiceService)Beans.get(InvoiceService.class)).getDefaultAdvancePaymentInvoice(invoice));
            }
            invoice.setPartnerTaxNbr(saleOrder.getClientPartner().getTaxNbr());
            if (!Strings.isNullOrEmpty((String)saleOrder.getInvoiceComments())) {
                invoice.setNote(saleOrder.getInvoiceComments());
            }
            if (ObjectUtils.isEmpty((Object)invoice.getProformaComments()) && !Strings.isNullOrEmpty((String)saleOrder.getProformaComments())) {
                invoice.setProformaComments(saleOrder.getProformaComments());
            }
            if (invoice != null) {
                Set<StockMove> stockMoveSet = invoice.getStockMoveSet();
                if (stockMoveSet == null) {
                    stockMoveSet = new HashSet<StockMove>();
                    invoice.setStockMoveSet(stockMoveSet);
                }
                stockMoveSet.add(stockMove);
            }
            this.invoiceRepository.save((Model)((Object)invoice));
        }
        return invoice;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice createInvoiceFromPurchaseOrder(StockMove stockMove, PurchaseOrder purchaseOrder, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        InvoiceGenerator invoiceGenerator = this.purchaseOrderInvoiceService.createInvoiceGenerator(purchaseOrder, stockMove.getIsReversion());
        Invoice invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, stockMove.getStockMoveLineList(), qtyToInvoiceMap));
        if (invoice != null) {
            this.extendInternalReference(stockMove, invoice);
            invoice.setAddressStr(((AddressService)Beans.get(AddressService.class)).computeAddressStr(invoice.getAddress()));
            if (invoice != null) {
                Set<StockMove> stockMoveSet = invoice.getStockMoveSet();
                if (stockMoveSet == null) {
                    stockMoveSet = new HashSet<StockMove>();
                    invoice.setStockMoveSet(stockMoveSet);
                }
                stockMoveSet.add(stockMove);
            }
            this.invoiceRepository.save((Model)((Object)invoice));
        }
        return invoice;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice createInvoiceFromOrderlessStockMove(StockMove stockMove, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        int invoiceOperationType;
        int stockMoveType = stockMove.getTypeSelect();
        if (stockMove.getIsReversion().booleanValue()) {
            if (stockMoveType == 3) {
                invoiceOperationType = 4;
            } else {
                if (stockMoveType != 2) return null;
                invoiceOperationType = 2;
            }
        } else if (stockMoveType == 3) {
            invoiceOperationType = 1;
        } else {
            if (stockMoveType != 2) return null;
            invoiceOperationType = 3;
        }
        InvoiceGeneratorSupplyChain invoiceGenerator = new InvoiceGeneratorSupplyChain(stockMove, invoiceOperationType){

            public Invoice generate() throws AxelorException {
                return super.createInvoiceHeader();
            }
        };
        Invoice invoice = invoiceGenerator.generate();
        invoiceGenerator.populate(invoice, this.createInvoiceLines(invoice, stockMove.getStockMoveLineList(), qtyToInvoiceMap));
        if (invoice == null) return invoice;
        this.extendInternalReference(stockMove, invoice);
        invoice.setAddressStr(((AddressService)Beans.get(AddressService.class)).computeAddressStr(invoice.getAddress()));
        if (stockMoveType == 2) {
            invoice.setHeadOfficeAddress(stockMove.getPartner().getHeadOfficeAddress());
        }
        this.invoiceRepository.save((Model)((Object)invoice));
        if (invoice != null) {
            Set<StockMove> stockMoveSet = invoice.getStockMoveSet();
            if (stockMoveSet == null) {
                stockMoveSet = new HashSet<StockMove>();
                invoice.setStockMoveSet(stockMoveSet);
            }
            stockMoveSet.add(stockMove);
        }
        this.invoiceRepository.save((Model)((Object)invoice));
        return invoice;
    }

    @Override
    public Invoice extendInternalReference(StockMove stockMove, Invoice invoice) {
        invoice.setInternalReference(StringTool.cutTooLongString((String)(stockMove.getStockMoveSeq() + ":" + invoice.getInternalReference())));
        return invoice;
    }

    @Override
    public List<InvoiceLine> createInvoiceLines(Invoice invoice, List<StockMoveLine> stockMoveLineList, Map<Long, BigDecimal> qtyToInvoiceMap) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        HashMap packLineMap = Maps.newHashMap();
        boolean setPack = ((AppSaleService)Beans.get(AppSaleService.class)).getAppSale().getProductPackMgt();
        for (StockMoveLine stockMoveLine : this.getConsolidatedStockMoveLineList(stockMoveLineList)) {
            List<InvoiceLine> invoiceLineListCreated = null;
            Long id = stockMoveLine.getId();
            if (qtyToInvoiceMap != null) {
                if (qtyToInvoiceMap.containsKey(id)) {
                    invoiceLineListCreated = this.createInvoiceLine(invoice, stockMoveLine, qtyToInvoiceMap.get(id));
                }
            } else {
                invoiceLineListCreated = this.createInvoiceLine(invoice, stockMoveLine, stockMoveLine.getRealQty().subtract(this.getNonCanceledInvoiceQty(stockMoveLine)));
            }
            if (invoiceLineListCreated != null) {
                invoiceLineList.addAll(invoiceLineListCreated);
                if (setPack && !invoiceLineListCreated.isEmpty() && (stockMoveLine.getLineTypeSelect() == 2 || stockMoveLine.getIsSubLine().booleanValue())) {
                    packLineMap.put(stockMoveLine, invoiceLineListCreated.get(0));
                }
            }
            if (stockMoveLine.getSaleOrderLine() != null) {
                stockMoveLine.getSaleOrderLine().setInvoiced(true);
                continue;
            }
            if (stockMoveLine.getPurchaseOrderLine() == null) continue;
            stockMoveLine.getPurchaseOrderLine().setInvoiced(true);
        }
        if (setPack) {
            for (StockMoveLine stockMoveLine : packLineMap.keySet()) {
                InvoiceLine invoiceLine;
                if (stockMoveLine.getLineTypeSelect() != 2 || (invoiceLine = (InvoiceLine)((Object)packLineMap.get((Object)stockMoveLine))) == null) continue;
                BigDecimal totalPack = BigDecimal.ZERO;
                for (StockMoveLine subLine : stockMoveLine.getSubLineList()) {
                    InvoiceLine subInvoiceLine = (InvoiceLine)((Object)packLineMap.get((Object)subLine));
                    if (subInvoiceLine == null) continue;
                    totalPack = totalPack.add(subInvoiceLine.getExTaxTotal());
                    subInvoiceLine.setParentLine(invoiceLine);
                }
                invoiceLine.setTotalPack(totalPack);
            }
        }
        return invoiceLineList;
    }

    @Override
    public List<InvoiceLine> createInvoiceLine(Invoice invoice, StockMoveLine stockMoveLine, BigDecimal qty) throws AxelorException {
        Product product = stockMoveLine.getProduct();
        boolean isTitleLine = false;
        int sequence = 0;
        SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
        PurchaseOrderLine purchaseOrderLine = stockMoveLine.getPurchaseOrderLine();
        if (saleOrderLine != null) {
            if (saleOrderLine.getTypeSelect() == 2) {
                isTitleLine = true;
            }
            sequence = saleOrderLine.getSequence();
        } else if (purchaseOrderLine != null) {
            if (purchaseOrderLine.getIsTitleLine().booleanValue()) {
                isTitleLine = true;
            }
            sequence = purchaseOrderLine.getSequence();
        }
        if (stockMoveLine.getRealQty().compareTo(BigDecimal.ZERO) == 0 && !isTitleLine) {
            return new ArrayList<InvoiceLine>();
        }
        if (product == null && !isTitleLine) {
            throw new AxelorException(4, I18n.get((String)"Incorrect product in the stock move %s"), new Object[]{stockMoveLine.getStockMove().getStockMoveSeq()});
        }
        InvoiceLineGeneratorSupplyChain invoiceLineGenerator = new InvoiceLineGeneratorSupplyChain(invoice, product, stockMoveLine.getProductName(), stockMoveLine.getDescription(), qty, stockMoveLine.getUnit(), sequence, false, stockMoveLine.getSaleOrderLine(), stockMoveLine.getPurchaseOrderLine(), stockMoveLine, stockMoveLine.getIsSubLine(), stockMoveLine.getPackPriceSelect()){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        List invoiceLines = invoiceLineGenerator.creates();
        for (InvoiceLine invoiceLine : invoiceLines) {
            invoiceLine.setStockMoveLine(stockMoveLine);
        }
        return invoiceLines;
    }

    private List<StockMoveLine> getConsolidatedStockMoveLineList(List<StockMoveLine> stockMoveLineList) throws AxelorException {
        LinkedHashMap<SaleOrderLine, ArrayList<StockMoveLine>> stockMoveLineSaleMap = new LinkedHashMap<SaleOrderLine, ArrayList<StockMoveLine>>();
        LinkedHashMap<PurchaseOrderLine, ArrayList<StockMoveLine>> stockMoveLinePurchaseMap = new LinkedHashMap<PurchaseOrderLine, ArrayList<StockMoveLine>>();
        ArrayList<StockMoveLine> resultList = new ArrayList<StockMoveLine>();
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            List<StockMoveLine> list;
            if (stockMoveLine.getSaleOrderLine() != null) {
                list = (ArrayList<StockMoveLine>)stockMoveLineSaleMap.get((Object)stockMoveLine.getSaleOrderLine());
                if (list == null) {
                    list = new ArrayList<StockMoveLine>();
                    stockMoveLineSaleMap.put(stockMoveLine.getSaleOrderLine(), (ArrayList<StockMoveLine>)list);
                }
                list.add(stockMoveLine);
                continue;
            }
            if (stockMoveLine.getPurchaseOrderLine() != null) {
                list = (List)stockMoveLinePurchaseMap.get((Object)stockMoveLine.getPurchaseOrderLine());
                if (list == null) {
                    list = new ArrayList();
                    stockMoveLinePurchaseMap.put(stockMoveLine.getPurchaseOrderLine(), (ArrayList<StockMoveLine>)list);
                }
                list.add(stockMoveLine);
                continue;
            }
            resultList.add(stockMoveLine);
        }
        for (List stockMoveLines : stockMoveLineSaleMap.values()) {
            resultList.add(this.stockMoveLineServiceSupplychain.getMergedStockMoveLine(stockMoveLines));
        }
        for (List stockMoveLines : stockMoveLinePurchaseMap.values()) {
            resultList.add(this.stockMoveLineServiceSupplychain.getMergedStockMoveLine(stockMoveLines));
        }
        return resultList;
    }

    @Override
    public List<Map<String, Object>> getStockMoveLinesToInvoice(StockMove stockMove) {
        ArrayList<Map<String, Object>> stockMoveLines = new ArrayList<Map<String, Object>>();
        for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
            BigDecimal qty;
            if (stockMoveLine.getIsSubLine().booleanValue() || (qty = stockMoveLine.getRealQty().subtract(this.getNonCanceledInvoiceQty(stockMoveLine))).compareTo(BigDecimal.ZERO) == 0) continue;
            HashMap<String, Object> stockMoveLineMap = new HashMap<String, Object>();
            stockMoveLineMap.put("productCode", stockMoveLine.getProduct().getCode());
            stockMoveLineMap.put("productName", stockMoveLine.getProductName());
            stockMoveLineMap.put("remainingQty", qty);
            stockMoveLineMap.put("realQty", stockMoveLine.getRealQty());
            stockMoveLineMap.put("qtyInvoiced", this.getNonCanceledInvoiceQty(stockMoveLine));
            stockMoveLineMap.put("qtyToInvoice", BigDecimal.ZERO);
            stockMoveLineMap.put("invoiceAll", false);
            stockMoveLineMap.put("isSubline", stockMoveLine.getIsSubLine());
            stockMoveLineMap.put("stockMoveLineId", stockMoveLine.getId());
            stockMoveLines.add(stockMoveLineMap);
        }
        return stockMoveLines;
    }

    @Override
    public BigDecimal getNonCanceledInvoiceQty(StockMoveLine stockMoveLine) {
        return this.invoiceLineRepository.all().filter("self.invoice.statusSelect != :invoiceCanceled AND self.stockMoveLine.id = :stockMoveLineId").bind("invoiceCanceled", (Object)4).bind("stockMoveLineId", (Object)stockMoveLine.getId()).fetchStream().map(InvoiceLine::getQty).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    @Override
    public void computeStockMoveInvoicingStatus(StockMove stockMove) {
        int invoicingStatus = 0;
        if (stockMove.getStockMoveLineList() != null && stockMove.getInvoiceSet() != null && !stockMove.getInvoiceSet().isEmpty()) {
            BigDecimal totalInvoicedQty = stockMove.getStockMoveLineList().stream().map(StockMoveLine::getQtyInvoiced).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal totalRealQty = stockMove.getStockMoveLineList().stream().map(StockMoveLine::getRealQty).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (totalRealQty.compareTo(totalInvoicedQty) > 0) {
                invoicingStatus = 1;
            } else if (totalRealQty.compareTo(totalInvoicedQty) == 0) {
                invoicingStatus = 2;
            }
        }
        stockMove.setInvoicingStatusSelect(invoicingStatus);
    }
}

