/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.PriceListService;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.tax.AccountManagementService;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.db.TrackingNumberConfiguration;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.db.repo.TrackingNumberRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockMoveLineServiceImpl;
import com.axelor.apps.stock.service.StockMoveToolService;
import com.axelor.apps.stock.service.TrackingNumberService;
import com.axelor.apps.stock.service.WeightedAveragePriceService;
import com.axelor.apps.stock.service.app.AppStockService;
import com.axelor.apps.supplychain.service.StockMoveLineServiceSupplychain;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.math.BigDecimal;
import java.util.List;

@RequestScoped
public class StockMoveLineServiceSupplychainImpl
extends StockMoveLineServiceImpl
implements StockMoveLineServiceSupplychain {
    protected AccountManagementService accountManagementService;
    protected PriceListService priceListService;

    @Inject
    public StockMoveLineServiceSupplychainImpl(TrackingNumberService trackingNumberService, AppBaseService appBaseService, AppStockService appStockService, StockMoveToolService stockMoveToolService, StockMoveLineRepository stockMoveLineRepository, StockLocationLineService stockLocationLineService, UnitConversionService unitConversionService, WeightedAveragePriceService weightedAveragePriceService, TrackingNumberRepository trackingNumberRepo, AccountManagementService accountManagementService, PriceListService priceListService) {
        super(trackingNumberService, appBaseService, appStockService, stockMoveToolService, stockMoveLineRepository, stockLocationLineService, unitConversionService, weightedAveragePriceService, trackingNumberRepo);
        this.accountManagementService = accountManagementService;
        this.priceListService = priceListService;
    }

    @Override
    public StockMoveLine createStockMoveLine(Product product, String productName, String description, BigDecimal quantity, BigDecimal requestedReservedQty, BigDecimal unitPrice, BigDecimal companyUnitPriceUntaxed, Unit unit, StockMove stockMove, int type, boolean taxed, BigDecimal taxRate, SaleOrderLine saleOrderLine, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        if (product != null) {
            StockMoveLine stockMoveLine = this.generateStockMoveLineConvertingUnitPrice(product, productName, description, quantity, unitPrice, companyUnitPriceUntaxed, unit, stockMove, taxed, taxRate);
            stockMoveLine.setRequestedReservedQty(requestedReservedQty);
            stockMoveLine.setSaleOrderLine(saleOrderLine);
            stockMoveLine.setPurchaseOrderLine(purchaseOrderLine);
            TrackingNumberConfiguration trackingNumberConfiguration = product.getTrackingNumberConfiguration();
            return this.assignOrGenerateTrackingNumber(stockMoveLine, stockMove, product, trackingNumberConfiguration, type);
        }
        return this.createStockMoveLine(product, productName, description, quantity, BigDecimal.ZERO, BigDecimal.ZERO, companyUnitPriceUntaxed, unit, stockMove, null);
    }

    public StockMoveLine compute(StockMoveLine stockMoveLine, StockMove stockMove) throws AxelorException {
        if (stockMove == null || !((AppBaseService)Beans.get(AppBaseService.class)).isApp("supplychain")) {
            return super.compute(stockMoveLine, null);
        }
        if (stockMoveLine.getProduct() == null || stockMoveLine.getLineTypeSelect() != null && stockMoveLine.getLineTypeSelect() == 2) {
            return stockMoveLine;
        }
        stockMoveLine = stockMove.getOriginId() != null && stockMove.getOriginId() != 0L ? this.computeFromOrder(stockMoveLine, stockMove) : super.compute(stockMoveLine, stockMove);
        return stockMoveLine;
    }

    protected StockMoveLine computeFromOrder(StockMoveLine stockMoveLine, StockMove stockMove) throws AxelorException {
        BigDecimal unitPriceUntaxed = stockMoveLine.getUnitPriceUntaxed();
        BigDecimal unitPriceTaxed = stockMoveLine.getUnitPriceTaxed();
        Unit orderUnit = null;
        if ("com.axelor.apps.sale.db.SaleOrder".equals(stockMove.getOriginTypeSelect())) {
            SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
            if (saleOrderLine == null) {
                TraceBackService.trace((AxelorException)new AxelorException(0, "Missing link to sale order line (from sale order id = %s) for stock move line %s", new Object[]{stockMove.getOriginId(), stockMove.getName()}));
            } else {
                unitPriceUntaxed = saleOrderLine.getPriceDiscounted();
                unitPriceTaxed = saleOrderLine.getInTaxPrice();
                orderUnit = saleOrderLine.getUnit();
            }
        } else if ("com.axelor.apps.purchase.db.PurchaseOrder".equals(stockMove.getOriginTypeSelect())) {
            PurchaseOrderLine purchaseOrderLine = stockMoveLine.getPurchaseOrderLine();
            if (purchaseOrderLine == null) {
                TraceBackService.trace((AxelorException)new AxelorException(0, "Missing purchase order with id %s for stock move line %s", new Object[]{stockMove.getOriginId(), stockMove.getName()}));
            } else {
                unitPriceUntaxed = purchaseOrderLine.getPrice();
                unitPriceTaxed = purchaseOrderLine.getInTaxPrice();
                orderUnit = purchaseOrderLine.getUnit();
            }
        }
        stockMoveLine.setUnitPriceUntaxed(unitPriceUntaxed);
        stockMoveLine.setUnitPriceTaxed(unitPriceTaxed);
        Unit stockUnit = this.getStockUnit(stockMoveLine);
        return this.convertUnitPrice(stockMoveLine, orderUnit, stockUnit);
    }

    protected StockMoveLine convertUnitPrice(StockMoveLine stockMoveLine, Unit fromUnit, Unit toUnit) throws AxelorException {
        if (toUnit != null && fromUnit != null) {
            BigDecimal unitPriceUntaxed = this.unitConversionService.convert(fromUnit, toUnit, stockMoveLine.getUnitPriceUntaxed(), this.appBaseService.getNbDecimalDigitForUnitPrice(), null);
            BigDecimal unitPriceTaxed = this.unitConversionService.convert(fromUnit, toUnit, stockMoveLine.getUnitPriceTaxed(), this.appBaseService.getNbDecimalDigitForUnitPrice(), null);
            stockMoveLine.setUnitPriceUntaxed(unitPriceUntaxed);
            stockMoveLine.setUnitPriceTaxed(unitPriceTaxed);
        }
        return stockMoveLine;
    }

    public StockMoveLine splitStockMoveLine(StockMoveLine stockMoveLine, BigDecimal qty, TrackingNumber trackingNumber) throws AxelorException {
        StockMoveLine newStockMoveLine = super.splitStockMoveLine(stockMoveLine, qty, trackingNumber);
        if (!((AppBaseService)Beans.get(AppBaseService.class)).isApp("supplychain")) {
            return newStockMoveLine;
        }
        BigDecimal reservedQtyAfterSplit = BigDecimal.ZERO.max(stockMoveLine.getRequestedReservedQty().subtract(qty));
        BigDecimal reservedQtyInNewLine = stockMoveLine.getRequestedReservedQty().min(qty);
        stockMoveLine.setRequestedReservedQty(reservedQtyAfterSplit);
        newStockMoveLine.setRequestedReservedQty(reservedQtyInNewLine);
        newStockMoveLine.setSaleOrderLine(stockMoveLine.getSaleOrderLine());
        newStockMoveLine.setPurchaseOrderLine(stockMoveLine.getPurchaseOrderLine());
        return newStockMoveLine;
    }

    public void updateAvailableQty(StockMoveLine stockMoveLine, StockLocation stockLocation) {
        if (!((AppBaseService)Beans.get(AppBaseService.class)).isApp("supplychain")) {
            super.updateAvailableQty(stockMoveLine, stockLocation);
            return;
        }
        BigDecimal availableQty = BigDecimal.ZERO;
        BigDecimal availableQtyForProduct = BigDecimal.ZERO;
        if (stockMoveLine.getProduct() != null) {
            if (stockMoveLine.getProduct().getTrackingNumberConfiguration() != null) {
                StockLocationLine stockLocationLineForProduct;
                StockLocationLine stockLocationLine;
                if (stockMoveLine.getTrackingNumber() != null && (stockLocationLine = this.stockLocationLineService.getDetailLocationLine(stockLocation, stockMoveLine.getProduct(), stockMoveLine.getTrackingNumber())) != null) {
                    availableQty = stockLocationLine.getCurrentQty().add(stockMoveLine.getReservedQty()).subtract(stockLocationLine.getReservedQty());
                }
                if (availableQty.compareTo(stockMoveLine.getRealQty()) < 0 && (stockLocationLineForProduct = this.stockLocationLineService.getStockLocationLine(stockLocation, stockMoveLine.getProduct())) != null) {
                    availableQtyForProduct = stockLocationLineForProduct.getCurrentQty().add(stockMoveLine.getReservedQty()).subtract(stockLocationLineForProduct.getReservedQty());
                }
            } else {
                StockLocationLine stockLocationLine = this.stockLocationLineService.getStockLocationLine(stockLocation, stockMoveLine.getProduct());
                if (stockLocationLine != null) {
                    availableQty = stockLocationLine.getCurrentQty().add(stockMoveLine.getReservedQty()).subtract(stockLocationLine.getReservedQty());
                }
            }
        }
        stockMoveLine.setAvailableQty(availableQty);
        stockMoveLine.setAvailableQtyForProduct(availableQtyForProduct);
    }

    @Override
    public StockMoveLine getMergedStockMoveLine(List<StockMoveLine> stockMoveLineList) throws AxelorException {
        Unit unit;
        String description;
        String productName;
        Product product;
        if (stockMoveLineList == null || stockMoveLineList.isEmpty()) {
            return null;
        }
        if (stockMoveLineList.size() == 1) {
            return stockMoveLineList.get(0);
        }
        SaleOrderLine saleOrderLine = stockMoveLineList.get(0).getSaleOrderLine();
        PurchaseOrderLine purchaseOrderLine = stockMoveLineList.get(0).getPurchaseOrderLine();
        BigDecimal quantity = BigDecimal.ZERO;
        if (saleOrderLine != null) {
            product = saleOrderLine.getProduct();
            productName = saleOrderLine.getProductName();
            description = saleOrderLine.getDescription();
            unit = saleOrderLine.getUnit();
        } else if (purchaseOrderLine != null) {
            product = purchaseOrderLine.getProduct();
            productName = purchaseOrderLine.getProductName();
            description = purchaseOrderLine.getDescription();
            unit = purchaseOrderLine.getUnit();
        } else {
            return null;
        }
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            quantity = quantity.add(stockMoveLine.getRealQty());
        }
        StockMoveLine generatedStockMoveLine = this.createStockMoveLine(product, productName, description, quantity, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, unit, null, null);
        generatedStockMoveLine.setSaleOrderLine(saleOrderLine);
        generatedStockMoveLine.setPurchaseOrderLine(purchaseOrderLine);
        return generatedStockMoveLine;
    }

    public void setProductInfo(StockMove stockMove, StockMoveLine stockMoveLine, Company company) throws AxelorException {
        if (!((AppBaseService)Beans.get(AppBaseService.class)).isApp("supplychain")) {
            super.setProductInfo(stockMove, stockMoveLine, company);
            return;
        }
        Preconditions.checkNotNull((Object)((Object)stockMoveLine));
        Preconditions.checkNotNull((Object)((Object)company));
        Product product = stockMoveLine.getProduct();
        if (product == null) {
            return;
        }
        super.setProductInfo(stockMove, stockMoveLine, company);
        SaleOrderLine saleOrderLine = stockMoveLine.getSaleOrderLine();
        PurchaseOrderLine purchaseOrderLine = stockMoveLine.getPurchaseOrderLine();
        if (saleOrderLine != null) {
            this.setProductInfoFromSaleOrder(stockMoveLine, saleOrderLine);
        }
        if (purchaseOrderLine != null) {
            this.setProductInfoFromPurchaseOrder(stockMoveLine, purchaseOrderLine);
        }
    }

    protected void setProductInfoFromSaleOrder(StockMoveLine stockMoveLine, SaleOrderLine saleOrderLine) {
        stockMoveLine.setUnit(saleOrderLine.getUnit());
        stockMoveLine.setProductName(saleOrderLine.getProductName());
        if (Strings.isNullOrEmpty((String)stockMoveLine.getDescription())) {
            stockMoveLine.setDescription(saleOrderLine.getDescription());
        }
        stockMoveLine.setQty(saleOrderLine.getQty());
    }

    protected void setProductInfoFromPurchaseOrder(StockMoveLine stockMoveLine, PurchaseOrderLine purchaseOrderLine) {
        stockMoveLine.setUnit(purchaseOrderLine.getUnit());
        stockMoveLine.setProductName(purchaseOrderLine.getProductName());
        if (Strings.isNullOrEmpty((String)stockMoveLine.getDescription())) {
            stockMoveLine.setDescription(purchaseOrderLine.getDescription());
        }
        stockMoveLine.setQty(purchaseOrderLine.getQty());
    }

    @Override
    public boolean isAvailableProduct(StockMove stockMove, StockMoveLine stockMoveLine) {
        BigDecimal realQty;
        if (stockMoveLine.getProduct() == null || stockMoveLine.getProduct() != null && !stockMoveLine.getProduct().getStockManaged().booleanValue()) {
            return true;
        }
        this.updateAvailableQty(stockMoveLine, stockMove.getFromStockLocation());
        BigDecimal availableQty = stockMoveLine.getAvailableQty();
        if (stockMoveLine.getProduct().getTrackingNumberConfiguration() != null && stockMoveLine.getTrackingNumber() == null) {
            availableQty = stockMoveLine.getAvailableQtyForProduct();
        }
        return availableQty.compareTo(realQty = stockMoveLine.getRealQty()) >= 0;
    }

    @Override
    public void setInvoiceStatus(StockMoveLine stockMoveLine) {
        if (stockMoveLine.getQtyInvoiced().compareTo(BigDecimal.ZERO) == 0) {
            stockMoveLine.setAvailableStatus(I18n.get((String)"Not invoiced"));
            stockMoveLine.setAvailableStatusSelect(3);
        } else if (stockMoveLine.getQtyInvoiced().compareTo(stockMoveLine.getRealQty()) == -1) {
            stockMoveLine.setAvailableStatus(I18n.get((String)"Partially invoiced"));
            stockMoveLine.setAvailableStatusSelect(4);
        } else if (stockMoveLine.getQtyInvoiced().compareTo(stockMoveLine.getRealQty()) == 0) {
            stockMoveLine.setAvailableStatus(I18n.get((String)"Invoiced"));
            stockMoveLine.setAvailableStatusSelect(1);
        }
    }
}

