/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.InvoiceLineTax;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.account.service.invoice.generator.invoice.RefundInvoice;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.supplychain.service.StockMoveInvoiceService;
import com.axelor.apps.supplychain.service.StockMoveMultiInvoiceService;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class StockMoveMultiInvoiceServiceImpl
implements StockMoveMultiInvoiceService {
    private InvoiceRepository invoiceRepository;
    private SaleOrderRepository saleOrderRepository;
    private PurchaseOrderRepository purchaseOrderRepository;
    private StockMoveInvoiceService stockMoveInvoiceService;

    @Inject
    public StockMoveMultiInvoiceServiceImpl(InvoiceRepository invoiceRepository, SaleOrderRepository saleOrderRepository, PurchaseOrderRepository purchaseOrderRepository, StockMoveInvoiceService stockMoveInvoiceService) {
        this.invoiceRepository = invoiceRepository;
        this.saleOrderRepository = saleOrderRepository;
        this.purchaseOrderRepository = purchaseOrderRepository;
        this.stockMoveInvoiceService = stockMoveInvoiceService;
    }

    @Override
    public Map.Entry<List<Long>, String> generateMultipleInvoices(List<Long> stockMoveIdList) {
        List stockMoveList;
        StockMoveRepository stockMoveRepository = (StockMoveRepository)((Object)Beans.get(StockMoveRepository.class));
        ArrayList<Long> invoiceIdList = new ArrayList<Long>();
        StringBuilder stockMovesInError = new StringBuilder();
        Query stockMoveQuery = stockMoveRepository.all().filter("self.id IN :stockMoveIdList").bind("stockMoveIdList", stockMoveIdList).order("id");
        int offset = 0;
        while (!(stockMoveList = stockMoveQuery.fetch(10, offset)).isEmpty()) {
            for (StockMove stockMove : stockMoveList) {
                ++offset;
                try {
                    Invoice invoice = this.stockMoveInvoiceService.createInvoice(stockMove, 0, null);
                    if (invoice == null) continue;
                    invoiceIdList.add(invoice.getId());
                }
                catch (Exception e) {
                    if (stockMovesInError.length() > 0) {
                        stockMovesInError.append("<br/>");
                    }
                    stockMovesInError.append(String.format(I18n.get((String)"The invoice for the stock move %s can't be generated because of this following error : %s"), stockMove.getName(), e.getLocalizedMessage()));
                    break;
                }
            }
            JPA.clear();
        }
        return new AbstractMap.SimpleImmutableEntry<List<Long>, String>(invoiceIdList, stockMovesInError.toString());
    }

    @Override
    public Map<String, Object> areFieldsConflictedToGenerateCustInvoice(List<StockMove> stockMoveList) throws AxelorException {
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        boolean paymentConditionToCheck = false;
        boolean paymentModeToCheck = false;
        boolean contactPartnerToCheck = false;
        this.checkForAlreadyInvoicedStockMove(stockMoveList);
        List<Invoice> dummyInvoiceList = stockMoveList.stream().map(this::createDummyOutInvoice).collect(Collectors.toList());
        this.checkOutStockMoveRequiredFieldsAreTheSame(dummyInvoiceList);
        if (!dummyInvoiceList.isEmpty()) {
            PaymentCondition firstPaymentCondition = dummyInvoiceList.get(0).getPaymentCondition();
            PaymentMode firstPaymentMode = dummyInvoiceList.get(0).getPaymentMode();
            Partner firstContactPartner = dummyInvoiceList.get(0).getContactPartner();
            paymentConditionToCheck = !dummyInvoiceList.stream().map(Invoice::getPaymentCondition).allMatch(paymentCondition -> Objects.equals(paymentCondition, firstPaymentCondition));
            paymentModeToCheck = !dummyInvoiceList.stream().map(Invoice::getPaymentMode).allMatch(paymentMode -> Objects.equals(paymentMode, (Object)firstPaymentMode));
            contactPartnerToCheck = !dummyInvoiceList.stream().map(Invoice::getContactPartner).allMatch(contactPartner -> Objects.equals(contactPartner, (Object)firstContactPartner));
            mapResult.put("paymentCondition", firstPaymentCondition);
            mapResult.put("paymentMode", (Object)firstPaymentMode);
            mapResult.put("contactPartner", (Object)firstContactPartner);
        }
        mapResult.put("paymentConditionToCheck", paymentConditionToCheck);
        mapResult.put("paymentModeToCheck", paymentModeToCheck);
        mapResult.put("contactPartnerToCheck", contactPartnerToCheck);
        return mapResult;
    }

    protected void checkOutStockMoveRequiredFieldsAreTheSame(List<Invoice> dummyInvoiceList) throws AxelorException {
        if (dummyInvoiceList == null || dummyInvoiceList.isEmpty()) {
            return;
        }
        Invoice firstDummyInvoice = dummyInvoiceList.get(0);
        for (Invoice dummyInvoice : dummyInvoiceList) {
            if (firstDummyInvoice.getCurrency() != null && !firstDummyInvoice.getCurrency().equals((Object)dummyInvoice.getCurrency())) {
                throw new AxelorException(5, I18n.get((String)"The currency is required and must be the same for all sale orders"));
            }
            if (firstDummyInvoice.getPartner() != null && !firstDummyInvoice.getPartner().equals((Object)dummyInvoice.getPartner())) {
                throw new AxelorException(5, I18n.get((String)"The client is required and must be the same for all sale orders"));
            }
            if (firstDummyInvoice.getCompany() != null && !firstDummyInvoice.getCompany().equals((Object)dummyInvoice.getCompany())) {
                throw new AxelorException(5, I18n.get((String)"The company is required and must be the same for all sale orders"));
            }
            if (firstDummyInvoice.getTradingName() != null && !firstDummyInvoice.getTradingName().equals((Object)dummyInvoice.getTradingName()) || firstDummyInvoice.getTradingName() == null && dummyInvoice.getTradingName() != null) {
                throw new AxelorException(5, I18n.get((String)"The trading name must be the same for all sale orders."));
            }
            if (firstDummyInvoice.getInAti() == null || firstDummyInvoice.getInAti().equals(dummyInvoice.getInAti())) continue;
            throw new AxelorException(5, I18n.get((String)"Unit prices in A.T.I and in W.T. can't be mix"));
        }
    }

    @Override
    public Map<String, Object> areFieldsConflictedToGenerateSupplierInvoice(List<StockMove> stockMoveList) throws AxelorException {
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        boolean paymentConditionToCheck = false;
        boolean paymentModeToCheck = false;
        boolean contactPartnerToCheck = false;
        this.checkForAlreadyInvoicedStockMove(stockMoveList);
        List<Invoice> dummyInvoiceList = stockMoveList.stream().map(this::createDummyInInvoice).collect(Collectors.toList());
        this.checkInStockMoveRequiredFieldsAreTheSame(dummyInvoiceList);
        if (!dummyInvoiceList.isEmpty()) {
            PaymentCondition firstPaymentCondition = dummyInvoiceList.get(0).getPaymentCondition();
            PaymentMode firstPaymentMode = dummyInvoiceList.get(0).getPaymentMode();
            Partner firstContactPartner = dummyInvoiceList.get(0).getContactPartner();
            paymentConditionToCheck = !dummyInvoiceList.stream().map(Invoice::getPaymentCondition).allMatch(paymentCondition -> Objects.equals(paymentCondition, firstPaymentCondition));
            paymentModeToCheck = !dummyInvoiceList.stream().map(Invoice::getPaymentMode).allMatch(paymentMode -> Objects.equals(paymentMode, (Object)firstPaymentMode));
            contactPartnerToCheck = !dummyInvoiceList.stream().map(Invoice::getContactPartner).allMatch(contactPartner -> Objects.equals(contactPartner, (Object)firstContactPartner));
            mapResult.put("paymentCondition", firstPaymentCondition);
            mapResult.put("paymentMode", (Object)firstPaymentMode);
            mapResult.put("contactPartner", (Object)firstContactPartner);
        }
        mapResult.put("paymentConditionToCheck", paymentConditionToCheck);
        mapResult.put("paymentModeToCheck", paymentModeToCheck);
        mapResult.put("contactPartnerToCheck", contactPartnerToCheck);
        return mapResult;
    }

    protected void checkInStockMoveRequiredFieldsAreTheSame(List<Invoice> dummyInvoiceList) throws AxelorException {
        if (dummyInvoiceList == null || dummyInvoiceList.isEmpty()) {
            return;
        }
        Invoice firstDummyInvoice = dummyInvoiceList.get(0);
        for (Invoice dummyInvoice : dummyInvoiceList) {
            if (firstDummyInvoice.getCurrency() != null && !firstDummyInvoice.getCurrency().equals((Object)dummyInvoice.getCurrency())) {
                throw new AxelorException(5, I18n.get((String)"The currency is required and must be the same for all sale orders"));
            }
            if (firstDummyInvoice.getPartner() != null && !firstDummyInvoice.getPartner().equals((Object)dummyInvoice.getPartner())) {
                throw new AxelorException(5, I18n.get((String)"The supplier is required and must be the same for all purchase orders"));
            }
            if (firstDummyInvoice.getCompany() != null && !firstDummyInvoice.getCompany().equals((Object)dummyInvoice.getCompany())) {
                throw new AxelorException(5, I18n.get((String)"The company is required and must be the same for all purchase orders"));
            }
            if (firstDummyInvoice.getTradingName() != null && !firstDummyInvoice.getTradingName().equals((Object)dummyInvoice.getTradingName()) || firstDummyInvoice.getTradingName() == null && dummyInvoice.getTradingName() != null) {
                throw new AxelorException(5, I18n.get((String)"The trading name must be the same for all purchase orders."));
            }
            if (firstDummyInvoice.getInAti() == null || firstDummyInvoice.getInAti().equals(dummyInvoice.getInAti())) continue;
            throw new AxelorException(5, I18n.get((String)"Unit prices in A.T.I and in W.T. can't be mix"));
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Optional<Invoice> createInvoiceFromMultiOutgoingStockMove(List<StockMove> stockMoveList, PaymentCondition paymentConditionIn, PaymentMode paymentModeIn, Partner contactPartnerIn) throws AxelorException {
        Optional<Invoice> invoiceOpt = this.createInvoiceFromMultiOutgoingStockMove(stockMoveList);
        invoiceOpt.ifPresent(invoice -> this.fillInvoiceFromMultiStockMoveDefaultValues((Invoice)((Object)invoice), paymentConditionIn, paymentModeIn, contactPartnerIn));
        return invoiceOpt;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Optional<Invoice> createInvoiceFromMultiOutgoingStockMove(List<StockMove> stockMoveList) throws AxelorException {
        if (stockMoveList == null || stockMoveList.isEmpty()) {
            return Optional.empty();
        }
        Invoice dummyInvoice = this.createDummyOutInvoice(stockMoveList.get(0));
        for (StockMove stockMove : stockMoveList) {
            this.completeInvoiceInMultiOutgoingStockMove(dummyInvoice, stockMove);
        }
        if (dummyInvoice.getAddress() == null) {
            dummyInvoice.setAddress(((PartnerService)Beans.get(PartnerService.class)).getInvoicingAddress(dummyInvoice.getPartner()));
            dummyInvoice.setAddressStr(((AddressService)Beans.get(AddressService.class)).computeAddressStr(dummyInvoice.getAddress()));
        }
        this.fillReferenceInvoiceFromMultiOutStockMove(stockMoveList, dummyInvoice);
        InvoiceGenerator invoiceGenerator = new InvoiceGenerator(3, dummyInvoice.getCompany(), dummyInvoice.getPaymentCondition(), dummyInvoice.getPaymentMode(), dummyInvoice.getAddress(), dummyInvoice.getPartner(), dummyInvoice.getContactPartner(), dummyInvoice.getCurrency(), dummyInvoice.getPriceList(), dummyInvoice.getInternalReference(), dummyInvoice.getExternalReference(), dummyInvoice.getInAti(), null, dummyInvoice.getTradingName()){

            public Invoice generate() throws AxelorException {
                return super.createInvoiceHeader();
            }
        };
        Invoice invoice = invoiceGenerator.generate();
        invoice.setAddressStr(dummyInvoice.getAddressStr());
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        for (StockMove stockMoveLocal : stockMoveList) {
            List<InvoiceLine> createdInvoiceLines = this.stockMoveInvoiceService.createInvoiceLines(invoice, stockMoveLocal.getStockMoveLineList(), null);
            if (stockMoveLocal.getTypeSelect() == 3) {
                createdInvoiceLines.forEach(this::negateInvoiceLinePrice);
            }
            invoiceLineList.addAll(createdInvoiceLines);
        }
        invoiceGenerator.populate(invoice, invoiceLineList);
        this.invoiceRepository.save((Model)((Object)invoice));
        invoice = this.toPositivePriceInvoice(invoice);
        stockMoveList.forEach(invoice::addStockMoveSetItem);
        return Optional.of(invoice);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Optional<Invoice> createInvoiceFromMultiIncomingStockMove(List<StockMove> stockMoveList, PaymentCondition paymentConditionIn, PaymentMode paymentModeIn, Partner contactPartnerIn) throws AxelorException {
        Optional<Invoice> invoiceOpt = this.createInvoiceFromMultiIncomingStockMove(stockMoveList);
        invoiceOpt.ifPresent(invoice -> this.fillInvoiceFromMultiStockMoveDefaultValues((Invoice)((Object)invoice), paymentConditionIn, paymentModeIn, contactPartnerIn));
        return invoiceOpt;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Optional<Invoice> createInvoiceFromMultiIncomingStockMove(List<StockMove> stockMoveList) throws AxelorException {
        if (stockMoveList == null || stockMoveList.isEmpty()) {
            return Optional.empty();
        }
        Invoice dummyInvoice = this.createDummyInInvoice(stockMoveList.get(0));
        for (StockMove stockMove : stockMoveList) {
            this.completeInvoiceInMultiIncomingStockMove(dummyInvoice, stockMove);
        }
        if (dummyInvoice.getAddress() == null) {
            dummyInvoice.setAddress(((PartnerService)Beans.get(PartnerService.class)).getInvoicingAddress(dummyInvoice.getPartner()));
            dummyInvoice.setAddressStr(((AddressService)Beans.get(AddressService.class)).computeAddressStr(dummyInvoice.getAddress()));
        }
        this.fillReferenceInvoiceFromMultiInStockMove(stockMoveList, dummyInvoice);
        InvoiceGenerator invoiceGenerator = new InvoiceGenerator(1, dummyInvoice.getCompany(), dummyInvoice.getPaymentCondition(), dummyInvoice.getPaymentMode(), dummyInvoice.getAddress(), dummyInvoice.getPartner(), dummyInvoice.getContactPartner(), dummyInvoice.getCurrency(), dummyInvoice.getPriceList(), dummyInvoice.getInternalReference(), dummyInvoice.getExternalReference(), dummyInvoice.getInAti(), null, dummyInvoice.getTradingName()){

            public Invoice generate() throws AxelorException {
                return super.createInvoiceHeader();
            }
        };
        Invoice invoice = invoiceGenerator.generate();
        invoice.setAddressStr(dummyInvoice.getAddressStr());
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        for (StockMove stockMoveLocal : stockMoveList) {
            List<InvoiceLine> createdInvoiceLines = this.stockMoveInvoiceService.createInvoiceLines(invoice, stockMoveLocal.getStockMoveLineList(), null);
            if (stockMoveLocal.getTypeSelect() == 2) {
                createdInvoiceLines.forEach(this::negateInvoiceLinePrice);
            }
            invoiceLineList.addAll(createdInvoiceLines);
        }
        invoiceGenerator.populate(invoice, invoiceLineList);
        this.invoiceRepository.save((Model)((Object)invoice));
        invoice = this.toPositivePriceInvoice(invoice);
        stockMoveList.forEach(invoice::addStockMoveSetItem);
        return Optional.of(invoice);
    }

    protected Invoice toPositivePriceInvoice(Invoice invoice) throws AxelorException {
        if (invoice.getExTaxTotal().signum() < 0) {
            Invoice refund = this.transformToRefund(invoice);
            this.invoiceRepository.remove((Model)((Object)invoice));
            return refund;
        }
        return invoice;
    }

    protected Invoice transformToRefund(Invoice invoice) throws AxelorException {
        Invoice refund = new RefundInvoice(invoice).generate();
        if (refund.getInvoiceLineList() != null) {
            for (InvoiceLine invoiceLine : refund.getInvoiceLineList()) {
                invoiceLine.setPrice(invoiceLine.getPrice().negate());
                invoiceLine.setPriceDiscounted(invoiceLine.getPriceDiscounted().negate());
                invoiceLine.setInTaxPrice(invoiceLine.getInTaxPrice().negate());
                invoiceLine.setExTaxTotal(invoiceLine.getExTaxTotal().negate());
                invoiceLine.setInTaxTotal(invoiceLine.getInTaxTotal().negate());
                invoiceLine.setCompanyExTaxTotal(invoiceLine.getCompanyExTaxTotal().negate());
                invoiceLine.setCompanyInTaxTotal(invoiceLine.getCompanyInTaxTotal().negate());
            }
        }
        if (refund.getInvoiceLineTaxList() != null) {
            for (InvoiceLineTax invoiceLineTax : refund.getInvoiceLineTaxList()) {
                invoiceLineTax.setExTaxBase(invoiceLineTax.getExTaxBase().negate());
                invoiceLineTax.setTaxTotal(invoiceLineTax.getTaxTotal().negate());
                invoiceLineTax.setCompanyExTaxBase(invoiceLineTax.getCompanyExTaxBase().negate());
                invoiceLineTax.setInTaxTotal(invoiceLineTax.getInTaxTotal().negate());
                invoiceLineTax.setCompanyInTaxTotal(invoiceLineTax.getCompanyInTaxTotal().negate());
            }
        }
        refund.setExTaxTotal(refund.getExTaxTotal().negate());
        refund.setInTaxTotal(refund.getInTaxTotal().negate());
        refund.setCompanyExTaxTotal(refund.getCompanyExTaxTotal().negate());
        refund.setCompanyInTaxTotal(refund.getCompanyInTaxTotal().negate());
        refund.setTaxTotal(refund.getTaxTotal().negate());
        refund.setAmountRemaining(refund.getAmountRemaining().negate());
        refund.setCompanyTaxTotal(refund.getCompanyTaxTotal().negate());
        return (Invoice)((Object)this.invoiceRepository.save((Model)((Object)refund)));
    }

    protected void fillInvoiceFromMultiStockMoveDefaultValues(Invoice invoice, PaymentCondition paymentConditionIn, PaymentMode paymentModeIn, Partner contactPartnerIn) {
        invoice.setPaymentCondition(paymentConditionIn);
        invoice.setPaymentMode(paymentModeIn);
        invoice.setContactPartner(contactPartnerIn);
    }

    protected Invoice createDummyOutInvoice(StockMove stockMove) {
        Invoice dummyInvoice = new Invoice();
        if (stockMove.getOriginId() != null && "com.axelor.apps.sale.db.SaleOrder".equals(stockMove.getOriginTypeSelect())) {
            SaleOrder saleOrder = (SaleOrder)((Object)this.saleOrderRepository.find(stockMove.getOriginId()));
            dummyInvoice.setCurrency(saleOrder.getCurrency());
            dummyInvoice.setPartner(saleOrder.getClientPartner());
            dummyInvoice.setCompany(saleOrder.getCompany());
            dummyInvoice.setTradingName(saleOrder.getTradingName());
            dummyInvoice.setPaymentCondition(saleOrder.getPaymentCondition());
            dummyInvoice.setPaymentMode(saleOrder.getPaymentMode());
            dummyInvoice.setAddress(saleOrder.getMainInvoicingAddress());
            dummyInvoice.setAddressStr(saleOrder.getMainInvoicingAddressStr());
            dummyInvoice.setContactPartner(saleOrder.getContactPartner());
            dummyInvoice.setPriceList(saleOrder.getPriceList());
            dummyInvoice.setInAti(saleOrder.getInAti());
        } else {
            dummyInvoice.setCurrency(stockMove.getCompany().getCurrency());
            dummyInvoice.setPartner(stockMove.getPartner());
            dummyInvoice.setCompany(stockMove.getCompany());
            dummyInvoice.setTradingName(stockMove.getTradingName());
            dummyInvoice.setAddress(stockMove.getToAddress());
            dummyInvoice.setAddressStr(stockMove.getToAddressStr());
        }
        return dummyInvoice;
    }

    protected Invoice createDummyInInvoice(StockMove stockMove) {
        Invoice dummyInvoice = new Invoice();
        if (stockMove.getOriginId() != null && "com.axelor.apps.purchase.db.PurchaseOrder".equals(stockMove.getOriginTypeSelect())) {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)this.purchaseOrderRepository.find(stockMove.getOriginId()));
            dummyInvoice.setCurrency(purchaseOrder.getCurrency());
            dummyInvoice.setPartner(purchaseOrder.getSupplierPartner());
            dummyInvoice.setCompany(purchaseOrder.getCompany());
            dummyInvoice.setTradingName(purchaseOrder.getTradingName());
            dummyInvoice.setPaymentCondition(purchaseOrder.getPaymentCondition());
            dummyInvoice.setPaymentMode(purchaseOrder.getPaymentMode());
            dummyInvoice.setContactPartner(purchaseOrder.getContactPartner());
            dummyInvoice.setPriceList(purchaseOrder.getPriceList());
            dummyInvoice.setInAti(purchaseOrder.getInAti());
        } else {
            dummyInvoice.setCurrency(stockMove.getCompany().getCurrency());
            dummyInvoice.setPartner(stockMove.getPartner());
            dummyInvoice.setCompany(stockMove.getCompany());
            dummyInvoice.setTradingName(stockMove.getTradingName());
            dummyInvoice.setAddress(stockMove.getFromAddress());
            dummyInvoice.setAddressStr(stockMove.getFromAddressStr());
        }
        return dummyInvoice;
    }

    @Override
    public void checkForAlreadyInvoicedStockMove(List<StockMove> stockMoveList) throws AxelorException {
        StringBuilder invoiceAlreadyGeneratedMessage = new StringBuilder();
        for (StockMove stockMove : stockMoveList) {
            try {
                this.checkIfAlreadyInvoiced(stockMove);
            }
            catch (AxelorException e) {
                if (invoiceAlreadyGeneratedMessage.length() > 0) {
                    invoiceAlreadyGeneratedMessage.append("<br/>");
                }
                invoiceAlreadyGeneratedMessage.append(e.getMessage());
            }
        }
        if (invoiceAlreadyGeneratedMessage.length() > 0) {
            throw new AxelorException(5, invoiceAlreadyGeneratedMessage.toString());
        }
    }

    protected void checkIfAlreadyInvoiced(StockMove stockMove) throws AxelorException {
        if (stockMove.getInvoiceSet() != null && stockMove.getInvoiceSet().stream().anyMatch(invoice -> invoice.getStatusSelect() != 4)) {
            String templateMessage = stockMove.getTypeSelect() == 2 ? "An invoice not canceled already exists for the outgoing stock move %s" : "An invoice not canceled already exists for the incoming stock move %s";
            throw new AxelorException(5, I18n.get((String)templateMessage), new Object[]{stockMove.getName()});
        }
    }

    protected void completeInvoiceInMultiOutgoingStockMove(Invoice dummyInvoice, StockMove stockMove) {
        if (stockMove.getOriginId() != null && "com.axelor.apps.sale.db.SaleOrder".equals(stockMove.getOriginTypeSelect())) {
            return;
        }
        Invoice comparedDummyInvoice = this.createDummyOutInvoice(stockMove);
        if (dummyInvoice.getPaymentCondition() != null && !dummyInvoice.getPaymentCondition().equals((Object)comparedDummyInvoice.getPaymentCondition())) {
            dummyInvoice.setPaymentCondition(null);
        }
        if (dummyInvoice.getPaymentMode() != null && !dummyInvoice.getPaymentMode().equals((Object)comparedDummyInvoice.getPaymentMode())) {
            dummyInvoice.setPaymentMode(null);
        }
        if (dummyInvoice.getAddress() != null && !dummyInvoice.getAddress().equals((Object)comparedDummyInvoice.getAddress())) {
            dummyInvoice.setAddress(null);
            dummyInvoice.setAddressStr(null);
        }
        if (dummyInvoice.getContactPartner() != null && !dummyInvoice.getContactPartner().equals((Object)comparedDummyInvoice.getContactPartner())) {
            dummyInvoice.setContactPartner(null);
        }
        if (dummyInvoice.getPriceList() != null && !dummyInvoice.getPriceList().equals((Object)comparedDummyInvoice.getPriceList())) {
            dummyInvoice.setPriceList(null);
        }
    }

    protected void completeInvoiceInMultiIncomingStockMove(Invoice dummyInvoice, StockMove stockMove) {
        if (stockMove.getOriginId() != null && "com.axelor.apps.purchase.db.PurchaseOrder".equals(stockMove.getOriginTypeSelect())) {
            return;
        }
        Invoice comparedDummyInvoice = this.createDummyInInvoice(stockMove);
        if (dummyInvoice.getPaymentCondition() != null && !dummyInvoice.getPaymentCondition().equals((Object)comparedDummyInvoice.getPaymentCondition())) {
            dummyInvoice.setPaymentCondition(null);
        }
        if (dummyInvoice.getPaymentMode() != null && !dummyInvoice.getPaymentMode().equals((Object)comparedDummyInvoice.getPaymentMode())) {
            dummyInvoice.setPaymentMode(null);
        }
        if (dummyInvoice.getContactPartner() != null && !dummyInvoice.getContactPartner().equals((Object)comparedDummyInvoice.getContactPartner())) {
            dummyInvoice.setContactPartner(null);
        }
        if (dummyInvoice.getPriceList() != null && !dummyInvoice.getPriceList().equals((Object)comparedDummyInvoice.getPriceList())) {
            dummyInvoice.setPriceList(null);
        }
    }

    protected void fillReferenceInvoiceFromMultiOutStockMove(List<StockMove> stockMoveList, Invoice dummyInvoice) {
        ArrayList<String> externalRefList = new ArrayList<String>();
        ArrayList<String> internalRefList = new ArrayList<String>();
        for (StockMove stockMove : stockMoveList) {
            SaleOrder saleOrder;
            SaleOrder saleOrder2 = saleOrder = "com.axelor.apps.sale.db.SaleOrder".equals(stockMove.getOriginTypeSelect()) && stockMove.getOriginId() != null ? (SaleOrder)((Object)this.saleOrderRepository.find(stockMove.getOriginId())) : null;
            if (saleOrder != null) {
                externalRefList.add(saleOrder.getExternalReference());
            }
            internalRefList.add(stockMove.getStockMoveSeq() + (saleOrder != null ? ":" + saleOrder.getSaleOrderSeq() : ""));
        }
        String externalRef = String.join((CharSequence)"|", externalRefList);
        String internalRef = String.join((CharSequence)"|", internalRefList);
        dummyInvoice.setExternalReference(StringTool.cutTooLongString((String)externalRef));
        dummyInvoice.setInternalReference(StringTool.cutTooLongString((String)internalRef));
    }

    protected void fillReferenceInvoiceFromMultiInStockMove(List<StockMove> stockMoveList, Invoice dummyInvoice) {
        ArrayList<String> externalRefList = new ArrayList<String>();
        ArrayList<String> internalRefList = new ArrayList<String>();
        for (StockMove stockMove : stockMoveList) {
            PurchaseOrder purchaseOrder;
            PurchaseOrder purchaseOrder2 = purchaseOrder = "com.axelor.apps.purchase.db.PurchaseOrder".equals(stockMove.getOriginTypeSelect()) && stockMove.getOriginId() != null ? (PurchaseOrder)((Object)this.purchaseOrderRepository.find(stockMove.getOriginId())) : null;
            if (purchaseOrder != null) {
                externalRefList.add(purchaseOrder.getExternalReference());
            }
            internalRefList.add(stockMove.getStockMoveSeq() + (purchaseOrder != null ? ":" + purchaseOrder.getPurchaseOrderSeq() : ""));
        }
        String externalRef = String.join((CharSequence)"|", externalRefList);
        String internalRef = String.join((CharSequence)"|", internalRefList);
        dummyInvoice.setExternalReference(StringTool.cutTooLongString((String)externalRef));
        dummyInvoice.setInternalReference(StringTool.cutTooLongString((String)internalRef));
    }

    protected void negateInvoiceLinePrice(InvoiceLine invoiceLine) {
        invoiceLine.setPrice(invoiceLine.getPrice().negate());
        invoiceLine.setPriceDiscounted(invoiceLine.getPriceDiscounted().negate());
        invoiceLine.setInTaxPrice(invoiceLine.getInTaxPrice().negate());
        invoiceLine.setDiscountAmount(invoiceLine.getDiscountAmount().negate());
        invoiceLine.setInTaxTotal(invoiceLine.getInTaxTotal().negate());
        invoiceLine.setCompanyInTaxTotal(invoiceLine.getCompanyInTaxTotal().negate());
        invoiceLine.setExTaxTotal(invoiceLine.getExTaxTotal().negate());
        invoiceLine.setCompanyExTaxTotal(invoiceLine.getCompanyExTaxTotal().negate());
    }
}

