/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.batch;

import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.batch.BatchStrategy;
import com.axelor.apps.supplychain.service.invoice.SubscriptionInvoiceService;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchInvoicing
extends BatchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private SubscriptionInvoiceService subscriptionInvoiceService;

    @Inject
    public BatchInvoicing(SaleOrderInvoiceService saleOrderInvoiceService) {
        super(saleOrderInvoiceService);
    }

    protected void process() {
        List<SaleOrder> saleOrders = this.subscriptionInvoiceService.getSubscriptionOrders(10);
        while (!saleOrders.isEmpty()) {
            for (SaleOrder saleOrder : saleOrders) {
                try {
                    this.subscriptionInvoiceService.generateSubscriptionInvoice(saleOrder);
                    this.updateSaleOrder(saleOrder);
                }
                catch (AxelorException e) {
                    TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Order %s"), new Object[]{saleOrder.getSaleOrderSeq()}), (String)"invoice", (long)this.batch.getId());
                    this.incrementAnomaly();
                }
                catch (Exception e) {
                    TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Order %s"), saleOrder.getSaleOrderSeq()), e), (String)"invoice", (long)this.batch.getId());
                    this.incrementAnomaly();
                    LOG.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour le devis {}", (Object)saleOrder.getSaleOrderSeq());
                }
            }
            JPA.clear();
            saleOrders = this.subscriptionInvoiceService.getSubscriptionOrders(10);
        }
    }

    protected void stop() {
        String comment = I18n.get((String)"Subscription invoice generation report :") + " ";
        comment = comment + String.format("\t* %s " + I18n.get((String)"Order(s) processed") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }
}

