/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.batch;

import com.axelor.apps.base.db.repo.BlockingRepository;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.supplychain.db.SupplychainBatch;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.batch.BatchOrderInvoicing;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class BatchOrderInvoicingSale
extends BatchOrderInvoicing {
    protected void process() {
        List saleOrderList;
        SupplychainBatch supplychainBatch = this.batch.getSupplychainBatch();
        ArrayList<String> filterList = new ArrayList<String>();
        Query query = ((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).all();
        if (supplychainBatch.getCompany() != null) {
            filterList.add("self.company = :company");
            query.bind("company", (Object)supplychainBatch.getCompany());
        }
        if (supplychainBatch.getSalespersonOrBuyerSet() != null && !supplychainBatch.getSalespersonOrBuyerSet().isEmpty()) {
            filterList.add("self.salemanUser IN (:salespersonSet)");
            query.bind("salespersonSet", supplychainBatch.getSalespersonOrBuyerSet());
        }
        if (supplychainBatch.getTeam() != null) {
            filterList.add("self.team = :team OR self.team IS NULL AND self.salemanUser IS NOT NULL AND self.salemanUser.activeTeam = :team");
            query.bind("team", (Object)supplychainBatch.getTeam());
        }
        if (!Strings.isNullOrEmpty((String)supplychainBatch.getDeliveryOrReceiptState())) {
            List delivereyStateList = StringTool.getIntegerList((String)supplychainBatch.getDeliveryOrReceiptState());
            filterList.add("self.deliveryState IN (:delivereyStateList)");
            query.bind("delivereyStateList", (Object)delivereyStateList);
        }
        if (!Strings.isNullOrEmpty((String)supplychainBatch.getStatusSelect())) {
            List statusSelectList = StringTool.getIntegerList((String)supplychainBatch.getStatusSelect());
            filterList.add("self.statusSelect IN (:statusSelectList)");
            query.bind("statusSelectList", (Object)statusSelectList);
        }
        if (supplychainBatch.getOrderUpToDate() != null) {
            filterList.add("self.orderDate <= :orderUpToDate");
            query.bind("orderUpToDate", (Object)supplychainBatch.getOrderUpToDate());
        }
        filterList.add("self.amountInvoiced < self.exTaxTotal");
        filterList.add("NOT EXISTS (SELECT 1 FROM Invoice invoice WHERE invoice.statusSelect != :invoiceStatusSelect AND (invoice.saleOrder = self OR invoice.saleOrder IS NULL AND EXISTS (SELECT 1 FROM invoice.invoiceLineList invoiceLine WHERE invoiceLine.saleOrderLine MEMBER OF self.saleOrderLineList)))");
        filterList.add("self.clientPartner.id NOT IN (" + ((BlockingService)Beans.get(BlockingService.class)).listOfBlockedPartner(supplychainBatch.getCompany(), BlockingRepository.INVOICING_BLOCKING.intValue()) + ")");
        query.bind("invoiceStatusSelect", (Object)4);
        ArrayList anomalyList = Lists.newArrayList((Object[])new Long[]{0L});
        filterList.add("self.id NOT IN (:anomalyList)");
        query.bind("anomalyList", (Object)anomalyList);
        String filter = filterList.stream().map(item -> String.format("(%s)", item)).collect(Collectors.joining(" AND "));
        query.filter(filter);
        SaleOrderInvoiceService saleOrderInvoiceService = (SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class);
        HashSet<Long> treatedSet = new HashSet<Long>();
        while (!(saleOrderList = query.fetch(10)).isEmpty()) {
            for (SaleOrder saleOrder : saleOrderList) {
                if (treatedSet.contains(saleOrder.getId())) {
                    throw new IllegalArgumentException("Invoice generation error");
                }
                treatedSet.add(saleOrder.getId());
                try {
                    saleOrderInvoiceService.generateInvoice(saleOrder);
                    this.incrementDone();
                }
                catch (Exception e) {
                    this.incrementAnomaly();
                    anomalyList.add(saleOrder.getId());
                    query.bind("anomalyList", (Object)anomalyList);
                    TraceBackService.trace((Throwable)e, (String)"invoice", (long)this.batch.getId());
                    e.printStackTrace();
                    break;
                }
            }
            JPA.clear();
        }
    }
}

