/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.batch;

import com.axelor.apps.base.db.repo.BlockingRepository;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.supplychain.db.SupplychainBatch;
import com.axelor.apps.supplychain.service.StockMoveInvoiceService;
import com.axelor.db.JPA;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.TypedQuery;

public class BatchOutgoingStockMoveInvoicing
extends AbstractBatch {
    private StockMoveInvoiceService stockMoveInvoiceService;

    @Inject
    public BatchOutgoingStockMoveInvoicing(StockMoveInvoiceService stockMoveInvoiceService) {
        this.stockMoveInvoiceService = stockMoveInvoiceService;
    }

    protected void process() {
        List stockMoveList;
        SupplychainBatch supplychainBatch = this.batch.getSupplychainBatch();
        ArrayList anomalyList = Lists.newArrayList((Object[])new Long[]{0L});
        SaleOrderRepository saleRepo = (SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class));
        int start = 0;
        TypedQuery query = JPA.em().createQuery("SELECT self FROM StockMove self LEFT JOIN self.invoice invoice WHERE self.statusSelect = :statusSelect AND self.originTypeSelect LIKE :typeSaleOrder AND (invoice IS NULL OR self.invoice.statusSelect = :invoiceStatusSelect)AND self.id NOT IN (:anomalyList) AND self.partner.id NOT IN (" + ((BlockingService)Beans.get(BlockingService.class)).listOfBlockedPartner(supplychainBatch.getCompany(), BlockingRepository.INVOICING_BLOCKING.intValue()) + ")", StockMove.class).setParameter("statusSelect", (Object)3).setParameter("typeSaleOrder", (Object)"com.axelor.apps.sale.db.SaleOrder").setParameter("invoiceStatusSelect", (Object)4).setParameter("anomalyList", (Object)anomalyList).setMaxResults(10);
        while (!(stockMoveList = query.getResultList()).isEmpty()) {
            for (StockMove stockMove : stockMoveList) {
                try {
                    this.stockMoveInvoiceService.createInvoiceFromSaleOrder(stockMove, (SaleOrder)((Object)saleRepo.find(stockMove.getOriginId())), null);
                    this.incrementDone();
                }
                catch (Exception e) {
                    this.incrementAnomaly();
                    anomalyList.add(stockMove.getId());
                    query.setParameter("anomalyList", (Object)anomalyList);
                    TraceBackService.trace((Throwable)e, (String)"invoice", (long)this.batch.getId());
                    e.printStackTrace();
                    break;
                }
            }
            JPA.clear();
            query.setFirstResult(start += 10);
        }
    }

    protected void stop() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.get((String)"Outgoing stock move invoicing report:"));
        sb.append(String.format(I18n.get((String)"%d outgoing stock move processed successfully,", (String)"%d outgoing stock moves processed successfully,", (int)this.batch.getDone()), this.batch.getDone()));
        sb.append(String.format(I18n.get((String)"%d anomaly.", (String)"%d anomalies.", (int)this.batch.getAnomaly()), this.batch.getAnomaly()));
        this.addComment(sb.toString());
        super.stop();
    }
}

