/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.batch;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.service.administration.AbstractBatchService;
import com.axelor.apps.supplychain.db.SupplychainBatch;
import com.axelor.apps.supplychain.service.batch.BatchAccountingCutOff;
import com.axelor.apps.supplychain.service.batch.BatchOrderInvoicingPurchase;
import com.axelor.apps.supplychain.service.batch.BatchOrderInvoicingSale;
import com.axelor.apps.supplychain.service.batch.BatchOutgoingStockMoveInvoicing;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;

public class SupplychainBatchService
extends AbstractBatchService {
    protected Class<? extends Model> getModelClass() {
        return SupplychainBatch.class;
    }

    public Batch run(Model batchModel) throws AxelorException {
        Batch batch;
        SupplychainBatch supplychainBatch = (SupplychainBatch)((Object)batchModel);
        switch (supplychainBatch.getActionSelect()) {
            case 1: {
                batch = this.accountingCutOff(supplychainBatch);
                break;
            }
            case 2: {
                batch = this.invoiceOutgoingStockMoves(supplychainBatch);
                break;
            }
            case 3: {
                batch = this.invoiceOrders(supplychainBatch);
                break;
            }
            default: {
                throw new AxelorException(5, I18n.get((String)"Unknown action %s for the %s treatment"), new Object[]{supplychainBatch.getActionSelect(), supplychainBatch.getCode()});
            }
        }
        return batch;
    }

    public Batch accountingCutOff(SupplychainBatch supplychainBatch) {
        return ((BatchAccountingCutOff)((Object)Beans.get(BatchAccountingCutOff.class))).run(supplychainBatch);
    }

    public Batch invoiceOutgoingStockMoves(SupplychainBatch supplychainBatch) {
        return ((BatchOutgoingStockMoveInvoicing)((Object)Beans.get(BatchOutgoingStockMoveInvoicing.class))).run(supplychainBatch);
    }

    public Batch invoiceOrders(SupplychainBatch supplychainBatch) {
        switch (supplychainBatch.getInvoiceOrdersTypeSelect()) {
            case 1: {
                return ((BatchOrderInvoicingSale)((Object)Beans.get(BatchOrderInvoicingSale.class))).run(supplychainBatch);
            }
            case 2: {
                return ((BatchOrderInvoicingPurchase)((Object)Beans.get(BatchOrderInvoicingPurchase.class))).run(supplychainBatch);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown invoice orders type: %d", supplychainBatch.getInvoiceOrdersTypeSelect()));
    }
}

