/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.invoice;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.InvoiceLineService;
import com.axelor.apps.account.service.invoice.InvoiceServiceImpl;
import com.axelor.apps.account.service.invoice.factory.CancelFactory;
import com.axelor.apps.account.service.invoice.factory.ValidateFactory;
import com.axelor.apps.account.service.invoice.factory.VentilateFactory;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.alarm.AlarmEngineService;
import com.axelor.apps.sale.db.AdvancePayment;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.supplychain.db.Timetable;
import com.axelor.apps.supplychain.db.repo.TimetableRepository;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.apps.supplychain.service.invoice.InvoiceServiceSupplychain;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class InvoiceServiceSupplychainImpl
extends InvoiceServiceImpl
implements InvoiceServiceSupplychain {
    @Inject
    public InvoiceServiceSupplychainImpl(ValidateFactory validateFactory, VentilateFactory ventilateFactory, CancelFactory cancelFactory, AlarmEngineService<Invoice> alarmEngineService, InvoiceRepository invoiceRepo, AppAccountService appAccountService, PartnerService partnerService, InvoiceLineService invoiceLineService, AccountConfigService accountConfigService) {
        super(validateFactory, ventilateFactory, cancelFactory, alarmEngineService, invoiceRepo, appAccountService, partnerService, invoiceLineService, accountConfigService);
    }

    @Transactional(rollbackOn={Exception.class})
    public void ventilate(Invoice invoice) throws AxelorException {
        super.ventilate(invoice);
        TimetableRepository timeTableRepo = (TimetableRepository)((Object)Beans.get(TimetableRepository.class));
        List timetableList = timeTableRepo.all().filter("self.invoice.id = ?1", new Object[]{invoice.getId()}).fetch();
        for (Timetable timetable : timetableList) {
            timetable.setInvoiced(true);
            timeTableRepo.save((Model)((Object)timetable));
        }
    }

    public Set<Invoice> getDefaultAdvancePaymentInvoice(Invoice invoice) throws AxelorException {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.getDefaultAdvancePaymentInvoice(invoice);
        }
        SaleOrder saleOrder = invoice.getSaleOrder();
        Company company = invoice.getCompany();
        Currency currency = invoice.getCurrency();
        if (company == null || saleOrder == null) {
            return super.getDefaultAdvancePaymentInvoice(invoice);
        }
        boolean generateMoveForInvoicePayment = ((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(company).getGenerateMoveForInvoicePayment();
        String filter = this.writeGeneralFilterForAdvancePayment();
        filter = filter + " AND self.saleOrder = :_saleOrder";
        if (!generateMoveForInvoicePayment) {
            filter = filter + " AND self.currency = :_currency";
        }
        Query query = ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).all().filter(filter).bind("_status", (Object)2).bind("_operationSubType", (Object)2).bind("_saleOrder", (Object)saleOrder);
        if (!generateMoveForInvoicePayment) {
            if (currency == null) {
                return new HashSet<Invoice>();
            }
            query.bind("_currency", (Object)currency);
        }
        HashSet<Invoice> advancePaymentInvoices = new HashSet<Invoice>(query.fetch());
        this.filterAdvancePaymentInvoice(invoice, advancePaymentInvoices);
        return advancePaymentInvoices;
    }

    public List<MoveLine> getMoveLinesFromSOAdvancePayments(Invoice invoice) {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.getMoveLinesFromSOAdvancePayments(invoice);
        }
        SaleOrder saleOrder = invoice.getSaleOrder();
        List saleOrderList = invoice.getInvoiceLineList().stream().map(invoiceLine -> invoice.getSaleOrder()).collect(Collectors.toList());
        saleOrderList.add(saleOrder);
        saleOrderList = saleOrderList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (saleOrderList.isEmpty()) {
            return new ArrayList<MoveLine>();
        }
        return saleOrderList.stream().flatMap(saleOrder1 -> saleOrder1.getAdvancePaymentList().stream()).filter(Objects::nonNull).distinct().map(AdvancePayment::getMove).filter(Objects::nonNull).distinct().flatMap(move -> move.getMoveLineList().stream()).collect(Collectors.toList());
    }

    @Override
    public List<InvoiceLine> addSubLines(List<InvoiceLine> invoiceLine) {
        if (invoiceLine == null) {
            return invoiceLine;
        }
        ArrayList<InvoiceLine> lines = new ArrayList<InvoiceLine>();
        lines.addAll(invoiceLine);
        for (InvoiceLine line : lines) {
            if (line.getSubLineList() == null) continue;
            for (InvoiceLine subLine : line.getSubLineList()) {
                if (subLine.getInvoice() != null) continue;
                invoiceLine.add(subLine);
            }
        }
        return invoiceLine;
    }

    @Override
    public List<InvoiceLine> removeSubLines(List<InvoiceLine> invoiceLines) {
        if (invoiceLines == null) {
            return invoiceLines;
        }
        ArrayList<InvoiceLine> subLines = new ArrayList<InvoiceLine>();
        for (InvoiceLine packLine : invoiceLines) {
            if (packLine.getTypeSelect() != 2 || packLine.getSubLineList() == null) continue;
            packLine.getSubLineList().removeIf(it -> it.getId() != null && !invoiceLines.contains(it));
            packLine.setTotalPack(packLine.getSubLineList().stream().map(it -> it.getExTaxTotal()).reduce(BigDecimal.ZERO, BigDecimal::add));
            subLines.addAll(packLine.getSubLineList());
        }
        Iterator<InvoiceLine> lines = invoiceLines.iterator();
        while (lines.hasNext()) {
            InvoiceLine subLine = lines.next();
            if (subLine.getId() == null || subLine.getParentLine() == null || subLines.contains((Object)subLine)) continue;
            lines.remove();
        }
        return invoiceLines;
    }
}

