/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.invoice;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.invoice.SubscriptionInvoiceService;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public class SubscriptionInvoiceServiceImpl
implements SubscriptionInvoiceService {
    @Inject
    private AppBaseService appBaseService;
    @Inject
    private SaleOrderRepository saleOrderRepo;
    @Inject
    private SaleOrderInvoiceService saleOrderInvoiceService;

    @Override
    public List<Invoice> generateSubscriptionInvoices() throws AxelorException {
        ArrayList<Invoice> invoices = new ArrayList<Invoice>();
        for (SaleOrder saleOrder : this.getSubscriptionOrders(null)) {
            Invoice invoice = this.generateSubscriptionInvoice(saleOrder);
            invoices.add(invoice);
        }
        return invoices;
    }

    @Override
    public List<SaleOrder> getSubscriptionOrders(Integer limit) {
        Query query = this.saleOrderRepo.all().filter("self.saleOrderTypeSelect = :saleOrderType AND self.statusSelect = :saleOrderStatus AND :subScriptionDate >= self.nextInvoicingDate AND (self.contractEndDate IS NULL OR self.contractEndDate >= :subScriptionDate)").bind("saleOrderType", (Object)2).bind("saleOrderStatus", (Object)3).bind("subScriptionDate", (Object)this.appBaseService.getTodayDate());
        if (limit != null) {
            return query.fetch(limit.intValue());
        }
        return query.fetch();
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice generateSubscriptionInvoice(SaleOrder saleOrder) throws AxelorException {
        ChronoUnit temporalUnit = ChronoUnit.MONTHS;
        Invoice invoice = this.saleOrderInvoiceService.generateInvoice((SaleOrder)((Object)this.saleOrderRepo.find(saleOrder.getId())));
        if (invoice != null) {
            LocalDate nextInvoicingDate;
            invoice = this.saleOrderInvoiceService.generateInvoice(saleOrder);
            if (saleOrder.getPeriodicityTypeSelect() == 1) {
                temporalUnit = ChronoUnit.DAYS;
            }
            invoice.setInvoiceDate(this.appBaseService.getTodayDate());
            invoice.setOperationSubTypeSelect(6);
            LocalDate invoicingPeriodStartDate = saleOrder.getNextInvoicingStartPeriodDate();
            invoice.setSubscriptionFromDate(invoicingPeriodStartDate);
            invoice.setSubscriptionToDate(saleOrder.getNextInvoicingEndPeriodDate());
            if (invoicingPeriodStartDate != null) {
                LocalDate nextInvoicingStartPeriodDate = invoicingPeriodStartDate.plus(saleOrder.getNumberOfPeriods().intValue(), temporalUnit);
                saleOrder.setNextInvoicingStartPeriodDate(nextInvoicingStartPeriodDate);
                LocalDate nextInvoicingEndPeriodDate = nextInvoicingStartPeriodDate.plus(saleOrder.getNumberOfPeriods().intValue(), temporalUnit).minusDays(1L);
                saleOrder.setNextInvoicingEndPeriodDate(nextInvoicingEndPeriodDate);
            }
            if ((nextInvoicingDate = saleOrder.getNextInvoicingDate()) != null) {
                nextInvoicingDate = nextInvoicingDate.plus(saleOrder.getNumberOfPeriods().intValue(), temporalUnit);
            }
            saleOrder.setNextInvoicingDate(nextInvoicingDate);
        }
        return invoice;
    }
}

