/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.invoice.generator;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.account.db.FixedAssetCategory;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.db.repo.AnalyticMoveLineRepository;
import com.axelor.apps.account.service.invoice.InvoiceLineService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.generator.InvoiceLineGenerator;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.List;

public abstract class InvoiceLineGeneratorSupplyChain
extends InvoiceLineGenerator {
    protected SaleOrderLine saleOrderLine;
    protected PurchaseOrderLine purchaseOrderLine;
    protected StockMoveLine stockMoveLine;
    protected AppBaseService appBaseService;
    protected UnitConversionService unitConversionService;

    @Inject
    public InvoiceLineGeneratorSupplyChain(Invoice invoice, Product product, String productName, BigDecimal price, BigDecimal inTaxPrice, BigDecimal priceDiscounted, String description, BigDecimal qty, Unit unit, TaxLine taxLine, int sequence, BigDecimal discountAmount, int discountTypeSelect, BigDecimal exTaxTotal, BigDecimal inTaxTotal, boolean isTaxInvoice, SaleOrderLine saleOrderLine, PurchaseOrderLine purchaseOrderLine, StockMoveLine stockMoveLine, boolean isSubLine, Integer packPriceSelect) {
        super(invoice, product, productName, price, inTaxPrice, priceDiscounted, description, qty, unit, taxLine, sequence, discountAmount, discountTypeSelect, exTaxTotal, inTaxTotal, isTaxInvoice, isSubLine, packPriceSelect);
        this.saleOrderLine = saleOrderLine;
        this.purchaseOrderLine = purchaseOrderLine;
        this.stockMoveLine = stockMoveLine;
        this.appBaseService = (AppBaseService)Beans.get(AppBaseService.class);
        this.unitConversionService = (UnitConversionService)Beans.get(UnitConversionService.class);
    }

    protected InvoiceLineGeneratorSupplyChain(Invoice invoice, Product product, String productName, String description, BigDecimal qty, Unit unit, int sequence, boolean isTaxInvoice, SaleOrderLine saleOrderLine, PurchaseOrderLine purchaseOrderLine, StockMoveLine stockMoveLine, boolean isSubLine, Integer packPriceSelect) throws AxelorException {
        super(invoice, product, productName, description, qty, unit, sequence, isTaxInvoice, isSubLine, packPriceSelect);
        this.saleOrderLine = saleOrderLine;
        this.purchaseOrderLine = purchaseOrderLine;
        this.stockMoveLine = stockMoveLine;
        this.appBaseService = (AppBaseService)Beans.get(AppBaseService.class);
        this.unitConversionService = (UnitConversionService)Beans.get(UnitConversionService.class);
        if (saleOrderLine != null) {
            this.discountAmount = saleOrderLine.getDiscountAmount();
            this.price = saleOrderLine.getPrice();
            this.inTaxPrice = saleOrderLine.getInTaxPrice();
            if (this.unit != null && !this.unit.equals((Object)saleOrderLine.getUnit())) {
                this.qty = this.unitConversionService.convert(this.unit, saleOrderLine.getUnit(), qty, qty.scale(), product);
                this.unit = saleOrderLine.getUnit();
            }
            this.priceDiscounted = saleOrderLine.getPriceDiscounted();
            this.taxLine = saleOrderLine.getTaxLine();
            this.discountTypeSelect = saleOrderLine.getDiscountTypeSelect();
            this.typeSelect = saleOrderLine.getTypeSelect();
        } else if (purchaseOrderLine != null) {
            if (purchaseOrderLine.getIsTitleLine().booleanValue()) {
                this.typeSelect = 1;
            }
            this.discountAmount = purchaseOrderLine.getDiscountAmount();
            this.price = purchaseOrderLine.getPrice();
            this.inTaxPrice = purchaseOrderLine.getInTaxPrice();
            if (this.unit != null && !this.unit.equals((Object)purchaseOrderLine.getUnit())) {
                this.qty = this.unitConversionService.convert(this.unit, purchaseOrderLine.getUnit(), qty, qty.scale(), product);
                this.unit = purchaseOrderLine.getUnit();
            }
            this.priceDiscounted = purchaseOrderLine.getPriceDiscounted();
            this.taxLine = purchaseOrderLine.getTaxLine();
            this.discountTypeSelect = purchaseOrderLine.getDiscountTypeSelect();
        } else if (stockMoveLine != null) {
            this.priceDiscounted = stockMoveLine.getUnitPriceUntaxed();
            Unit saleOrPurchaseUnit = this.getSaleOrPurchaseUnit();
            if (saleOrPurchaseUnit != null && this.unit != null && !this.unit.equals((Object)saleOrPurchaseUnit)) {
                this.qty = this.unitConversionService.convert(this.unit, saleOrPurchaseUnit, qty, qty.scale(), stockMoveLine.getProduct());
                this.priceDiscounted = this.unitConversionService.convert(this.unit, saleOrPurchaseUnit, this.priceDiscounted, this.appBaseService.getNbDecimalDigitForUnitPrice(), product);
                this.unit = saleOrPurchaseUnit;
            }
        }
    }

    protected InvoiceLine createInvoiceLine() throws AxelorException {
        InvoiceLine invoiceLine = super.createInvoiceLine();
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return invoiceLine;
        }
        InvoiceLineService invoiceLineService = (InvoiceLineService)Beans.get(InvoiceLineService.class);
        this.assignOriginElements(invoiceLine);
        List analyticMoveLineList = null;
        if (this.saleOrderLine != null) {
            if (this.saleOrderLine.getAnalyticDistributionTemplate() != null) {
                invoiceLine.setAnalyticDistributionTemplate(this.saleOrderLine.getAnalyticDistributionTemplate());
                this.copyAnalyticMoveLines(this.saleOrderLine.getAnalyticMoveLineList(), invoiceLine);
                analyticMoveLineList = invoiceLineService.computeAnalyticDistribution(invoiceLine);
            } else {
                analyticMoveLineList = invoiceLineService.getAndComputeAnalyticDistribution(invoiceLine, this.invoice);
                analyticMoveLineList.stream().forEach(invoiceLine::addAnalyticMoveLineListItem);
            }
        } else if (this.purchaseOrderLine != null) {
            if (this.purchaseOrderLine.getAnalyticDistributionTemplate() != null) {
                invoiceLine.setAnalyticDistributionTemplate(this.purchaseOrderLine.getAnalyticDistributionTemplate());
                this.copyAnalyticMoveLines(this.purchaseOrderLine.getAnalyticMoveLineList(), invoiceLine);
                analyticMoveLineList = invoiceLineService.computeAnalyticDistribution(invoiceLine);
            } else {
                analyticMoveLineList = invoiceLineService.getAndComputeAnalyticDistribution(invoiceLine, this.invoice);
                analyticMoveLineList.stream().forEach(invoiceLine::addAnalyticMoveLineListItem);
            }
            this.copyBudgetDistributionList(this.purchaseOrderLine.getBudgetDistributionList(), invoiceLine);
            invoiceLine.setBudget(this.purchaseOrderLine.getBudget());
            invoiceLine.setBudgetDistributionSumAmount(this.purchaseOrderLine.getBudgetDistributionSumAmount());
            invoiceLine.setFixedAssets(this.purchaseOrderLine.getFixedAssets());
            if (this.product != null && this.isAccountRequired()) {
                invoiceLine.setProductCode(this.product.getCode());
                Account account = this.accountManagementService.getProductAccount(this.product, this.invoice.getCompany(), this.invoice.getPartner().getFiscalPosition(), InvoiceToolService.isPurchase((Invoice)this.invoice), invoiceLine.getFixedAssets().booleanValue());
                invoiceLine.setAccount(account);
            }
            if (this.product != null && this.purchaseOrderLine.getFixedAssets().booleanValue()) {
                FixedAssetCategory fixedAssetCategory = this.accountManagementService.getProductFixedAssetCategory(this.product, this.invoice.getCompany());
                invoiceLine.setFixedAssetCategory(fixedAssetCategory);
            }
        } else if (this.stockMoveLine != null) {
            this.price = this.stockMoveLine.getUnitPriceUntaxed();
            this.inTaxPrice = this.stockMoveLine.getUnitPriceTaxed();
            this.price = this.unitConversionService.convert(this.stockMoveLine.getUnit(), this.unit, this.price, this.appBaseService.getNbDecimalDigitForUnitPrice(), this.product);
            this.inTaxPrice = this.unitConversionService.convert(this.stockMoveLine.getUnit(), this.unit, this.inTaxPrice, this.appBaseService.getNbDecimalDigitForUnitPrice(), this.product);
            invoiceLine.setPrice(this.price);
            invoiceLine.setInTaxPrice(this.inTaxPrice);
            analyticMoveLineList = invoiceLineService.getAndComputeAnalyticDistribution(invoiceLine, this.invoice);
            analyticMoveLineList.stream().forEach(invoiceLine::addAnalyticMoveLineListItem);
        }
        return invoiceLine;
    }

    public void assignOriginElements(InvoiceLine invoiceLine) throws AxelorException {
        StockMove stockMove = null;
        if (this.stockMoveLine != null) {
            stockMove = this.stockMoveLine.getStockMove();
        }
        if (stockMove != null) {
            if (InvoiceToolService.isPurchase((Invoice)this.invoice)) {
                invoiceLine.setIncomingStockMove(stockMove);
            } else {
                invoiceLine.setOutgoingStockMove(stockMove);
            }
        }
        if (this.saleOrderLine != null) {
            invoiceLine.setSaleOrderLine(this.saleOrderLine);
        }
        if (this.purchaseOrderLine != null) {
            invoiceLine.setPurchaseOrderLine(this.purchaseOrderLine);
        }
    }

    public void copyAnalyticMoveLines(List<AnalyticMoveLine> originalAnalyticMoveLineList, InvoiceLine invoiceLine) {
        if (originalAnalyticMoveLineList == null) {
            return;
        }
        for (AnalyticMoveLine originalAnalyticMoveLine : originalAnalyticMoveLineList) {
            AnalyticMoveLine analyticMoveLine = (AnalyticMoveLine)((Object)((AnalyticMoveLineRepository)((Object)Beans.get(AnalyticMoveLineRepository.class))).copy((Model)((Object)originalAnalyticMoveLine), false));
            analyticMoveLine.setTypeSelect(2);
            invoiceLine.addAnalyticMoveLineListItem(analyticMoveLine);
        }
    }

    public void copyBudgetDistributionList(List<BudgetDistribution> originalBudgetDistributionList, InvoiceLine invoiceLine) {
        if (originalBudgetDistributionList == null) {
            return;
        }
        for (BudgetDistribution budgetDistributionIt : originalBudgetDistributionList) {
            BudgetDistribution budgetDistribution = new BudgetDistribution();
            budgetDistribution.setBudget(budgetDistributionIt.getBudget());
            budgetDistribution.setAmount(budgetDistributionIt.getAmount());
            budgetDistribution.setBudgetAmountAvailable(budgetDistributionIt.getBudgetAmountAvailable());
            invoiceLine.addBudgetDistributionListItem(budgetDistribution);
        }
    }

    public Unit getSaleOrPurchaseUnit() throws AxelorException {
        if (!InvoiceToolService.isPurchase((Invoice)this.invoice)) {
            return this.product.getSalesUnit();
        }
        return this.product.getPurchasesUnit();
    }

    public boolean isAccountRequired() {
        if (!((AppSupplychainService)Beans.get(AppSupplychainService.class)).isApp("supplychain")) {
            return super.isAccountRequired();
        }
        if (((AppSaleService)Beans.get(AppSaleService.class)).getAppSale().getProductPackMgt().booleanValue()) {
            if (this.isSubLine && this.packPriceSelect == 0) {
                return false;
            }
            if (this.typeSelect == 2 && this.packPriceSelect == 1) {
                return false;
            }
        }
        return true;
    }
}

