/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.service.workflow;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.workflow.cancel.WorkflowCancelServiceImpl;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowCancelServiceSupplychainImpl
extends WorkflowCancelServiceImpl {
    private int oldInvoiceStatusSelect;
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SaleOrderInvoiceService saleOrderInvoiceService;
    private PurchaseOrderInvoiceService purchaseOrderInvoiceService;
    private SaleOrderRepository saleOrderRepository;
    private PurchaseOrderRepository purchaseOrderRepository;

    @Inject
    public WorkflowCancelServiceSupplychainImpl(SaleOrderInvoiceService saleOrderInvoiceService, PurchaseOrderInvoiceService purchaseOrderInvoiceService, SaleOrderRepository saleOrderRepository, PurchaseOrderRepository purchaseOrderRepository) {
        this.saleOrderInvoiceService = saleOrderInvoiceService;
        this.purchaseOrderInvoiceService = purchaseOrderInvoiceService;
        this.saleOrderRepository = saleOrderRepository;
        this.purchaseOrderRepository = purchaseOrderRepository;
    }

    public void beforeCancel(Invoice invoice) {
        this.oldInvoiceStatusSelect = invoice.getStatusSelect();
    }

    public void afterCancel(Invoice invoice) throws AxelorException {
        if (this.oldInvoiceStatusSelect == 3) {
            if (InvoiceToolService.isPurchase((Invoice)invoice)) {
                this.purchaseOrderProcess(invoice);
            } else {
                this.saleOrderProcess(invoice);
            }
        }
    }

    public void saleOrderProcess(Invoice invoice) throws AxelorException {
        SaleOrder invoiceSaleOrder = invoice.getSaleOrder();
        if (invoiceSaleOrder != null) {
            this.log.debug("Update the invoiced amount of the sale order : {}", (Object)invoiceSaleOrder.getSaleOrderSeq());
            invoiceSaleOrder.setAmountInvoiced(this.saleOrderInvoiceService.getInvoicedAmount(invoiceSaleOrder, invoice.getId(), true));
        } else {
            ArrayList saleOrderList = Lists.newArrayList();
            for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
                SaleOrder saleOrder = this.saleOrderLineProcess(invoice, invoiceLine);
                if (saleOrder == null || saleOrderList.contains((Object)saleOrder)) continue;
                saleOrderList.add(saleOrder);
            }
            for (SaleOrder saleOrder : saleOrderList) {
                this.log.debug("Update the invoiced amount of the sale order : {}", (Object)saleOrder.getSaleOrderSeq());
                saleOrder.setAmountInvoiced(this.saleOrderInvoiceService.getInvoicedAmount(saleOrder, invoice.getId(), true));
                this.saleOrderRepository.save((Model)((Object)saleOrder));
            }
        }
    }

    public SaleOrder saleOrderLineProcess(Invoice invoice, InvoiceLine invoiceLine) throws AxelorException {
        SaleOrderLine saleOrderLine = invoiceLine.getSaleOrderLine();
        if (saleOrderLine == null) {
            return null;
        }
        SaleOrder saleOrder = saleOrderLine.getSaleOrder();
        BigDecimal invoicedAmountToAdd = invoiceLine.getExTaxTotal();
        if (InvoiceToolService.isRefund((Invoice)invoiceLine.getInvoice())) {
            invoicedAmountToAdd = invoicedAmountToAdd.negate();
        }
        if (!invoice.getCurrency().equals((Object)saleOrder.getCurrency()) && saleOrderLine.getCompanyExTaxTotal().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal currentCompanyInvoicedAmount = invoiceLine.getCompanyExTaxTotal();
            BigDecimal rate = currentCompanyInvoicedAmount.divide(saleOrderLine.getCompanyExTaxTotal(), 4, RoundingMode.HALF_UP);
            invoicedAmountToAdd = rate.multiply(saleOrderLine.getExTaxTotal());
        }
        saleOrderLine.setAmountInvoiced(saleOrderLine.getAmountInvoiced().subtract(invoicedAmountToAdd));
        return saleOrder;
    }

    public void purchaseOrderProcess(Invoice invoice) throws AxelorException {
        PurchaseOrder invoicePurchaseOrder = invoice.getPurchaseOrder();
        if (invoicePurchaseOrder != null) {
            this.log.debug("Update the invoiced amount of the purchase order : {}", (Object)invoicePurchaseOrder.getPurchaseOrderSeq());
            invoicePurchaseOrder.setAmountInvoiced(this.purchaseOrderInvoiceService.getInvoicedAmount(invoicePurchaseOrder, invoice.getId(), true));
        } else {
            ArrayList purchaseOrderList = Lists.newArrayList();
            for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
                PurchaseOrder purchaseOrder = this.purchaseOrderLineProcess(invoice, invoiceLine);
                if (purchaseOrder == null || purchaseOrderList.contains((Object)purchaseOrder)) continue;
                purchaseOrderList.add(purchaseOrder);
            }
            for (PurchaseOrder purchaseOrder : purchaseOrderList) {
                this.log.debug("Update the invoiced amount of the purchase order : {}", (Object)purchaseOrder.getPurchaseOrderSeq());
                purchaseOrder.setAmountInvoiced(this.purchaseOrderInvoiceService.getInvoicedAmount(purchaseOrder, invoice.getId(), true));
                this.purchaseOrderRepository.save((Model)((Object)purchaseOrder));
            }
        }
    }

    public PurchaseOrder purchaseOrderLineProcess(Invoice invoice, InvoiceLine invoiceLine) throws AxelorException {
        PurchaseOrderLine purchaseOrderLine = invoiceLine.getPurchaseOrderLine();
        if (purchaseOrderLine == null) {
            return null;
        }
        PurchaseOrder purchaseOrder = purchaseOrderLine.getPurchaseOrder();
        BigDecimal invoicedAmountToAdd = invoiceLine.getExTaxTotal();
        if (InvoiceToolService.isRefund((Invoice)invoiceLine.getInvoice())) {
            invoicedAmountToAdd = invoicedAmountToAdd.negate();
        }
        if (!invoice.getCurrency().equals((Object)purchaseOrder.getCurrency()) && purchaseOrderLine.getCompanyExTaxTotal().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal currentCompanyInvoicedAmount = invoiceLine.getCompanyExTaxTotal();
            BigDecimal rate = currentCompanyInvoicedAmount.divide(purchaseOrderLine.getCompanyExTaxTotal(), 4, RoundingMode.HALF_UP);
            invoicedAmountToAdd = rate.multiply(purchaseOrderLine.getExTaxTotal());
        }
        purchaseOrderLine.setAmountInvoiced(purchaseOrderLine.getAmountInvoiced().subtract(invoicedAmountToAdd));
        return purchaseOrder;
    }
}

