/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.InvoiceLineRepository;
import com.axelor.apps.account.service.invoice.InvoiceLineService;
import com.axelor.apps.account.service.invoice.generator.line.InvoiceLineManagement;
import com.axelor.apps.supplychain.service.InvoiceLineSupplychainService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class InvoiceLineController {
    public void getProductPrice(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        InvoiceLine invoiceLine = (InvoiceLine)((Object)context.asType(InvoiceLine.class));
        Integer parentPackPriceSelect = (Integer)context.getParent().get((Object)"packPriceSelect");
        if (invoiceLine.getPackPriceSelect() == 1 && invoiceLine.getTypeSelect() == 2) {
            response.setValue("price", (Object)0.0);
            response.setValue("inTaxPrice", (Object)0.0);
        } else if (parentPackPriceSelect != null && invoiceLine.getIsSubLine() != null && parentPackPriceSelect == 0 && invoiceLine.getIsSubLine().booleanValue()) {
            response.setValue("price", (Object)0.0);
            response.setValue("inTaxPrice", (Object)0.0);
        }
    }

    public List<InvoiceLine> updateQty(List<InvoiceLine> invoiceLines, BigDecimal oldKitQty, BigDecimal newKitQty, Invoice invoice) throws AxelorException {
        block7: {
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal exTaxTotal = BigDecimal.ZERO;
            BigDecimal companyExTaxTotal = BigDecimal.ZERO;
            BigDecimal inTaxTotal = BigDecimal.ZERO;
            BigDecimal companyInTaxTotal = BigDecimal.ZERO;
            BigDecimal priceDiscounted = BigDecimal.ZERO;
            BigDecimal taxRate = BigDecimal.ZERO;
            InvoiceLineService invoiceLineService = (InvoiceLineService)Beans.get(InvoiceLineService.class);
            if (invoiceLines == null) break block7;
            if (newKitQty.compareTo(BigDecimal.ZERO) != 0) {
                for (InvoiceLine line : invoiceLines) {
                    qty = line.getQty().divide(oldKitQty, 2, RoundingMode.HALF_EVEN).multiply(newKitQty);
                    priceDiscounted = invoiceLineService.computeDiscount(line, invoice.getInAti());
                    if (line.getTaxLine() != null) {
                        taxRate = line.getTaxLine().getValue();
                    }
                    if (!invoice.getInAti().booleanValue()) {
                        exTaxTotal = InvoiceLineManagement.computeAmount((BigDecimal)qty, (BigDecimal)priceDiscounted);
                        inTaxTotal = exTaxTotal.add(exTaxTotal.multiply(taxRate));
                    } else {
                        inTaxTotal = InvoiceLineManagement.computeAmount((BigDecimal)qty, (BigDecimal)priceDiscounted);
                        exTaxTotal = inTaxTotal.divide(taxRate.add(BigDecimal.ONE), 2, 4);
                    }
                    companyExTaxTotal = invoiceLineService.getCompanyExTaxTotal(exTaxTotal, invoice);
                    companyInTaxTotal = invoiceLineService.getCompanyExTaxTotal(inTaxTotal, invoice);
                    line.setQty(qty.setScale(2, RoundingMode.HALF_EVEN));
                    line.setExTaxTotal(exTaxTotal);
                    line.setCompanyExTaxTotal(companyExTaxTotal);
                    line.setInTaxTotal(inTaxTotal);
                    line.setCompanyInTaxTotal(companyInTaxTotal);
                    line.setPriceDiscounted(priceDiscounted);
                    line.setTaxRate(taxRate);
                }
            } else {
                for (InvoiceLine line : invoiceLines) {
                    line.setQty(qty.setScale(2, RoundingMode.HALF_EVEN));
                }
            }
        }
        return invoiceLines;
    }

    public void updateSubLineQty(ActionRequest request, ActionResponse response) throws AxelorException {
        InvoiceLine packLine = (InvoiceLine)((Object)request.getContext().asType(InvoiceLine.class));
        BigDecimal oldKitQty = BigDecimal.ONE;
        BigDecimal newKitQty = BigDecimal.ZERO;
        List<InvoiceLine> subLines = null;
        Context context = request.getContext();
        if (context.getParent().getContextClass() == InvoiceLine.class) {
            context = request.getContext().getParent();
        }
        Invoice invoice = this.getInvoice(context);
        if (packLine.getOldQty() == null || packLine.getOldQty().compareTo(BigDecimal.ZERO) == 0) {
            InvoiceLine line;
            if (packLine.getId() != null && (line = (InvoiceLine)((Object)((InvoiceLineRepository)((Object)Beans.get(InvoiceLineRepository.class))).find(packLine.getId()))).getQty().compareTo(BigDecimal.ZERO) != 0) {
                oldKitQty = line.getQty();
            }
        } else {
            oldKitQty = packLine.getOldQty();
        }
        if (packLine.getQty().compareTo(BigDecimal.ZERO) != 0) {
            newKitQty = packLine.getQty();
        }
        if (packLine.getTypeSelect() == 2) {
            subLines = this.updateQty(packLine.getSubLineList(), oldKitQty, newKitQty, invoice);
        }
        response.setValue("oldQty", (Object)newKitQty);
        response.setValue("subLineList", subLines);
    }

    public void resetPackData(ActionRequest request, ActionResponse response) throws AxelorException {
        InvoiceLine packLine = (InvoiceLine)((Object)request.getContext().asType(InvoiceLine.class));
        if (packLine.getPackPriceSelect() == 0) {
            List<InvoiceLine> subLines = packLine.getSubLineList();
            if (subLines != null) {
                for (InvoiceLine line : subLines) {
                    line.setPrice(BigDecimal.ZERO);
                    line.setInTaxPrice(BigDecimal.ZERO);
                    line.setPriceDiscounted(BigDecimal.ZERO);
                    line.setExTaxTotal(BigDecimal.ZERO);
                    line.setInTaxTotal(BigDecimal.ZERO);
                    line.setCompanyInTaxTotal(BigDecimal.ZERO);
                    line.setCompanyExTaxTotal(BigDecimal.ZERO);
                }
            }
            response.setValue("subLineList", subLines);
        } else {
            response.setValue("price", (Object)BigDecimal.ZERO);
            response.setValue("inTaxPrice", (Object)BigDecimal.ZERO);
            response.setValue("priceDiscounted", (Object)BigDecimal.ZERO);
            response.setValue("exTaxTotal", (Object)BigDecimal.ZERO);
            response.setValue("inTaxTotal", (Object)BigDecimal.ZERO);
            response.setValue("companyExTaxTotal", (Object)BigDecimal.ZERO);
            response.setValue("companyInTaxTotal", (Object)BigDecimal.ZERO);
        }
    }

    public Invoice getInvoice(Context context) {
        Context parentContext = context.getParent();
        Invoice invoice = (Invoice)((Object)parentContext.asType(Invoice.class));
        if (!parentContext.getContextClass().toString().equals(Invoice.class.toString())) {
            InvoiceLine invoiceLine = (InvoiceLine)((Object)context.asType(InvoiceLine.class));
            invoice = invoiceLine.getInvoice();
        }
        return invoice;
    }

    public void computeBudgetDistributionSumAmount(ActionRequest request, ActionResponse response) {
        InvoiceLine invoiceLine = (InvoiceLine)((Object)request.getContext().asType(InvoiceLine.class));
        Invoice invoice = (Invoice)((Object)request.getContext().getParent().asType(Invoice.class));
        ((InvoiceLineSupplychainService)((Object)Beans.get(InvoiceLineSupplychainService.class))).computeBudgetDistributionSumAmount(invoiceLine, invoice);
        response.setValue("budgetDistributionSumAmount", (Object)invoiceLine.getBudgetDistributionSumAmount());
        response.setValue("budgetDistributionList", invoiceLine.getBudgetDistributionList());
    }
}

