/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.stock.db.LogisticalForm;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class LogisticalFormController {
    public void print(ActionRequest request, ActionResponse response) {
        try {
            LogisticalForm logisticalForm = (LogisticalForm)request.getContext().asType(LogisticalForm.class);
            String name = String.format("%s %s", I18n.get((String)"Packing list"), logisticalForm.getDeliveryNumberSeq());
            String fileLink = ReportFactory.createReport((String)"PackingList.rptdesign", (String)(name + " - ${date}")).addParam("LogisticalFormId", (Object)logisticalForm.getId()).addParam("Locale", (Object)ReportSettings.getPrintingLocale((Partner)logisticalForm.getDeliverToCustomerPartner())).generate().getFileLink();
            response.setView(ActionView.define((String)name).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

