/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.supplychain.db.Mrp;
import com.axelor.apps.supplychain.db.repo.MrpRepository;
import com.axelor.apps.supplychain.service.MrpService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class MrpController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCalculation(ActionRequest request, ActionResponse response) {
        Mrp mrp = (Mrp)((Object)request.getContext().asType(Mrp.class));
        try {
            ((MrpService)Beans.get(MrpService.class)).runCalculation((Mrp)((Object)((MrpRepository)((Object)Beans.get(MrpRepository.class))).find(mrp.getId())));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            ((MrpService)Beans.get(MrpService.class)).reset((Mrp)((Object)((MrpRepository)((Object)Beans.get(MrpRepository.class))).find(mrp.getId())));
        }
        finally {
            response.setReload(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateAllProposals(ActionRequest request, ActionResponse response) {
        try {
            int id = (Integer)request.getContext().get((Object)"_id");
            Boolean isProposalsPerSupplier = (Boolean)request.getContext().get((Object)"consolidateProposalsPerSupplier");
            ((MrpService)Beans.get(MrpService.class)).generateProposals((Mrp)((Object)((MrpRepository)((Object)Beans.get(MrpRepository.class))).find(Long.valueOf(id))), isProposalsPerSupplier == null ? false : isProposalsPerSupplier);
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    public void printWeeks(ActionRequest request, ActionResponse response) {
        Mrp mrp = (Mrp)((Object)request.getContext().asType(Mrp.class));
        mrp = (Mrp)((Object)((MrpRepository)((Object)Beans.get(MrpRepository.class))).find(mrp.getId()));
        String name = I18n.get((String)"MRP") + "-" + mrp.getId();
        try {
            String fileLink = ReportFactory.createReport((String)"MrpWeeks.rptdesign", (String)name).addParam("mrpId", (Object)mrp.getId()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("endDate", (Object)((MrpService)Beans.get(MrpService.class)).findMrpEndDate(mrp).atStartOfDay().toString()).addFormat("pdf").generate().getFileLink();
            response.setView(ActionView.define((String)name).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void printList(ActionRequest request, ActionResponse response) {
        Mrp mrp = (Mrp)((Object)request.getContext().asType(Mrp.class));
        String name = I18n.get((String)"MRP") + "-" + mrp.getId();
        try {
            String fileLink = ReportFactory.createReport((String)"MrpList.rptdesign", (String)name).addParam("mrpId", (Object)mrp.getId()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addFormat("pdf").generate().getFileLink();
            response.setView(ActionView.define((String)name).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

