/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.supplychain.service.ProductStockLocationService;
import com.axelor.apps.supplychain.service.ProjectedStockService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProductController {
    public void setIndicatorsOfProduct(ActionRequest request, ActionResponse response) {
        try {
            StockLocation sl;
            Map<String, Long> mapId = ((ProjectedStockService)Beans.get(ProjectedStockService.class)).getProductIdCompanyIdStockLocationIdFromContext(request.getContext());
            if (mapId == null) {
                return;
            }
            Context context = request.getContext();
            Long productId = mapId.get("productId");
            Long companyId = mapId.get("companyId");
            Long stockLocationId = mapId.get("stockLocationId");
            if (companyId == 0L && stockLocationId != 0L) {
                stockLocationId = 0L;
            } else if (companyId != 0L && stockLocationId != 0L && (sl = (StockLocation)((Object)((StockLocationRepository)((Object)Beans.get(StockLocationRepository.class))).find(stockLocationId))) != null && sl.getCompany() != null && sl.getCompany().getId() != companyId) {
                stockLocationId = 0L;
                response.setValue("stockLocation", null);
                context.put("$stockLocation", null);
            }
            Map<String, Object> map = ((ProductStockLocationService)Beans.get(ProductStockLocationService.class)).computeIndicators(productId, companyId, stockLocationId);
            response.setValues(map);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void findAllSubLocation(ActionRequest request, ActionResponse response) {
        StockLocation stockLocation;
        LinkedHashMap stockLocationHashMap;
        Context context = request.getContext();
        Long stockLocationId = 0L;
        Long companyId = 0L;
        LinkedHashMap companyHashMap = (LinkedHashMap)context.get((Object)"company");
        if (companyHashMap != null) {
            companyId = Long.valueOf(companyHashMap.get("id").toString());
        }
        if ((stockLocationHashMap = (LinkedHashMap)context.get((Object)"stockLocation")) != null) {
            stockLocationId = Long.valueOf(stockLocationHashMap.get("id").toString());
        }
        if (companyId != 0L && stockLocationId != 0L && (stockLocation = (StockLocation)((Object)((StockLocationRepository)((Object)Beans.get(StockLocationRepository.class))).find(stockLocationId))) != null && stockLocation.getCompany().getId() == companyId) {
            List stockLocationIdList = ((StockLocationService)Beans.get(StockLocationService.class)).getAllLocationAndSubLocationId(stockLocation, false);
            response.setValue("__stockLocationIdList", (Object)stockLocationIdList);
            return;
        }
        response.setValue("__stockLocationIdList", Arrays.asList(0L));
    }
}

