/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.AppBudget;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.db.repo.AppBudgetRepository;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.PurchaseOrderStockServiceImpl;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Singleton
public class PurchaseOrderController {
    public void createStockMove(ActionRequest request, ActionResponse response) throws AxelorException {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        try {
            if (purchaseOrder.getId() != null) {
                List<Long> stockMoveList = ((PurchaseOrderStockServiceImpl)Beans.get(PurchaseOrderStockServiceImpl.class)).createStockMoveFromPurchaseOrder((PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId())));
                if (stockMoveList != null && stockMoveList.size() == 1) {
                    response.setView(ActionView.define((String)I18n.get((String)"Stock move")).model(StockMove.class.getName()).add("grid", "stock-move-grid").add("form", "stock-move-form").param("forceEdit", "true").domain("self.id = " + stockMoveList.get(0)).context("_showRecord", (Object)String.valueOf(stockMoveList.get(0))).map());
                } else if (stockMoveList != null && stockMoveList.size() > 1) {
                    response.setView(ActionView.define((String)I18n.get((String)"Stock move")).model(StockMove.class.getName()).add("grid", "stock-move-grid").add("form", "stock-move-form").domain("self.id in (" + Joiner.on((String)",").join(stockMoveList) + ")").map());
                } else {
                    response.setFlash(I18n.get((String)"No delivery stock move to generate for this purchase order"));
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getStockLocation(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        if (purchaseOrder.getCompany() != null) {
            response.setValue("stockLocation", (Object)((StockLocationService)Beans.get(StockLocationService.class)).getDefaultReceiptStockLocation(purchaseOrder.getCompany()));
        }
    }

    public void cancelReceipt(ActionRequest request, ActionResponse response) throws AxelorException {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        purchaseOrder = (PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId()));
        ((PurchaseOrderStockServiceImpl)Beans.get(PurchaseOrderStockServiceImpl.class)).cancelReceipt(purchaseOrder);
    }

    public void generateBudgetDistribution(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        AppAccountService appAccountService = (AppAccountService)Beans.get(AppAccountService.class);
        if (appAccountService.isApp("budget") && !appAccountService.getAppBudget().getManageMultiBudget().booleanValue()) {
            purchaseOrder = (PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId()));
            ((PurchaseOrderServiceSupplychainImpl)((Object)Beans.get(PurchaseOrderServiceSupplychainImpl.class))).generateBudgetDistribution(purchaseOrder);
            response.setValues((Object)purchaseOrder);
        }
    }

    public void mergePurchaseOrder(ActionRequest request, ActionResponse response) {
        ArrayList<PurchaseOrder> purchaseOrderList = new ArrayList<PurchaseOrder>();
        ArrayList<Long> purchaseOrderIdList = new ArrayList<Long>();
        boolean fromPopup = false;
        if (request.getContext().get((Object)"purchaseOrderToMerge") != null) {
            if (request.getContext().get((Object)"purchaseOrderToMerge") instanceof List) {
                List purchaseOrderMap = (List)request.getContext().get((Object)"purchaseOrderToMerge");
                for (Map map : purchaseOrderMap) {
                    purchaseOrderIdList.add(new Long(((Integer)map.get("id")).intValue()));
                }
            } else {
                String purchaseOrderIdListStr = (String)request.getContext().get((Object)"purchaseOrderToMerge");
                for (String purchaseOrderId : purchaseOrderIdListStr.split(",")) {
                    purchaseOrderIdList.add(new Long(purchaseOrderId));
                }
                fromPopup = true;
            }
        }
        Currency commonCurrency = null;
        Partner commonSupplierPartner = null;
        Company commonCompany = null;
        Partner commonContactPartner = null;
        TradingName commonTradingName = null;
        boolean existContactPartnerDiff = false;
        PriceList commonPriceList = null;
        boolean existPriceListDiff = false;
        StockLocation commonLocation = null;
        boolean existLocationDiff = false;
        boolean allTradingNamesAreNull = true;
        int count = 1;
        for (Long purchaseOrderId : purchaseOrderIdList) {
            PurchaseOrder purchaseOrderTemp = (PurchaseOrder)((Object)JPA.em().find(PurchaseOrder.class, (Object)purchaseOrderId));
            purchaseOrderList.add(purchaseOrderTemp);
            if (count == 1) {
                commonCurrency = purchaseOrderTemp.getCurrency();
                commonSupplierPartner = purchaseOrderTemp.getSupplierPartner();
                commonCompany = purchaseOrderTemp.getCompany();
                commonContactPartner = purchaseOrderTemp.getContactPartner();
                commonPriceList = purchaseOrderTemp.getPriceList();
                commonLocation = purchaseOrderTemp.getStockLocation();
                commonTradingName = purchaseOrderTemp.getTradingName();
                allTradingNamesAreNull = commonTradingName == null;
            } else {
                if (commonCurrency != null && !commonCurrency.equals((Object)purchaseOrderTemp.getCurrency())) {
                    commonCurrency = null;
                }
                if (commonSupplierPartner != null && !commonSupplierPartner.equals((Object)purchaseOrderTemp.getSupplierPartner())) {
                    commonSupplierPartner = null;
                }
                if (commonCompany != null && !commonCompany.equals((Object)purchaseOrderTemp.getCompany())) {
                    commonCompany = null;
                }
                if (!Objects.equals(commonTradingName, purchaseOrderTemp.getTradingName())) {
                    commonTradingName = null;
                    allTradingNamesAreNull = false;
                }
                if (commonContactPartner != null && !commonContactPartner.equals((Object)purchaseOrderTemp.getContactPartner())) {
                    commonContactPartner = null;
                    existContactPartnerDiff = true;
                }
                if (commonPriceList != null && !commonPriceList.equals((Object)purchaseOrderTemp.getPriceList())) {
                    commonPriceList = null;
                    existPriceListDiff = true;
                }
                if (commonLocation != null && !commonLocation.equals((Object)purchaseOrderTemp.getStockLocation())) {
                    commonLocation = null;
                    existLocationDiff = true;
                }
            }
            ++count;
        }
        StringBuilder fieldErrors = new StringBuilder();
        if (commonCurrency == null) {
            fieldErrors.append(I18n.get((String)"The currency is required and must be the same for all purchase orders"));
        }
        if (commonSupplierPartner == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The supplier Partner is required and must be the same for all purchase orders"));
        }
        if (commonCompany == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The company is required and must be the same for all purchase orders"));
        }
        if (commonTradingName == null && !allTradingNamesAreNull) {
            fieldErrors.append(I18n.get((String)"The trading name must be the same for all purchase orders"));
        }
        if (fieldErrors.length() > 0) {
            response.setFlash(fieldErrors.toString());
            return;
        }
        if (request.getContext().get((Object)"priceList") != null) {
            commonPriceList = (PriceList)JPA.em().find(PriceList.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"priceList")).get("id")).intValue()));
        }
        if (request.getContext().get((Object)"contactPartner") != null) {
            commonContactPartner = (Partner)((Object)JPA.em().find(Partner.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"contactPartner")).get("id")).intValue())));
        }
        if (request.getContext().get((Object)"stockLocation") != null) {
            commonLocation = (StockLocation)((Object)JPA.em().find(StockLocation.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"stockLocation")).get("id")).intValue())));
        }
        if (!fromPopup && (existContactPartnerDiff || existPriceListDiff || existLocationDiff)) {
            ActionView.ActionViewBuilder confirmView = ActionView.define((String)"Confirm merge purchase order").model(Wizard.class.getName()).add("form", "purchase-order-merge-confirm-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true");
            if (existPriceListDiff) {
                confirmView.context("contextPriceListToCheck", (Object)"true");
            }
            if (existContactPartnerDiff) {
                confirmView.context("contextContactPartnerToCheck", (Object)"true");
                confirmView.context("contextPartnerId", (Object)commonSupplierPartner.getId().toString());
            }
            if (existLocationDiff) {
                confirmView.context("contextLocationToCheck", (Object)"true");
            }
            confirmView.context("purchaseOrderToMerge", (Object)Joiner.on((String)",").join(purchaseOrderIdList));
            response.setView(confirmView.map());
            return;
        }
        try {
            PurchaseOrder purchaseOrder = ((PurchaseOrderServiceSupplychainImpl)((Object)Beans.get(PurchaseOrderServiceSupplychainImpl.class))).mergePurchaseOrders(purchaseOrderList, commonCurrency, commonSupplierPartner, commonCompany, commonLocation, commonContactPartner, commonPriceList, commonTradingName);
            if (purchaseOrder != null) {
                response.setView(ActionView.define((String)"Purchase order").model(PurchaseOrder.class.getName()).add("grid", "purchase-order-grid").add("form", "purchase-order-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(purchaseOrder.getId())).map());
                response.setCanClose(true);
            }
        }
        catch (Exception e) {
            response.setFlash(e.getLocalizedMessage());
        }
    }

    public void updateAmountToBeSpreadOverTheTimetable(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        ((PurchaseOrderServiceSupplychainImpl)((Object)Beans.get(PurchaseOrderServiceSupplychainImpl.class))).updateAmountToBeSpreadOverTheTimetable(purchaseOrder);
        response.setValue("amountToBeSpreadOverTheTimetable", (Object)purchaseOrder.getAmountToBeSpreadOverTheTimetable());
    }

    public void applyToAllBudgetDistribution(ActionRequest request, ActionResponse response) {
        PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl = (PurchaseOrderServiceSupplychainImpl)((Object)Beans.get(PurchaseOrderServiceSupplychainImpl.class));
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        purchaseOrder = (PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId()));
        AppBudget AppBudget2 = (AppBudget)((AppBudgetRepository)Beans.get(AppBudgetRepository.class)).all().fetchOne();
        if (AppBudget2.getManageMultiBudget().booleanValue()) {
            purchaseOrderServiceSupplychainImpl.applyToallBudgetDistribution(purchaseOrder);
        } else {
            purchaseOrderServiceSupplychainImpl.setPurchaseOrderLineBudget(purchaseOrder);
            response.setValue("purchaseOrderLineList", purchaseOrder.getPurchaseOrderLineList());
        }
    }

    public void updateEstimatedDelivDate(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        List<PurchaseOrderLine> purchaseOrderLineList = purchaseOrder.getPurchaseOrderLineList();
        if (purchaseOrderLineList != null) {
            for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
                Integer receiptState = purchaseOrderLine.getReceiptState();
                if (receiptState == null || receiptState.equals(3) || receiptState.equals(2)) continue;
                purchaseOrderLine.setEstimatedDelivDate(purchaseOrder.getDeliveryDate());
            }
        }
        response.setValue("purchaseOrderLineList", purchaseOrderLineList);
    }

    public void checkPurchaseOrderAnalyticDistributionTemplate(ActionRequest request, ActionResponse response) {
        try {
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
            ArrayList<String> productList = new ArrayList<String>();
            for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
                if (purchaseOrderLine.getAnalyticDistributionTemplate() != null) continue;
                productList.add(purchaseOrderLine.getProduct().getFullName());
            }
            if (productList != null && !productList.isEmpty()) {
                throw new AxelorException(1, I18n.get((String)"There is no analytic distribution on %s purchase order line"), new Object[]{productList});
            }
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }
}

