/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.supplychain.db.SupplyChainConfig;
import com.axelor.apps.supplychain.service.SaleOrderReservedQtyService;
import com.axelor.apps.supplychain.service.SaleOrderStockService;
import com.axelor.apps.supplychain.service.StockMoveServiceSupplychain;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.apps.supplychain.service.config.SupplyChainConfigService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import java.util.Optional;

public class StockMoveController {
    public void addSubLines(ActionRequest request, ActionResponse response) {
        try {
            StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
            response.setValue("stockMoveLineList", ((StockMoveServiceSupplychain)Beans.get(StockMoveServiceSupplychain.class)).addSubLines(stockMove.getStockMoveLineList()));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            response.setReload(true);
        }
    }

    public void removeSubLines(ActionRequest request, ActionResponse response) {
        try {
            StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
            response.setValue("stockMoveLineList", ((StockMoveServiceSupplychain)Beans.get(StockMoveServiceSupplychain.class)).removeSubLines(stockMove.getStockMoveLineList()));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            response.setReload(true);
        }
    }

    public void verifyProductStock(ActionRequest request, ActionResponse response) {
        try {
            StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
            if (stockMove.getPickingIsEdited().booleanValue() && !stockMove.getAvailabilityRequest().booleanValue()) {
                response.setValue("availabilityRequest", (Object)true);
                response.setFlash(I18n.get((String)"Please uncheck picking order edited box from this stock move from Cust. Shipment to prepare menu entry."));
                return;
            }
            ((StockMoveServiceSupplychain)Beans.get(StockMoveServiceSupplychain.class)).verifyProductStock(stockMove);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            response.setValue("availabilityRequest", (Object)false);
        }
    }

    public void allocateAll(ActionRequest request, ActionResponse response) {
        try {
            StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
            Company company = stockMove.getCompany();
            if (company == null) {
                return;
            }
            SupplyChainConfig supplyChainConfig = ((SupplyChainConfigService)Beans.get(SupplyChainConfigService.class)).getSupplyChainConfig(company);
            if (!(((AppSupplychainService)Beans.get(AppSupplychainService.class)).getAppSupplychain().getManageStockReservation().booleanValue() && stockMove.getAvailabilityRequest().booleanValue() && supplyChainConfig.getAutoAllocateOnAvailabilityRequest().booleanValue())) {
                return;
            }
            Optional<SaleOrder> saleOrderOpt = ((SaleOrderStockService)Beans.get(SaleOrderStockService.class)).findSaleOrder(stockMove);
            if (saleOrderOpt.isPresent()) {
                ((SaleOrderReservedQtyService)Beans.get(SaleOrderReservedQtyService.class)).allocateAll(saleOrderOpt.get());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            response.setReload(true);
        }
    }
}

