/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.web;

import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class StockMoveLineController {
    public void getProductPrice(ActionRequest request, ActionResponse response) {
        StockMoveLine stockMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
        Context context = request.getContext();
        Integer parentPackPriceSelect = (Integer)context.getParent().get((Object)"packPriceSelect");
        if (stockMoveLine.getPackPriceSelect() != null && stockMoveLine.getPackPriceSelect() == 1 && stockMoveLine.getLineTypeSelect() == 2) {
            response.setValue("unitPriceUntaxed", (Object)0.0);
            response.setValue("unitPriceTaxed", (Object)0.0);
        } else if (parentPackPriceSelect != null && stockMoveLine.getIsSubLine() != null && parentPackPriceSelect == 0) {
            response.setValue("unitPriceUntaxed", (Object)0.0);
            response.setValue("unitPriceTaxed", (Object)0.0);
        }
    }

    public List<StockMoveLine> updateQty(List<StockMoveLine> moveLines, BigDecimal oldKitQty, BigDecimal newKitQty, boolean isRealQty) {
        block4: {
            BigDecimal qty = BigDecimal.ZERO;
            if (moveLines == null) break block4;
            if (newKitQty.compareTo(BigDecimal.ZERO) != 0) {
                for (StockMoveLine line : moveLines) {
                    qty = line.getQty().divide(oldKitQty, 2, RoundingMode.HALF_EVEN).multiply(newKitQty);
                    line.setQty(qty.setScale(2, RoundingMode.HALF_EVEN));
                    line.setRealQty(qty.setScale(2, RoundingMode.HALF_EVEN));
                }
            } else {
                for (StockMoveLine line : moveLines) {
                    line.setQty(qty.setScale(2, RoundingMode.HALF_EVEN));
                    line.setRealQty(qty.setScale(2, RoundingMode.HALF_EVEN));
                }
            }
        }
        return moveLines;
    }

    public List<StockMoveLine> updateRealQty(List<StockMoveLine> moveLines, BigDecimal oldKitQty, BigDecimal newKitQty, boolean isRealQty) {
        block4: {
            BigDecimal qty = BigDecimal.ZERO;
            if (moveLines == null) break block4;
            if (newKitQty.compareTo(BigDecimal.ZERO) != 0) {
                for (StockMoveLine line : moveLines) {
                    qty = line.getRealQty().divide(oldKitQty, 2, RoundingMode.HALF_EVEN).multiply(newKitQty);
                    line.setRealQty(qty.setScale(2, RoundingMode.HALF_EVEN));
                }
            } else {
                for (StockMoveLine line : moveLines) {
                    line.setRealQty(qty.setScale(2, RoundingMode.HALF_EVEN));
                }
            }
        }
        return moveLines;
    }

    public void updateSubLineQty(ActionRequest request, ActionResponse response) {
        StockMoveLine titleMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
        BigDecimal oldKitQty = BigDecimal.ONE;
        BigDecimal newKitQty = BigDecimal.ZERO;
        List<StockMoveLine> subLines = null;
        if (titleMoveLine.getOldQty().compareTo(BigDecimal.ZERO) == 0) {
            StockMoveLine line;
            if (titleMoveLine.getId() != null && (line = (StockMoveLine)((Object)((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).find(titleMoveLine.getId()))).getQty().compareTo(BigDecimal.ZERO) != 0) {
                oldKitQty = line.getQty();
            }
        } else {
            oldKitQty = titleMoveLine.getOldQty();
        }
        if (titleMoveLine.getQty().compareTo(BigDecimal.ZERO) != 0) {
            newKitQty = titleMoveLine.getQty();
        }
        if (!titleMoveLine.getIsSubLine().booleanValue()) {
            subLines = this.updateQty(titleMoveLine.getSubLineList(), oldKitQty, newKitQty, false);
        }
        response.setValue("oldQty", (Object)newKitQty);
        response.setValue("subLineList", subLines);
    }

    public void updateSubLineRealQty(ActionRequest request, ActionResponse response) {
        StockMoveLine titleMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
        BigDecimal oldKitQty = BigDecimal.ONE;
        BigDecimal newKitQty = BigDecimal.ZERO;
        List<StockMoveLine> subLines = null;
        if (titleMoveLine.getOldQty().compareTo(BigDecimal.ZERO) == 0) {
            StockMoveLine line;
            if (titleMoveLine.getId() != null && (line = (StockMoveLine)((Object)((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).find(titleMoveLine.getId()))).getQty().compareTo(BigDecimal.ZERO) != 0) {
                oldKitQty = line.getQty();
            }
        } else {
            oldKitQty = titleMoveLine.getOldQty();
        }
        if (titleMoveLine.getRealQty().compareTo(BigDecimal.ZERO) != 0) {
            newKitQty = titleMoveLine.getRealQty();
        }
        if (!titleMoveLine.getIsSubLine().booleanValue()) {
            subLines = this.updateRealQty(titleMoveLine.getSubLineList(), oldKitQty, newKitQty, true);
        }
        response.setValue("oldQty", (Object)newKitQty);
        response.setValue("subLineList", subLines);
    }

    public void resetSubLines(ActionRequest request, ActionResponse response) {
        StockMoveLine packLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
        List<StockMoveLine> subLines = packLine.getSubLineList();
        if (subLines != null) {
            for (StockMoveLine line : subLines) {
                line.setUnitPriceTaxed(BigDecimal.ZERO);
                line.setUnitPriceUntaxed(BigDecimal.ZERO);
            }
        }
        response.setValue("subLineList", subLines);
    }
}

