/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.script.ImportPurchaseOrder;
import com.axelor.apps.sale.db.SaleConfig;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleConfigRepository;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.saleorder.SaleOrderWorkflowService;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.apps.supplychain.service.PurchaseOrderInvoiceService;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.PurchaseOrderStockServiceImpl;
import com.axelor.apps.supplychain.service.SaleOrderInvoiceService;
import com.axelor.apps.supplychain.service.SaleOrderStockService;
import com.axelor.apps.supplychain.service.SupplychainSaleConfigService;
import com.axelor.auth.AuthUtils;
import com.axelor.csv.script.ImportSaleOrder;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

public class ImportSupplyChain {
    @Inject
    protected PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl;
    @Inject
    protected PurchaseOrderStockServiceImpl purchaseOrderStockServiceImpl;
    @Inject
    protected InvoiceService invoiceService;
    @Inject
    protected SaleOrderStockService saleOrderStockService;
    @Inject
    protected StockMoveRepository stockMoveRepo;
    @Inject
    protected SaleOrderRepository saleOrderRepo;
    @Inject
    protected SaleConfigRepository saleConfigRepo;
    @Inject
    protected SupplychainSaleConfigService configService;
    @Inject
    protected StockConfigService stockConfigService;
    @Inject
    protected ImportPurchaseOrder importPurchaseOrder;
    @Inject
    protected ImportSaleOrder importSaleOrder;

    public Object importSupplyChain(Object bean, Map values) {
        List configs = this.saleConfigRepo.all().fetch();
        for (SaleConfig config : configs) {
            this.configService.updateCustomerCredit(config);
        }
        return bean;
    }

    @Transactional
    public Object importPurchaseOrderFromSupplyChain(Object bean, Map<String, Object> values) {
        try {
            StockMoveService stockMoveService = (StockMoveService)Beans.get(StockMoveService.class);
            PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)bean);
            int status = purchaseOrder.getStatusSelect();
            purchaseOrder = (PurchaseOrder)((Object)this.importPurchaseOrder.importPurchaseOrder(bean, values));
            for (Object line : purchaseOrder.getPurchaseOrderLineList()) {
                Product product = line.getProduct();
                if (product.getMassUnit() != null) continue;
                product.setMassUnit(this.stockConfigService.getStockConfig(purchaseOrder.getCompany()).getCustomsMassUnit());
            }
            if (status == 3 || status == 4) {
                this.purchaseOrderServiceSupplychainImpl.validatePurchaseOrder(purchaseOrder);
            }
            if (status == 4) {
                List<Long> idList = this.purchaseOrderStockServiceImpl.createStockMoveFromPurchaseOrder(purchaseOrder);
                for (Long id : idList) {
                    StockMove stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(id));
                    stockMoveService.copyQtyToRealQty(stockMove);
                    stockMoveService.realize(stockMove);
                    stockMove.setRealDate(purchaseOrder.getDeliveryDate());
                }
                purchaseOrder.setValidationDate(purchaseOrder.getOrderDate());
                purchaseOrder.setValidatedByUser(AuthUtils.getUser());
                purchaseOrder.setSupplierPartner(this.purchaseOrderServiceSupplychainImpl.validateSupplier(purchaseOrder));
                Invoice invoice = ((PurchaseOrderInvoiceService)Beans.get(PurchaseOrderInvoiceService.class)).generateInvoice(purchaseOrder);
                String prefixSupplierSeq = "INV000";
                invoice.setSupplierInvoiceNb(prefixSupplierSeq + purchaseOrder.getImportId());
                invoice.setInternalReference(purchaseOrder.getInternalReference());
                LocalDate date = purchaseOrder.getValidationDate() != null ? purchaseOrder.getValidationDate() : LocalDate.now();
                invoice.setInvoiceDate(date);
                invoice.setOriginDate(date.minusDays(15L));
                this.invoiceService.validateAndVentilate(invoice);
                this.purchaseOrderServiceSupplychainImpl.finishPurchaseOrder(purchaseOrder);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        return null;
    }

    @Transactional
    public Object importSaleOrderFromSupplyChain(Object bean, Map<String, Object> values) {
        try {
            SaleOrderWorkflowService saleOrderWorkflowService = (SaleOrderWorkflowService)Beans.get(SaleOrderWorkflowService.class);
            StockMoveService stockMoveService = (StockMoveService)Beans.get(StockMoveService.class);
            SaleOrder saleOrder = (SaleOrder)((Object)this.importSaleOrder.importSaleOrder(bean, values));
            for (SaleOrderLine line : saleOrder.getSaleOrderLineList()) {
                Product product = line.getProduct();
                if (product.getMassUnit() != null) continue;
                product.setMassUnit(this.stockConfigService.getStockConfig(saleOrder.getCompany()).getCustomsMassUnit());
            }
            if (saleOrder.getStatusSelect() == 2) {
                saleOrderWorkflowService.confirmSaleOrder(saleOrder);
                Invoice invoice = ((SaleOrderInvoiceService)Beans.get(SaleOrderInvoiceService.class)).generateInvoice(saleOrder);
                if (saleOrder.getConfirmationDateTime() != null) {
                    invoice.setInvoiceDate(saleOrder.getConfirmationDateTime().toLocalDate());
                } else {
                    invoice.setInvoiceDate(LocalDate.now());
                }
                this.invoiceService.validateAndVentilate(invoice);
                List<Long> idList = this.saleOrderStockService.createStocksMovesFromSaleOrder(saleOrder);
                for (Long id : idList) {
                    StockMove stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(id));
                    if (stockMove.getStockMoveLineList() == null || stockMove.getStockMoveLineList().isEmpty()) continue;
                    stockMoveService.copyQtyToRealQty(stockMove);
                    stockMoveService.validate(stockMove);
                    if (saleOrder.getConfirmationDateTime() == null) continue;
                    stockMove.setRealDate(saleOrder.getConfirmationDateTime().toLocalDate());
                }
            }
            this.saleOrderRepo.save((Model)((Object)saleOrder));
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        return null;
    }
}

