/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.internal;

import com.axelor.app.AppSettings;
import com.axelor.app.internal.AppFilter;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.User;
import com.axelor.auth.pac4j.AuthPac4jModule;
import com.axelor.common.StringUtils;
import com.axelor.common.VersionUtils;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaFile;
import com.axelor.script.CompositeScriptHelper;
import com.axelor.script.ScriptBindings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;

public class AppInfo {
    private static final AppSettings SETTINGS = AppSettings.get();
    private static final String APP_THEME = SETTINGS.get("application.theme", null);

    public Map<String, Object> info(ServletContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        User user = AuthUtils.getUser();
        if (user == null) {
            return map;
        }
        Group group = user.getGroup();
        Property nameField = Mapper.of(User.class).getNameField();
        Object nameValue = nameField.get((Object)user);
        map.put("user.id", user.getId());
        map.put("user.name", nameValue);
        map.put("user.login", user.getCode());
        map.put("user.nameField", nameField.getName());
        map.put("user.lang", AppFilter.getLocale().getLanguage());
        map.put("user.action", user.getHomeAction());
        map.put("user.singleTab", user.getSingleTab());
        map.put("user.noHelp", user.getNoHelp() == Boolean.TRUE);
        if (user.getImage() != null) {
            map.put("user.image", this.getLink(user, null));
        }
        if (group != null) {
            map.put("user.navigator", group.getNavigation());
            map.put("user.technical", group.getTechnicalStaff());
            map.put("user.group", group.getCode());
        }
        if (user.getHomeAction() == null && group != null) {
            map.put("user.action", group.getHomeAction());
        }
        map.put("application.name", SETTINGS.get("application.name"));
        map.put("application.description", SETTINGS.get("application.description"));
        map.put("application.version", SETTINGS.get("application.version"));
        map.put("application.author", SETTINGS.get("application.author"));
        map.put("application.copyright", SETTINGS.get("application.copyright"));
        map.put("application.home", SETTINGS.get("application.home"));
        map.put("application.help", SETTINGS.get("application.help"));
        map.put("application.mode", SETTINGS.get("application.mode", "dev"));
        map.put("file.upload.size", SETTINGS.get("file.upload.size", "5"));
        map.put("application.sdk", VersionUtils.getVersion().version);
        for (String string : SETTINGS.getProperties().stringPropertyNames()) {
            if (!string.startsWith("view.")) continue;
            Object value = SETTINGS.get(string);
            if ("true".equals(value) || "false".equals(value)) {
                value = Boolean.parseBoolean(value.toString());
            }
            map.put(string, value);
        }
        ArrayList<String> themes = new ArrayList<String>();
        for (String path : context.getResourcePaths("/css")) {
            try {
                if (!path.endsWith("/") || context.getResource(path + "theme.css") == null) continue;
                path = path.replace("/css/", "").replace("/", "");
                themes.add(path);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        Collections.sort(themes);
        map.put("application.themes", themes);
        if (AuthPac4jModule.isEnabled()) {
            ProfileManager profileManager = new ProfileManager((WebContext)new J2EContext((HttpServletRequest)Beans.get(HttpServletRequest.class), (HttpServletResponse)Beans.get(HttpServletResponse.class)));
            profileManager.get(true).filter(profile -> AuthPac4jModule.getCentralClients().contains(profile.getClientName())).ifPresent(profile -> map.put("auth.central.client", profile.getClientName()));
        }
        return map;
    }

    public String getStyle() {
        if (SETTINGS.get("context.appStyle") != null) {
            ScriptBindings bindings = new ScriptBindings(new HashMap());
            CompositeScriptHelper helper = new CompositeScriptHelper((Bindings)bindings);
            try {
                Object style = helper.eval("__config__.appStyle");
                if (style instanceof String) {
                    return style.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getLogo() throws JspException, IOException {
        String logo = SETTINGS.get("application.logo", "img/axelor.png");
        if (SETTINGS.get("context.appLogo") != null) {
            ScriptBindings bindings = new ScriptBindings(new HashMap());
            CompositeScriptHelper helper = new CompositeScriptHelper((Bindings)bindings);
            try {
                return this.getLink(helper.eval("__config__.appLogo"), logo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return logo;
    }

    public String getPageLang() {
        String lang = AppFilter.getLocale().getLanguage();
        return lang == null ? "en" : lang.substring(0, 2).toLowerCase();
    }

    public String getTheme() {
        User user = AuthUtils.getUser();
        if (user == null || StringUtils.isBlank((CharSequence)user.getTheme()) || "default".equals(user.getTheme())) {
            return APP_THEME;
        }
        return user.getTheme();
    }

    private String getLink(Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof MetaFile) {
            return "ws/rest/" + MetaFile.class.getName() + "/" + ((MetaFile)value).getId() + "/content/download?v=" + ((MetaFile)value).getVersion();
        }
        if (value instanceof User) {
            return "ws/rest/" + User.class.getName() + "/" + ((User)value).getId() + "/image/download?image=true&v=" + ((User)value).getVersion();
        }
        return defaultValue;
    }
}

