/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.service;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.web.AppSessionListener;
import com.axelor.web.internal.AppInfo;
import com.axelor.web.service.AbstractService;
import com.google.inject.servlet.RequestScoped;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.shiro.subject.support.DefaultSubjectContext;

@RequestScoped
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/app")
public class AboutService
extends AbstractService {
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;

    @GET
    @Path(value="info")
    public Map<String, Object> info() {
        AppInfo info = new AppInfo();
        return info.info(this.request.getServletContext());
    }

    @GET
    @Path(value="sysinfo")
    public Map<String, Object> getSystemInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        Runtime runtime = Runtime.getRuntime();
        Set<String> sessions = AppSessionListener.getActiveSessions();
        User user = AuthUtils.getUser();
        ArrayList users = new ArrayList();
        int mb = 1024;
        for (String id : sessions) {
            HttpSession session = AppSessionListener.getSession(id);
            try {
                if (session == null || session.getAttribute(DefaultSubjectContext.PRINCIPALS_SESSION_KEY) == null) continue;
                if (session.getAttribute(DefaultSubjectContext.AUTHENTICATED_SESSION_KEY) != Boolean.TRUE) {
                }
            }
            catch (IllegalStateException e) {}
            continue;
            String login = session.getAttribute(DefaultSubjectContext.PRINCIPALS_SESSION_KEY).toString();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("user", login);
            map.put("loginTime", session.getCreationTime());
            map.put("accessTime", session.getLastAccessedTime());
            users.add(map);
        }
        info.put("osName", System.getProperty("os.name"));
        info.put("osArch", System.getProperty("os.arch"));
        info.put("osVersion", System.getProperty("os.version"));
        info.put("javaRuntime", System.getProperty("java.runtime.name"));
        info.put("javaVersion", System.getProperty("java.runtime.version"));
        info.put("memTotal", runtime.totalMemory() / (long)mb + " Kb");
        info.put("memMax", runtime.maxMemory() / (long)mb + " Kb");
        info.put("memUsed", (runtime.totalMemory() - runtime.freeMemory()) / (long)mb + " Kb");
        info.put("memFree", runtime.freeMemory() / (long)mb + " Kb");
        if (AuthUtils.isTechnicalStaff((User)user)) {
            info.put("users", users);
        }
        return info;
    }
}

