/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.service;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.ObjectUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.JpaRepository;
import com.axelor.db.JpaSecurity;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.dms.db.DMSFile;
import com.axelor.inject.Beans;
import com.axelor.mail.db.MailAddress;
import com.axelor.mail.db.MailFollower;
import com.axelor.mail.db.MailMessage;
import com.axelor.mail.db.repo.MailFollowerRepository;
import com.axelor.mail.db.repo.MailMessageRepository;
import com.axelor.mail.service.MailService;
import com.axelor.mail.web.MailController;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaFileRepository;
import com.axelor.meta.service.MetaService;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.axelor.rpc.Request;
import com.axelor.web.service.ResourceService;
import com.axelor.web.service.ViewService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.inject.servlet.RequestScoped;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.bind.DatatypeConverter;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;

@RequestScoped
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/rest/{model}")
public class RestService
extends ResourceService {
    @Inject
    private MetaService service;
    @Inject
    private MailMessageRepository messages;
    @Inject
    private MailFollowerRepository followers;
    private static final String BLANK_IMAGE = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";
    private static Charset csvCharset = Charsets.ISO_8859_1;

    private com.axelor.rpc.Response fail() {
        com.axelor.rpc.Response response = new com.axelor.rpc.Response();
        return response.fail("invalid request");
    }

    @GET
    public com.axelor.rpc.Response find(@QueryParam(value="limit") @DefaultValue(value="40") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="q") String query) {
        Request request = new Request();
        request.setModel(this.getModel());
        request.setOffset(offset);
        request.setLimit(limit);
        return this.getResource().search(request);
    }

    private void updateContext(Request request) {
        Map data = request.getData();
        if (data == null || !data.containsKey("_domainAction")) {
            return;
        }
        String action = (String)data.get("_domainAction");
        Map old = (Map)data.get("_domainContext");
        ViewService.updateContext(action, old);
    }

    @POST
    @Path(value="search")
    public com.axelor.rpc.Response find(Request request) {
        if (request == null) {
            request = new Request();
            request.setOffset(0);
            request.setLimit(40);
        }
        request.setModel(this.getModel());
        this.updateContext(request);
        return this.getResource().search(request);
    }

    @POST
    public com.axelor.rpc.Response save(Request request) {
        if (request == null || ObjectUtils.isEmpty((Object)request.getRecords()) && ObjectUtils.isEmpty((Object)request.getData())) {
            return this.fail();
        }
        request.setModel(this.getModel());
        return this.getResource().save(request);
    }

    @PUT
    public com.axelor.rpc.Response create(Request request) {
        return this.save(request);
    }

    @GET
    @Path(value="{id}")
    public com.axelor.rpc.Response read(@PathParam(value="id") long id) {
        return this.getResource().read(id);
    }

    @POST
    @Path(value="{id}/fetch")
    public com.axelor.rpc.Response fetch(@PathParam(value="id") long id, Request request) {
        User user = AuthUtils.getUser();
        if (request == null || user == null) {
            return this.fail();
        }
        request.setModel(this.getModel());
        com.axelor.rpc.Response response = this.getResource().fetch(id, request);
        long attachments = Query.of(DMSFile.class).filter("self.id IN (SELECT x.id FROM DMSFile x LEFT JOIN x.permissions x_permissions LEFT JOIN x_permissions.group x_permissions_group LEFT JOIN x_permissions.user x_permissions_user WHERE x.relatedId = :id AND x.relatedModel = :model AND COALESCE(x.isDirectory, FALSE) = FALSE AND (x_permissions_group = :group OR x_permissions_user = :user OR :isAdmin = TRUE))").bind("id", (Object)id).bind("model", (Object)this.getModel()).bind("group", (Object)user.getGroup()).bind("user", (Object)user).bind("isAdmin", (Object)AuthUtils.isAdmin((User)user)).cacheable().count();
        if (response.getItem(0) != null) {
            Map item = (Map)response.getItem(0);
            item.put("$attachments", attachments);
        }
        return response;
    }

    @POST
    @Path(value="{id}")
    public com.axelor.rpc.Response update(@PathParam(value="id") long id, Request request) {
        if (request == null || ObjectUtils.isEmpty((Object)request.getData())) {
            return this.fail();
        }
        ArrayList<Map> records = new ArrayList<Map>();
        Map data = request.getData();
        data.put("id", id);
        records.add(data);
        request.setRecords(records);
        request.setModel(this.getModel());
        return this.getResource().save(request);
    }

    @POST
    @Path(value="updateMass")
    public com.axelor.rpc.Response updateMass(Request request) {
        if (request == null || ObjectUtils.isEmpty((Object)request.getData())) {
            return this.fail();
        }
        request.setModel(this.getModel());
        return this.getResource().updateMass(request);
    }

    @DELETE
    @Path(value="{id}")
    public com.axelor.rpc.Response delete(@PathParam(value="id") long id, @QueryParam(value="version") int version) {
        Request request = new Request();
        request.setModel(this.getModel());
        request.setData((Map)ImmutableMap.of((Object)"id", (Object)id, (Object)"version", (Object)version));
        return this.getResource().remove(id, request);
    }

    @POST
    @Path(value="{id}/remove")
    public com.axelor.rpc.Response remove(@PathParam(value="id") long id, Request request) {
        if (request == null || ObjectUtils.isEmpty((Object)request.getData())) {
            return this.fail();
        }
        request.setModel(this.getModel());
        return this.getResource().remove(id, request);
    }

    @POST
    @Path(value="removeAll")
    public com.axelor.rpc.Response remove(Request request) {
        if (request == null || ObjectUtils.isEmpty((Object)request.getRecords())) {
            return this.fail();
        }
        request.setModel(this.getModel());
        return this.getResource().remove(request);
    }

    @GET
    @Path(value="{id}/copy")
    public com.axelor.rpc.Response copy(@PathParam(value="id") long id) {
        return this.getResource().copy(id);
    }

    @GET
    @Path(value="{id}/details")
    public com.axelor.rpc.Response details(@PathParam(value="id") long id, @QueryParam(value="name") String name) {
        Request request = new Request();
        HashMap<String, Long> data = new HashMap<String, Long>();
        data.put("id", id);
        request.setModel(this.getModel());
        request.setData(data);
        request.setFields((List)Lists.newArrayList((Object[])new String[]{name}));
        return this.getResource().getRecordName(request);
    }

    private void uploadSave(InputStream in, OutputStream out) throws IOException {
        int read = 0;
        byte[] bytes = new byte[1024];
        while ((read = in.read(bytes)) != -1) {
            out.write(bytes, 0, read);
        }
        out.flush();
        out.close();
        in.close();
    }

    private String getFileName(MultivaluedMap<String, String> headers) {
        String[] parts;
        for (String filename : parts = ((String)headers.getFirst((Object)"Content-Disposition")).split(";")) {
            if (!filename.trim().startsWith("filename")) continue;
            String name = filename.split("=")[1].trim();
            name = name.replaceAll("^\"|\"$", "");
            return new File(name).getName();
        }
        return null;
    }

    @POST
    @Path(value="upload")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public com.axelor.rpc.Response upload(MultipartFormDataInput input) throws IOException {
        MetaFile metaFile;
        Map formData = input.getFormDataMap();
        InputPart filePart = (InputPart)((List)formData.get("file")).get(0);
        InputPart requestPart = (InputPart)((List)formData.get("request")).get(0);
        InputPart fieldPart = (InputPart)((List)formData.get("field")).get(0);
        boolean isAttachment = MetaFile.class.getName().equals(this.getModel());
        String field = fieldPart.getBodyAsString();
        String fileName = this.getFileName((MultivaluedMap<String, String>)filePart.getHeaders());
        String fileType = (String)filePart.getHeaders().getFirst((Object)"Content-Type");
        MetaFiles.checkPath((String)fileName);
        MetaFiles.checkType((String)fileType);
        InputStream fileStream = (InputStream)filePart.getBody(InputStream.class, null);
        Request request = (Request)((ObjectMapper)Beans.get(ObjectMapper.class)).readValue(requestPart.getBodyAsString(), Request.class);
        request.setModel(this.getModel());
        Map data = request.getData();
        if (!isAttachment) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.uploadSave(fileStream, out);
            data.put(field, out.toByteArray());
            return this.getResource().save(request);
        }
        MetaFiles files = (MetaFiles)Beans.get(MetaFiles.class);
        MetaFileRepository repo = (MetaFileRepository)Beans.get(MetaFileRepository.class);
        MetaFile entity = metaFile = (MetaFile)Mapper.toBean(MetaFile.class, (Map)data);
        if (metaFile.getId() != null) {
            entity = (MetaFile)repo.find(metaFile.getId());
        }
        entity.setFileName(metaFile.getFileName());
        entity.setFileType(metaFile.getFileType());
        File tmp = files.upload(fileStream, 0L, -1L, fileName);
        entity = files.upload(tmp, entity);
        com.axelor.rpc.Response response = new com.axelor.rpc.Response();
        response.setData(Arrays.asList(entity));
        response.setStatus(com.axelor.rpc.Response.STATUS_SUCCESS);
        return response;
    }

    private Response download(MetaFile metaFile) {
        Mapper mapper = Mapper.of(MetaFile.class);
        String fileName = (String)mapper.get((Object)metaFile, "fileName");
        String filePath = (String)mapper.get((Object)metaFile, "filePath");
        MetaFiles cfr_ignored_0 = (MetaFiles)Beans.get(MetaFiles.class);
        final File inputFile = MetaFiles.getPath((String)filePath).toFile();
        if (!inputFile.exists()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                RestService.this.uploadSave(new FileInputStream(inputFile), output);
            }
        }).header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"")).build();
    }

    @GET
    @Path(value="{id}/{field}/download")
    @Produces(value={"application/octet-stream"})
    public Response download(@PathParam(value="id") Long id, @PathParam(value="field") String field, @QueryParam(value="image") boolean isImage, @QueryParam(value="parentId") Long parentId, @QueryParam(value="parentModel") String parentModel) throws IOException {
        Class klass = this.getResource().getModel();
        boolean permittedByParent = false;
        if (MetaFile.class.isAssignableFrom(klass)) {
            User user;
            block17: {
                if (parentId != null && StringUtils.notBlank((CharSequence)parentModel)) {
                    try {
                        Class<?> parentClass = Class.forName(parentModel);
                        Model parent = JpaRepository.of(parentClass).find(parentId);
                        if (parent == null) break block17;
                        Mapper mapper = Mapper.of(parentClass);
                        Context context = new Context(Mapper.toMap((Object)parent), parentClass);
                        block4: for (Property property : mapper.getProperties()) {
                            MetaFile metaFile;
                            if (property.isJson()) {
                                Map jsonFields = MetaStore.findJsonFields((String)parentModel, (String)property.getName());
                                for (Map.Entry entry : jsonFields.entrySet()) {
                                    MetaFile metaFile2;
                                    String target;
                                    Map value = (Map)entry.getValue();
                                    if (value == null || (target = (String)value.get("target")) == null || !MetaFile.class.isAssignableFrom(Class.forName(target)) || (metaFile2 = (MetaFile)context.get(entry.getKey())) == null || !Objects.equals(metaFile2.getId(), id)) continue;
                                    permittedByParent = ((JpaSecurity)Beans.get(JpaSecurity.class)).isPermitted(JpaSecurity.CAN_READ, parentClass, new Long[]{parentId});
                                    continue block4;
                                }
                                continue;
                            }
                            if (property.getTarget() == null || !MetaFile.class.isAssignableFrom(property.getTarget()) || (metaFile = (MetaFile)context.get((Object)property.getName())) == null || !Objects.equals(metaFile.getId(), id)) continue;
                            permittedByParent = ((JpaSecurity)Beans.get(JpaSecurity.class)).isPermitted(JpaSecurity.CAN_READ, parentClass, new Long[]{parentId});
                            break;
                        }
                    }
                    catch (ClassNotFoundException parentClass) {
                        // empty catch block
                    }
                }
            }
            if (!permittedByParent && (user = AuthUtils.getUser()) != null && JpaRepository.of(DMSFile.class).all().filter("self.metaFile.id = :id AND (self.permissions.group = :group OR self.permissions.user = :user)").bind("id", (Object)id).bind("group", (Object)user.getGroup()).bind("user", (Object)user).fetchOne() != null) {
                permittedByParent = true;
            }
        }
        if (!permittedByParent && !this.getResource().isPermitted(JpaSecurity.CAN_READ, id)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Mapper mapper = Mapper.of((Class)klass);
        Model bean = JPA.find((Class)klass, (Long)id);
        if (bean == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (bean instanceof MetaFile) {
            return this.download((MetaFile)bean);
        }
        String fileName = this.getModel() + "_" + field;
        Object data = mapper.get((Object)bean, field);
        if (data instanceof MetaFile) {
            return this.download((MetaFile)data);
        }
        if (isImage) {
            String base64 = BLANK_IMAGE;
            if (data instanceof byte[]) {
                base64 = new String((byte[])data);
            }
            try {
                base64 = base64.substring(base64.indexOf(";base64,") + 8);
                data = DatatypeConverter.parseBase64Binary((String)base64);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Response.ok((Object)data).build();
        }
        fileName = fileName.replaceAll("\\s", "") + "_" + id;
        fileName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fileName);
        if (data == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)data).header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"")).build();
    }

    @POST
    @Path(value="{id}/attachment")
    public com.axelor.rpc.Response attachment(@PathParam(value="id") long id, Request request) {
        if (request == null || ObjectUtils.isEmpty((Object)request.getFields())) {
            return this.fail();
        }
        request.setModel(this.getModel());
        return this.service.getAttachment(id, this.getModel(), request);
    }

    @POST
    @Path(value="removeAttachment")
    public com.axelor.rpc.Response removeAttachment(Request request) {
        if (request == null || ObjectUtils.isEmpty((Object)request.getRecords())) {
            return this.fail();
        }
        request.setModel(this.getModel());
        return this.service.removeAttachment(request);
    }

    @POST
    @Path(value="{id}/addAttachment")
    public com.axelor.rpc.Response addAttachment(@PathParam(value="id") long id, Request request) {
        if (request == null || ObjectUtils.isEmpty((Object)request.getData())) {
            return this.fail();
        }
        request.setModel(this.getModel());
        return this.service.addAttachment(id, request);
    }

    @POST
    @Path(value="verify")
    public com.axelor.rpc.Response verify(Request request) {
        if (request == null || ObjectUtils.isEmpty((Object)request.getData())) {
            return this.fail();
        }
        request.setModel(this.getModel());
        return this.getResource().verify(request);
    }

    @GET
    @Path(value="perms")
    public com.axelor.rpc.Response perms(@QueryParam(value="action") String action, @QueryParam(value="id") Long id) {
        if (action != null && id != null) {
            return this.getResource().perms(id, action);
        }
        if (id != null) {
            return this.getResource().perms(id);
        }
        return this.getResource().perms();
    }

    @HEAD
    @Path(value="export/{name}")
    public Response exportCheck(@PathParam(value="name") String name) {
        return Files.exists(MetaFiles.findTempFile((String)name), new LinkOption[0]) ? Response.ok().build() : Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="export/{name}")
    @Produces(value={"text/csv"})
    public StreamingOutput export(@PathParam(value="name") String name) {
        final java.nio.file.Path temp = MetaFiles.findTempFile((String)name);
        if (Files.notExists(temp, new LinkOption[0])) {
            throw new IllegalArgumentException(name);
        }
        return new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(OutputStream output) throws IOException, WebApplicationException {
                try (FileInputStream is = new FileInputStream(temp.toFile());){
                    RestService.this.uploadSave(is, output);
                }
                finally {
                    Files.deleteIfExists(temp);
                }
            }
        };
    }

    @POST
    @Path(value="export")
    public com.axelor.rpc.Response export(Request request) {
        if (request == null || request.getFields() == null) {
            return this.fail();
        }
        com.axelor.rpc.Response response = new com.axelor.rpc.Response();
        HashMap<String, Object> data = new HashMap<String, Object>();
        request.setModel(this.getModel());
        this.updateContext(request);
        try {
            java.nio.file.Path tempFile = MetaFiles.createTempFile(null, (String)".csv", (FileAttribute[])new FileAttribute[0]);
            try (FileOutputStream os = new FileOutputStream(tempFile.toFile());
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, csvCharset);){
                data.put("exportSize", this.getResource().export(request, (Writer)writer));
            }
            data.put("fileName", tempFile.toFile().getName());
            response.setData(data);
        }
        catch (IOException e) {
            response.setException((Throwable)e);
        }
        return response;
    }

    @GET
    @Path(value="messages")
    public com.axelor.rpc.Response messages(@QueryParam(value="folder") String folder, @QueryParam(value="parent") Long parentId, @QueryParam(value="count") boolean count, @QueryParam(value="limit") @DefaultValue(value="10") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="relatedId") Long relatedId, @QueryParam(value="relatedModel") String relatedModel) {
        ArrayList<Object> records;
        JpaRepository repo;
        MailController ctrl = (MailController)Beans.get(MailController.class);
        ActionRequest req = new ActionRequest();
        ActionResponse res = new ActionResponse();
        req.setModel(relatedModel);
        req.setOffset(offset.intValue());
        req.setLimit(limit.intValue());
        Class<?> relatedClass = null;
        Model related = null;
        try {
            relatedClass = Class.forName(relatedModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (relatedClass != null && relatedId != null && (repo = JpaRepository.of(relatedClass)) != null) {
            related = repo.find(relatedId);
        }
        if (related != null) {
            records = new ArrayList<Object>();
            records.add(related);
            req.setRecords(records);
            ctrl.related(req, res);
            return res;
        }
        if (count) {
            ctrl.countUnread(req, res);
            return res;
        }
        if (parentId != null) {
            records = new ArrayList();
            records.add(parentId);
            req.setRecords(records);
            ctrl.replies(req, res);
            return res;
        }
        if (folder == null) {
            return res;
        }
        switch (folder) {
            case "archive": {
                ctrl.archived(req, res);
                return res;
            }
            case "important": {
                ctrl.important(req, res);
                return res;
            }
            case "unread": {
                ctrl.unread(req, res);
                return res;
            }
        }
        ctrl.inbox(req, res);
        return res;
    }

    @GET
    @Path(value="{id}/followers")
    public com.axelor.rpc.Response messageFollowers(@PathParam(value="id") long id) {
        JpaRepository repo = JpaRepository.of((Class)this.getResource().getModel());
        Model entity = repo.find(Long.valueOf(id));
        com.axelor.rpc.Response response = new com.axelor.rpc.Response();
        List all = this.followers.findFollowers(entity);
        response.setData((Object)all);
        response.setStatus(com.axelor.rpc.Response.STATUS_SUCCESS);
        return response;
    }

    @POST
    @Path(value="{id}/follow")
    public com.axelor.rpc.Response messageFollow(@PathParam(value="id") long id, Request request) {
        JpaRepository repo = JpaRepository.of((Class)this.getResource().getModel());
        Model entity = repo.find(Long.valueOf(id));
        if (entity == null) {
            return this.messageFollowers(id);
        }
        if (request == null || request.getData() == null) {
            this.followers.follow(entity, AuthUtils.getUser());
            return this.messageFollowers(id);
        }
        MailMessage message = (MailMessage)Mapper.toBean(MailMessage.class, (Map)request.getData());
        if (message == null || message.getRecipients() == null || message.getRecipients().isEmpty()) {
            return this.messageFollowers(id);
        }
        for (MailAddress address : message.getRecipients()) {
            this.followers.follow(entity, address);
        }
        if (!StringUtils.isBlank((CharSequence)message.getBody())) {
            MailService mailService = (MailService)Beans.get(MailService.class);
            try {
                mailService.send(message);
            }
            catch (Exception e) {
                this.LOG.error("Unable to send email message to new followers", (Throwable)e);
            }
        }
        return this.messageFollowers(id);
    }

    @POST
    @Path(value="{id}/unfollow")
    public com.axelor.rpc.Response messageUnfollow(@PathParam(value="id") long id, Request request) {
        JpaRepository repo = JpaRepository.of((Class)this.getResource().getModel());
        Model entity = repo.find(Long.valueOf(id));
        if (entity == null) {
            return this.messageFollowers(id);
        }
        if (request == null || request.getRecords() == null || request.getRecords().isEmpty()) {
            this.followers.unfollow(entity, AuthUtils.getUser());
            return this.messageFollowers(id);
        }
        for (Object item : request.getRecords()) {
            MailFollower follower = (MailFollower)this.followers.find(Longs.tryParse((String)item.toString()));
            if (follower == null) continue;
            this.followers.unfollow(follower);
        }
        return this.messageFollowers(id);
    }

    @POST
    @Path(value="{id}/message")
    public com.axelor.rpc.Response messagePost(@PathParam(value="id") long id, Request request) {
        if (request == null || ObjectUtils.isEmpty((Object)request.getData())) {
            return this.fail();
        }
        com.axelor.rpc.Response response = new com.axelor.rpc.Response();
        JpaRepository repo = JpaRepository.of((Class)this.getResource().getModel());
        Context ctx = new Context(request.getData(), MailMessage.class);
        MailMessage msg = (MailMessage)EntityHelper.getEntity((Object)ctx.asType(MailMessage.class));
        Model entity = repo.find(Long.valueOf(id));
        List ids = (List)request.getData().get("files");
        List files = null;
        if (ids != null && ids.size() > 0) {
            MetaFileRepository repoFiles = (MetaFileRepository)Beans.get(MetaFileRepository.class);
            files = repoFiles.all().filter("self.id IN :ids").bind("ids", (Object)ids).fetch();
        }
        MailMessage saved = this.messages.post((Model)(entity == null ? msg : entity), msg, files);
        Map item = this.messages.details(saved);
        response.setData((Object)Lists.newArrayList((Object[])new Object[]{item}));
        response.setStatus(com.axelor.rpc.Response.STATUS_SUCCESS);
        return response;
    }

    static {
        try {
            csvCharset = Charset.forName(AppSettings.get().get("data.export.encoding"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

