/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.service;

import com.axelor.mail.service.MailService;
import com.axelor.meta.service.MetaService;
import com.axelor.rpc.Request;
import com.axelor.rpc.Response;
import com.google.inject.servlet.RequestScoped;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.mail.internet.InternetAddress;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@RequestScoped
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/search")
public class SearchService {
    @Inject
    private MetaService metaService;
    @Inject
    private MailService mailService;

    @POST
    public Response run(Request request) {
        return this.metaService.runSearch(request);
    }

    @POST
    @Path(value="emails")
    public Response emails(Request request) {
        Response response = new Response();
        String matching = (String)request.getData().get("search");
        List selected = (List)request.getData().get("selected");
        List addresses = this.mailService.findEmails(matching, selected, request.getLimit());
        ArrayList data = new ArrayList();
        for (InternetAddress address : addresses) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("address", address.getAddress());
            item.put("personal", address.getPersonal());
            data.add(item);
        }
        response.setData(data);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    @GET
    @Path(value="menu")
    public Response menu(@QueryParam(value="parent") @DefaultValue(value="") String parent, @QueryParam(value="category") @DefaultValue(value="") String category) {
        Response response = new Response();
        try {
            response.setData((Object)this.metaService.getActionMenus(parent, category));
            response.setStatus(Response.STATUS_SUCCESS);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setException((Throwable)e);
        }
        return response;
    }
}

