/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.service;

import com.axelor.auth.AuthUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.JpaSecurity;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.inject.Beans;
import com.axelor.meta.ActionExecutor;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.meta.schema.actions.Action;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.meta.schema.views.AbstractWidget;
import com.axelor.meta.schema.views.Dashboard;
import com.axelor.meta.schema.views.Field;
import com.axelor.meta.schema.views.FormInclude;
import com.axelor.meta.schema.views.FormView;
import com.axelor.meta.schema.views.GridView;
import com.axelor.meta.schema.views.MenuItem;
import com.axelor.meta.schema.views.Notebook;
import com.axelor.meta.schema.views.Panel;
import com.axelor.meta.schema.views.PanelField;
import com.axelor.meta.schema.views.PanelRelated;
import com.axelor.meta.schema.views.PanelTabs;
import com.axelor.meta.schema.views.Search;
import com.axelor.meta.schema.views.SearchFilters;
import com.axelor.meta.schema.views.SimpleContainer;
import com.axelor.meta.schema.views.SimpleWidget;
import com.axelor.meta.service.MetaService;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Request;
import com.axelor.rpc.Response;
import com.axelor.web.service.AbstractService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;

@RequestScoped
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/meta")
public class ViewService
extends AbstractService {
    @Inject
    private MetaService service;
    @Inject
    private JpaSecurity security;

    private Class<?> findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @GET
    @Path(value="models")
    public Response models() {
        Response response = new Response();
        ArrayList all = Lists.newArrayList();
        for (Class cls : JPA.models()) {
            if (!this.security.isPermitted(JpaSecurity.AccessType.READ, cls, new Long[0])) continue;
            all.add(cls.getName());
        }
        Collections.sort(all);
        response.setData((Object)all);
        response.setTotal((long)all.size());
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    @GET
    @Path(value="fields/{model}")
    public Response fields(@PathParam(value="model") String model, @QueryParam(value="jsonModel") String jsonModel) {
        Response response = new Response();
        HashMap meta = Maps.newHashMap();
        Class<?> modelClass = this.findClass(model);
        if (!this.security.isPermitted(JpaSecurity.AccessType.READ, modelClass, new Long[0])) {
            response.setStatus(Response.STATUS_FAILURE);
            return response;
        }
        HashMap jsonFields = Maps.newHashMap();
        ArrayList names = Lists.newArrayList();
        meta.put("model", model);
        meta.put("jsonFields", jsonFields);
        if (StringUtils.isBlank((CharSequence)jsonModel)) {
            for (Property p : Mapper.of(modelClass).getProperties()) {
                if (!p.isTransient()) {
                    names.add(p.getName());
                }
                if (!p.isJson()) continue;
                jsonFields.put(p.getName(), MetaStore.findJsonFields((String)model, (String)p.getName()));
            }
            meta.putAll(MetaStore.findFields(modelClass, (Collection)names));
        } else if (MetaJsonRecord.class.getName().equals(model)) {
            names.add("attrs");
            meta.putAll(MetaStore.findFields(modelClass, (Collection)names));
            jsonFields.put("attrs", MetaStore.findJsonFields((String)jsonModel));
        }
        response.setData((Object)meta);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    @GET
    @Path(value="views/{model}")
    public Response views(@PathParam(value="model") String model) {
        MultivaluedMap params = this.getUriInfo().getQueryParameters(true);
        HashMap views = Maps.newHashMap();
        for (String mode : params.keySet()) {
            views.put(mode, params.getFirst((Object)mode));
        }
        return this.service.findViews(this.findClass(model), (Map)views);
    }

    private Set<String> findNames(Set<String> names, AbstractWidget widget) {
        String depends;
        List all = null;
        if (widget instanceof Notebook) {
            all = ((Notebook)widget).getPages();
        } else if (widget instanceof SimpleContainer) {
            all = ((SimpleContainer)widget).getItems();
        } else if (widget instanceof Panel) {
            all = ((Panel)widget).getItems();
        } else if (widget instanceof PanelTabs) {
            all = ((PanelTabs)widget).getItems();
        } else if (widget instanceof FormInclude) {
            names.addAll(this.findNames(((FormInclude)widget).getView()));
        } else if (widget instanceof Field) {
            String relatedAttr;
            names.add(((Field)widget).getName());
            if (widget instanceof PanelField) {
                String depends2;
                PanelField field = (PanelField)widget;
                if (field.getEditor() != null && field.getTarget() == null) {
                    all = field.getEditor().getItems();
                }
                if (field.getViewer() != null && field.getTarget() == null && StringUtils.notBlank((CharSequence)(depends2 = field.getViewer().getDepends()))) {
                    Collections.addAll(names, depends2.trim().split("\\s*,\\s*"));
                }
            }
            if (StringUtils.notBlank((CharSequence)(relatedAttr = ((Field)widget).getRelated()))) {
                names.add(relatedAttr);
            }
        } else if (widget instanceof PanelRelated) {
            names.add(((PanelRelated)widget).getName());
        }
        if (widget instanceof SimpleWidget && StringUtils.notBlank((CharSequence)(depends = ((SimpleWidget)widget).getDepends()))) {
            Collections.addAll(names, depends.trim().split("\\s*,\\s*"));
        }
        if (widget instanceof MenuItem && StringUtils.notBlank((CharSequence)(depends = ((MenuItem)widget).getDepends()))) {
            Collections.addAll(names, depends.trim().split("\\s*,\\s*"));
        }
        if (all == null) {
            return names;
        }
        for (AbstractWidget item : all) {
            this.findNames(names, item);
        }
        return names;
    }

    private Set<String> findNames(AbstractView view) {
        HashSet<String> names = new HashSet<String>();
        ArrayList items = new ArrayList();
        Consumer<List> collect = all -> Optional.ofNullable(all).ifPresent(items::addAll);
        if (view instanceof FormView) {
            FormView form = (FormView)view;
            collect.accept(form.getItems());
            if (form.getToolbar() != null) {
                items.addAll(form.getToolbar());
            }
            if (form.getMenubar() != null) {
                form.getMenubar().stream().filter(m -> m.getItems() != null).forEach(m -> collect.accept(m.getItems()));
            }
        }
        if (view instanceof GridView) {
            GridView grid = (GridView)view;
            collect.accept(grid.getItems());
            if ("sequence".equals(grid.getOrderBy())) {
                names.add("sequence");
            }
        }
        if (view instanceof SearchFilters) {
            collect.accept(((SearchFilters)view).getItems());
        }
        if (items.isEmpty()) {
            return names;
        }
        for (AbstractWidget widget : items) {
            this.findNames(names, widget);
        }
        return names;
    }

    @GET
    @Path(value="view")
    public Response view(@QueryParam(value="model") String model, @QueryParam(value="name") String name, @QueryParam(value="type") String type) {
        Response response = this.service.findView(model, name, type);
        AbstractView view = (AbstractView)response.getData();
        HashMap data = Maps.newHashMap();
        data.put("view", view);
        if (view instanceof Search && ((Search)view).getSearchForm() != null) {
            String searchForm = ((Search)view).getSearchForm();
            Response searchResponse = this.service.findView(null, searchForm, "form");
            data.put("searchForm", searchResponse.getData());
        }
        Class<?> modelClass = this.findClass(model);
        if (view instanceof AbstractView && modelClass != null) {
            Set<String> names = this.findNames(view);
            if (view instanceof FormView || view instanceof GridView) {
                Map jsonAttrs;
                Mapper mapper = Mapper.of(modelClass);
                boolean hasJson = names.stream().map(arg_0 -> ((Mapper)mapper).getProperty(arg_0)).filter(Objects::nonNull).anyMatch(Property::isJson);
                if (!hasJson && mapper.getProperty("attrs") != null && (jsonAttrs = MetaStore.findJsonFields((String)model, (String)"attrs")) != null && jsonAttrs.size() > 0) {
                    names.add("attrs");
                    data.put("jsonAttrs", jsonAttrs.values());
                }
            }
            data.putAll(MetaStore.findFields(modelClass, names));
        }
        response.setData((Object)data);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    @POST
    @Path(value="view")
    public Response view(Request request) {
        Map data = request.getData();
        String name = (String)data.get("name");
        String type = (String)data.get("type");
        return this.view(request.getModel(), name, type);
    }

    @POST
    @Path(value="view/fields")
    public Response viewFields(Request request) {
        Response response = new Response();
        response.setData((Object)MetaStore.findFields((Class)request.getBeanClass(), (Collection)request.getFields()));
        return response;
    }

    @POST
    @Path(value="view/save")
    public Response save(Request request) {
        Map data = request.getData();
        ObjectMapper om = (ObjectMapper)Beans.get(ObjectMapper.class);
        try {
            String type = (String)data.get("type");
            String json = om.writeValueAsString((Object)data);
            AbstractView view = null;
            switch (type) {
                case "dashboard": {
                    view = (AbstractView)om.readValue(json, Dashboard.class);
                }
            }
            if (view != null) {
                return this.service.saveView(view, AuthUtils.getUser());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @GET
    @Path(value="chart/{name}")
    public Response chart(@PathParam(value="name") String name) {
        MultivaluedMap params = this.getUriInfo().getQueryParameters(true);
        HashMap context = Maps.newHashMap();
        Request request = new Request();
        for (String key : params.keySet()) {
            List values = (List)params.get((Object)key);
            if (values.size() == 1) {
                context.put(key, values.get(0));
                continue;
            }
            context.put(key, values);
        }
        request.setData((Map)context);
        return this.service.getChart(name, request);
    }

    @POST
    @Path(value="chart/{name}")
    public Response chart(@PathParam(value="name") String name, Request request) {
        Map data = request.getData();
        if (data == null || data.get("_domainAction") == null) {
            return this.service.getChart(name, request);
        }
        ViewService.updateContext((String)data.get("_domainAction"), data);
        return this.service.getChart(name, request);
    }

    @POST
    @Path(value="custom/{name}")
    public Response dataset(@PathParam(value="name") String name, Request request) {
        return this.service.getDataSet(name, request);
    }

    static Map<String, Object> updateContext(String action, Map<String, Object> domainContext) {
        Map ctx;
        if (action == null || domainContext == null) {
            return domainContext;
        }
        Action act = MetaStore.getAction((String)action);
        if (act == null) {
            return domainContext;
        }
        String model = (String)domainContext.get("_model");
        ActionRequest actRequest = new ActionRequest();
        HashMap<String, Object> actData = new HashMap<String, Object>();
        actData.put("_model", model);
        actData.put("_domainAction", action);
        actData.put("_domainContext", domainContext);
        actRequest.setModel(model);
        actRequest.setAction(action);
        actRequest.setData(actData);
        ActionExecutor executor = (ActionExecutor)Beans.get(ActionExecutor.class);
        ActionHandler handler = executor.newActionHandler(actRequest);
        Object res = act.execute(handler);
        if (res instanceof ActionResponse && (res = ((ActionResponse)res).getItem(0)) instanceof Map && ((Map)res).containsKey("view")) {
            res = ((Map)res).get("view");
        }
        if (res instanceof Map && (ctx = (Map)((Map)res).get("context")) != null) {
            domainContext.putAll(ctx);
        }
        return domainContext;
    }
}

