/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.servlet;

import com.axelor.app.AppSettings;
import com.axelor.app.internal.AppFilter;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class NoCacheFilter
implements Filter {
    public static final String[] STATIC_URL_PATTERNS = new String[]{"/static/*", "/public/*", "/partials/*", "/images/*", "/javascript/*", "/dist/*", "/lib/*", "/img/*", "/ico/*", "/css/*", "/js/*", "*.js", "*.css", "*.png", "*.jpg"};
    private static final String CACHE_BUSTER_PARAM = "" + Calendar.getInstance().getTimeInMillis();
    private boolean production;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.production = AppSettings.get().isProduction();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String uri = req.getRequestURI();
        boolean busted = req.getParameterMap().containsKey(CACHE_BUSTER_PARAM);
        if (uri.contains(".gzip.")) {
            res.setHeader("Content-Encoding", "gzip");
        }
        if (this.production && !busted) {
            res.sendRedirect(URI.create(AppFilter.getBaseURL()).resolve(uri + "?" + CACHE_BUSTER_PARAM).toString());
            return;
        }
        if (!this.production) {
            res.setHeader("Expires", "Fri, 01 Jan 1990 00:00:00 GMT");
            res.setHeader("Last-Modified", new Date().toString());
            if (uri.matches(".*\\.(eot|ttf|woff|woff2).*")) {
                res.setHeader("Cache-Control", "no-cache, must-revalidate, max-age=0, post-check=0, pre-check=0");
            } else {
                res.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0, post-check=0, pre-check=0");
                res.setHeader("Pragma", "no-cache");
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

