/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.exception.service;

import com.axelor.auth.AuthUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.db.TraceBack;
import com.axelor.exception.db.repo.TraceBackRepository;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionResponse;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceBackService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final int TYPE_TECHNICAL = 0;
    protected static final int TYPE_FUNCTIONAL = 1;

    private static TraceBack _create(Throwable e, String origin, int typeSelect, int categorySelect, long batchId) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        TraceBack traceBack = new TraceBack();
        traceBack.setException(e.toString());
        traceBack.setDate(ZonedDateTime.now());
        traceBack.setError(e.getStackTrace() != null && e.getStackTrace().length > 0 ? e.getStackTrace()[0].toString() : e.getMessage());
        traceBack.setOrigin(origin);
        traceBack.setTypeSelect(typeSelect);
        traceBack.setCategorySelect(categorySelect);
        traceBack.setBatchId(batchId);
        if (AuthUtils.getSubject() != null) {
            traceBack.setInternalUser(AuthUtils.getUser());
        }
        if (e.getCause() != null) {
            traceBack.setCause(e.getCause().toString());
        }
        if (e.getMessage() != null) {
            traceBack.setMessage(e.getMessage());
        }
        traceBack.setTrace(sw.toString());
        ((TraceBackRepository)((Object)Beans.get(TraceBackRepository.class))).persist((Model)traceBack);
        return traceBack;
    }

    private static TraceBack _create(Throwable e, String origin, int categorySelect, long batchId) {
        return TraceBackService._create(e, origin, 0, categorySelect, batchId);
    }

    private static TraceBack _create(AxelorException e, String origin, long batchId) {
        TraceBack traceBack = TraceBackService._create(e, origin, 1, e.getCategory(), batchId);
        if (e.getRefClass() != null) {
            traceBack.setRef(e.getRefClass().getName());
            traceBack.setRefId(e.getRefId());
        }
        return traceBack;
    }

    private static void _response(ActionResponse response, Throwable e, ResponseMessageType responseMessageType) {
        String message = e.getMessage() != null ? e.getMessage() : e.toString();
        responseMessageType.setMessage(response, message);
    }

    public static void trace(Throwable e, String origin) {
        JPA.runInTransaction(() -> {
            if (e instanceof AxelorException) {
                LOG.trace(TraceBackService._create((AxelorException)e, origin, 0L).getTrace());
            } else {
                LOG.error(TraceBackService._create(e, origin, 0, 0L).getTrace());
            }
        });
    }

    public static void trace(AxelorException e, String origin, long batchId) {
        JPA.runInTransaction(() -> LOG.trace(TraceBackService._create(e, origin, batchId).getTrace()));
    }

    public static void trace(Throwable e, String origin, long batchId) {
        JPA.runInTransaction(() -> LOG.error(TraceBackService._create(e, origin, 0, batchId).getTrace()));
    }

    public static void trace(Throwable e) {
        TraceBackService.trace(e, null);
    }

    public static void trace(AxelorException e) {
        TraceBackService.trace(e, null);
    }

    public static void trace(ActionResponse response, Throwable e, String origin) {
        TraceBackService.trace(e, origin);
        TraceBackService._response(response, e, ResponseMessageType.INFORMATION);
    }

    public static void trace(ActionResponse response, Throwable e) {
        TraceBackService.trace(response, e, (String)null);
    }

    public static void trace(ActionResponse response, Throwable e, String origin, ResponseMessageType responseMessageType) {
        TraceBackService.trace(e, origin);
        TraceBackService._response(response, e, responseMessageType);
    }

    public static void trace(ActionResponse response, Throwable e, ResponseMessageType responseMessageType) {
        TraceBackService.trace(response, e, null, responseMessageType);
    }

    public String toString() {
        return "Axelor Exception";
    }
}

