/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.exception.web;

import com.axelor.common.Inflector;
import com.axelor.db.JPA;
import com.axelor.exception.db.TraceBack;
import com.axelor.i18n.I18n;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TraceBackController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void showReference(ActionRequest request, ActionResponse response) {
        TraceBack traceBack = (TraceBack)((Object)request.getContext().asType(TraceBack.class));
        if (Strings.isNullOrEmpty((String)traceBack.getRef())) {
            return;
        }
        Class modelClass = JPA.model((String)traceBack.getRef());
        Inflector inflector = Inflector.getInstance();
        String viewName = inflector.dasherize(modelClass.getSimpleName());
        LOG.debug("Showing anomaly reference ::: {}", (Object)viewName);
        ActionView.ActionViewBuilder actionViewBuilder = ActionView.define((String)I18n.get((String)"Reference"));
        actionViewBuilder.model(traceBack.getRef());
        if (traceBack.getRefId() != null) {
            actionViewBuilder.context("_showRecord", (Object)traceBack.getRefId());
        } else {
            actionViewBuilder.add("grid", String.format("%s-grid", viewName));
        }
        actionViewBuilder.add("form", String.format("%s-form", viewName));
        response.setView(actionViewBuilder.map());
    }
}

