/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.bankpayment.db.BankOrderFileFormat;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_BANK_ORDER", uniqueConstraints={@UniqueConstraint(columnNames={"bankOrderSeq", "sender_company"})}, indexes={@Index(columnList="bankOrderSeq"), @Index(columnList="payment_mode"), @Index(columnList="bank_order_file_format"), @Index(columnList="bank_order_currency"), @Index(columnList="company_currency"), @Index(columnList="batch"), @Index(columnList="sender_company"), @Index(columnList="sender_bank_details"), @Index(columnList="signatory_user"), @Index(columnList="signatory_ebics_user"), @Index(columnList="generated_meta_file"), @Index(columnList="signed_meta_file")})
@Track(fields={@TrackField(name="bankOrderDate", condition="statusSelect > 1", on={TrackEvent.UPDATE}), @TrackField(name="signatoryEbicsUser", condition="statusSelect > 1", on={TrackEvent.UPDATE}), @TrackField(name="senderCompany", condition="statusSelect > 1", on={TrackEvent.UPDATE}), @TrackField(name="senderBankDetails", condition="statusSelect > 1", on={TrackEvent.UPDATE}), @TrackField(name="bankOrderTotalAmount", condition="statusSelect > 1", on={TrackEvent.UPDATE}), @TrackField(name="bankOrderCurrency", condition="statusSelect > 1", on={TrackEvent.UPDATE}), @TrackField(name="senderReference", condition="statusSelect > 1", on={TrackEvent.UPDATE}), @TrackField(name="statusSelect", condition="statusSelect > 1", on={TrackEvent.UPDATE})}, messages={@TrackMessage(message="Awaiting signature", condition="statusSelect == 2", tag="info")})
public class BankOrder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_BANK_ORDER_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_BANK_ORDER_SEQ", sequenceName="BANKPAYMENT_BANK_ORDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Order Type", selection="bankpayment.bank.order.type.select")
    private Integer orderTypeSelect = 0;
    @Widget(title="Rejection Status", selection="bankpayment.bank.order.reject.status.select")
    private Integer rejectStatusSelect = 0;
    @Widget(title="Sequence", readonly=true)
    @NameColumn
    private String bankOrderSeq;
    @Widget(title="Partner Type", selection="bankpayment.bank.order.partner.type.select")
    @NotNull
    private Integer partnerTypeSelect = 0;
    @Widget(title="Status", readonly=true, selection="bankpayment.bank.order.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Bank order due Date")
    private LocalDate bankOrderDate;
    @Widget(title="Payment Mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="File format")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankOrderFileFormat bankOrderFileFormat;
    @Widget(title="Confirmation date")
    private LocalDateTime confirmationDateTime;
    @Widget(title="Validation date")
    private LocalDateTime validationDateTime;
    @Widget(title="File generation date")
    private LocalDateTime fileGenerationDateTime;
    @Widget(title="Sending date")
    private LocalDateTime sendingDateTime;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency bankOrderCurrency;
    @Widget(title="Company currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency companyCurrency;
    @Widget(title="Multidate")
    private Boolean isMultiDate = Boolean.FALSE;
    @Widget(title="Multicurrency")
    private Boolean isMultiCurrency = Boolean.FALSE;
    @Widget(title="Arithmetic total", readonly=true)
    private BigDecimal arithmeticTotal = BigDecimal.ZERO;
    @Widget(title="Test mode")
    private Boolean testMode = Boolean.FALSE;
    @Widget(title="Batch")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Batch batch;
    @Widget(title="Technical Origin", selection="bankpayment.bank.order.technical.origin.select")
    private Integer technicalOriginSelect = 0;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company senderCompany;
    @Widget(title="Bank Account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails senderBankDetails;
    @Widget(title="Total amount")
    private BigDecimal bankOrderTotalAmount = BigDecimal.ZERO;
    @Widget(title="Total amount in company currency", readonly=true)
    private BigDecimal companyCurrencyTotalAmount = BigDecimal.ZERO;
    @Widget(title="Reference")
    private String senderReference;
    @Widget(title="Label")
    private String senderLabel;
    @Widget(title="Number of lines")
    private Integer nbOfLines = 0;
    @Widget(title="Bank Order Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="bankOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="counter")
    private List<BankOrderLine> bankOrderLineList;
    @Widget(title="Signatory")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User signatoryUser;
    @Widget(title="Signatory")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EbicsUser signatoryEbicsUser;
    @Widget(title="Generated file")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile generatedMetaFile;
    @Widget(title="Signed file")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile signedMetaFile;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getOrderTypeSelect() {
        return this.orderTypeSelect == null ? 0 : this.orderTypeSelect;
    }

    public void setOrderTypeSelect(Integer orderTypeSelect) {
        this.orderTypeSelect = orderTypeSelect;
    }

    public Integer getRejectStatusSelect() {
        return this.rejectStatusSelect == null ? 0 : this.rejectStatusSelect;
    }

    public void setRejectStatusSelect(Integer rejectStatusSelect) {
        this.rejectStatusSelect = rejectStatusSelect;
    }

    public String getBankOrderSeq() {
        return this.bankOrderSeq;
    }

    public void setBankOrderSeq(String bankOrderSeq) {
        this.bankOrderSeq = bankOrderSeq;
    }

    public Integer getPartnerTypeSelect() {
        return this.partnerTypeSelect == null ? 0 : this.partnerTypeSelect;
    }

    public void setPartnerTypeSelect(Integer partnerTypeSelect) {
        this.partnerTypeSelect = partnerTypeSelect;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public LocalDate getBankOrderDate() {
        return this.bankOrderDate;
    }

    public void setBankOrderDate(LocalDate bankOrderDate) {
        this.bankOrderDate = bankOrderDate;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public BankOrderFileFormat getBankOrderFileFormat() {
        return this.bankOrderFileFormat;
    }

    public void setBankOrderFileFormat(BankOrderFileFormat bankOrderFileFormat) {
        this.bankOrderFileFormat = bankOrderFileFormat;
    }

    public LocalDateTime getConfirmationDateTime() {
        return this.confirmationDateTime;
    }

    public void setConfirmationDateTime(LocalDateTime confirmationDateTime) {
        this.confirmationDateTime = confirmationDateTime;
    }

    public LocalDateTime getValidationDateTime() {
        return this.validationDateTime;
    }

    public void setValidationDateTime(LocalDateTime validationDateTime) {
        this.validationDateTime = validationDateTime;
    }

    public LocalDateTime getFileGenerationDateTime() {
        return this.fileGenerationDateTime;
    }

    public void setFileGenerationDateTime(LocalDateTime fileGenerationDateTime) {
        this.fileGenerationDateTime = fileGenerationDateTime;
    }

    public LocalDateTime getSendingDateTime() {
        return this.sendingDateTime;
    }

    public void setSendingDateTime(LocalDateTime sendingDateTime) {
        this.sendingDateTime = sendingDateTime;
    }

    public Currency getBankOrderCurrency() {
        return this.bankOrderCurrency;
    }

    public void setBankOrderCurrency(Currency bankOrderCurrency) {
        this.bankOrderCurrency = bankOrderCurrency;
    }

    public Currency getCompanyCurrency() {
        return this.companyCurrency;
    }

    public void setCompanyCurrency(Currency companyCurrency) {
        this.companyCurrency = companyCurrency;
    }

    public Boolean getIsMultiDate() {
        return this.isMultiDate == null ? Boolean.FALSE : this.isMultiDate;
    }

    public void setIsMultiDate(Boolean isMultiDate) {
        this.isMultiDate = isMultiDate;
    }

    public Boolean getIsMultiCurrency() {
        return this.isMultiCurrency == null ? Boolean.FALSE : this.isMultiCurrency;
    }

    public void setIsMultiCurrency(Boolean isMultiCurrency) {
        this.isMultiCurrency = isMultiCurrency;
    }

    public BigDecimal getArithmeticTotal() {
        return this.arithmeticTotal == null ? BigDecimal.ZERO : this.arithmeticTotal;
    }

    public void setArithmeticTotal(BigDecimal arithmeticTotal) {
        this.arithmeticTotal = arithmeticTotal;
    }

    public Boolean getTestMode() {
        return this.testMode == null ? Boolean.FALSE : this.testMode;
    }

    public void setTestMode(Boolean testMode) {
        this.testMode = testMode;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public void setBatch(Batch batch) {
        this.batch = batch;
    }

    public Integer getTechnicalOriginSelect() {
        return this.technicalOriginSelect == null ? 0 : this.technicalOriginSelect;
    }

    public void setTechnicalOriginSelect(Integer technicalOriginSelect) {
        this.technicalOriginSelect = technicalOriginSelect;
    }

    public Company getSenderCompany() {
        return this.senderCompany;
    }

    public void setSenderCompany(Company senderCompany) {
        this.senderCompany = senderCompany;
    }

    public BankDetails getSenderBankDetails() {
        return this.senderBankDetails;
    }

    public void setSenderBankDetails(BankDetails senderBankDetails) {
        this.senderBankDetails = senderBankDetails;
    }

    public BigDecimal getBankOrderTotalAmount() {
        return this.bankOrderTotalAmount == null ? BigDecimal.ZERO : this.bankOrderTotalAmount;
    }

    public void setBankOrderTotalAmount(BigDecimal bankOrderTotalAmount) {
        this.bankOrderTotalAmount = bankOrderTotalAmount;
    }

    public BigDecimal getCompanyCurrencyTotalAmount() {
        return this.companyCurrencyTotalAmount == null ? BigDecimal.ZERO : this.companyCurrencyTotalAmount;
    }

    public void setCompanyCurrencyTotalAmount(BigDecimal companyCurrencyTotalAmount) {
        this.companyCurrencyTotalAmount = companyCurrencyTotalAmount;
    }

    public String getSenderReference() {
        return this.senderReference;
    }

    public void setSenderReference(String senderReference) {
        this.senderReference = senderReference;
    }

    public String getSenderLabel() {
        return this.senderLabel;
    }

    public void setSenderLabel(String senderLabel) {
        this.senderLabel = senderLabel;
    }

    public Integer getNbOfLines() {
        return this.nbOfLines == null ? 0 : this.nbOfLines;
    }

    public void setNbOfLines(Integer nbOfLines) {
        this.nbOfLines = nbOfLines;
    }

    public List<BankOrderLine> getBankOrderLineList() {
        return this.bankOrderLineList;
    }

    public void setBankOrderLineList(List<BankOrderLine> bankOrderLineList) {
        this.bankOrderLineList = bankOrderLineList;
    }

    public void addBankOrderLineListItem(BankOrderLine item) {
        if (this.getBankOrderLineList() == null) {
            this.setBankOrderLineList(new ArrayList<BankOrderLine>());
        }
        this.getBankOrderLineList().add(item);
        item.setBankOrder(this);
    }

    public void removeBankOrderLineListItem(BankOrderLine item) {
        if (this.getBankOrderLineList() == null) {
            return;
        }
        this.getBankOrderLineList().remove((Object)item);
    }

    public void clearBankOrderLineList() {
        if (this.getBankOrderLineList() != null) {
            this.getBankOrderLineList().clear();
        }
    }

    public User getSignatoryUser() {
        return this.signatoryUser;
    }

    public void setSignatoryUser(User signatoryUser) {
        this.signatoryUser = signatoryUser;
    }

    public EbicsUser getSignatoryEbicsUser() {
        return this.signatoryEbicsUser;
    }

    public void setSignatoryEbicsUser(EbicsUser signatoryEbicsUser) {
        this.signatoryEbicsUser = signatoryEbicsUser;
    }

    public MetaFile getGeneratedMetaFile() {
        return this.generatedMetaFile;
    }

    public void setGeneratedMetaFile(MetaFile generatedMetaFile) {
        this.generatedMetaFile = generatedMetaFile;
    }

    public MetaFile getSignedMetaFile() {
        return this.signedMetaFile;
    }

    public void setSignedMetaFile(MetaFile signedMetaFile) {
        this.signedMetaFile = signedMetaFile;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BankOrder)) {
            return false;
        }
        BankOrder other = (BankOrder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("orderTypeSelect", (Object)this.getOrderTypeSelect()).add("rejectStatusSelect", (Object)this.getRejectStatusSelect()).add("bankOrderSeq", (Object)this.getBankOrderSeq()).add("partnerTypeSelect", (Object)this.getPartnerTypeSelect()).add("statusSelect", (Object)this.getStatusSelect()).add("bankOrderDate", (Object)this.getBankOrderDate()).add("confirmationDateTime", (Object)this.getConfirmationDateTime()).add("validationDateTime", (Object)this.getValidationDateTime()).add("fileGenerationDateTime", (Object)this.getFileGenerationDateTime()).add("sendingDateTime", (Object)this.getSendingDateTime()).add("isMultiDate", (Object)this.getIsMultiDate()).omitNullValues().toString();
    }
}

