/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderEconomicReason;
import com.axelor.apps.bankpayment.db.BankOrderLineOrigin;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_BANK_ORDER_LINE", indexes={@Index(columnList="sequence"), @Index(columnList="bank_order"), @Index(columnList="receiver_company"), @Index(columnList="partner"), @Index(columnList="receiver_bank_details"), @Index(columnList="bank_order_currency"), @Index(columnList="sender_move"), @Index(columnList="receiver_move"), @Index(columnList="interbank_code_line"), @Index(columnList="reject_move"), @Index(columnList="bank_order_economic_reason"), @Index(columnList="receiver_country")})
public class BankOrderLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_BANK_ORDER_LINE_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_BANK_ORDER_LINE_SEQ", sequenceName="BANKPAYMENT_BANK_ORDER_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Sequence", readonly=true)
    @NameColumn
    private String sequence;
    @Widget(title="Counter")
    private Integer counter = 0;
    @Widget(title="Bank Order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankOrder bankOrder;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company receiverCompany;
    @Widget(title="Partner")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Bank Account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails receiverBankDetails;
    @Widget(title="Bank order amount")
    @NotNull
    private BigDecimal bankOrderAmount = BigDecimal.ZERO;
    @Widget(title="Company currency amount")
    private BigDecimal companyCurrencyAmount = BigDecimal.ZERO;
    @Widget(title="Bank order currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency bankOrderCurrency;
    @Widget(title="Bank order Date")
    private LocalDate bankOrderDate;
    @Widget(title="Reference")
    private String receiverReference;
    @Widget(title="Label")
    private String receiverLabel;
    @Widget(title="Move", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move senderMove;
    @Widget(title="Receiver move", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move receiverMove;
    @Widget(title="Origins")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="bankOrderLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BankOrderLineOrigin> bankOrderLineOriginList;
    @Widget(title="Rejected")
    private Boolean isRejected = Boolean.FALSE;
    @Widget(title="Rejection date")
    private LocalDate rejectDate;
    @Widget(title="Reject Reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCodeLine interbankCodeLine;
    @Widget(title="Amount Rejected")
    private BigDecimal rejectAmount = BigDecimal.ZERO;
    @Widget(title="Reject Move", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move rejectMove;
    @Widget(title="Economic reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankOrderEconomicReason bankOrderEconomicReason;
    @Widget(title="Fees imputation", selection="bankpayment.bank.order.line.fees.imputation.mode.select")
    private Integer feesImputationModeSelect = 0;
    @Widget(title="Payment Mode", selection="bankpayment.bank.order.line.payment.mode.select")
    private Integer paymentModeSelect = 0;
    @Widget(title="Receiver country")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Country receiverCountry;
    @Widget(title="Receiver address")
    private String receiverAddressStr;
    @Size(max=35)
    private String paymentReasonLine1;
    @Size(max=35)
    private String paymentReasonLine2;
    @Size(max=35)
    private String paymentReasonLine3;
    @Size(max=35)
    private String paymentReasonLine4;
    @Size(max=35)
    private String specialInstructionsLine1;
    @Size(max=35)
    private String specialInstructionsLine2;
    @Size(max=35)
    private String specialInstructionsLine3;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public Integer getCounter() {
        return this.counter == null ? 0 : this.counter;
    }

    public void setCounter(Integer counter) {
        this.counter = counter;
    }

    public BankOrder getBankOrder() {
        return this.bankOrder;
    }

    public void setBankOrder(BankOrder bankOrder) {
        this.bankOrder = bankOrder;
    }

    public Company getReceiverCompany() {
        return this.receiverCompany;
    }

    public void setReceiverCompany(Company receiverCompany) {
        this.receiverCompany = receiverCompany;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public BankDetails getReceiverBankDetails() {
        return this.receiverBankDetails;
    }

    public void setReceiverBankDetails(BankDetails receiverBankDetails) {
        this.receiverBankDetails = receiverBankDetails;
    }

    public BigDecimal getBankOrderAmount() {
        return this.bankOrderAmount == null ? BigDecimal.ZERO : this.bankOrderAmount;
    }

    public void setBankOrderAmount(BigDecimal bankOrderAmount) {
        this.bankOrderAmount = bankOrderAmount;
    }

    public BigDecimal getCompanyCurrencyAmount() {
        return this.companyCurrencyAmount == null ? BigDecimal.ZERO : this.companyCurrencyAmount;
    }

    public void setCompanyCurrencyAmount(BigDecimal companyCurrencyAmount) {
        this.companyCurrencyAmount = companyCurrencyAmount;
    }

    public Currency getBankOrderCurrency() {
        return this.bankOrderCurrency;
    }

    public void setBankOrderCurrency(Currency bankOrderCurrency) {
        this.bankOrderCurrency = bankOrderCurrency;
    }

    public LocalDate getBankOrderDate() {
        return this.bankOrderDate;
    }

    public void setBankOrderDate(LocalDate bankOrderDate) {
        this.bankOrderDate = bankOrderDate;
    }

    public String getReceiverReference() {
        return this.receiverReference;
    }

    public void setReceiverReference(String receiverReference) {
        this.receiverReference = receiverReference;
    }

    public String getReceiverLabel() {
        return this.receiverLabel;
    }

    public void setReceiverLabel(String receiverLabel) {
        this.receiverLabel = receiverLabel;
    }

    public Move getSenderMove() {
        return this.senderMove;
    }

    public void setSenderMove(Move senderMove) {
        this.senderMove = senderMove;
    }

    public Move getReceiverMove() {
        return this.receiverMove;
    }

    public void setReceiverMove(Move receiverMove) {
        this.receiverMove = receiverMove;
    }

    public List<BankOrderLineOrigin> getBankOrderLineOriginList() {
        return this.bankOrderLineOriginList;
    }

    public void setBankOrderLineOriginList(List<BankOrderLineOrigin> bankOrderLineOriginList) {
        this.bankOrderLineOriginList = bankOrderLineOriginList;
    }

    public void addBankOrderLineOriginListItem(BankOrderLineOrigin item) {
        if (this.getBankOrderLineOriginList() == null) {
            this.setBankOrderLineOriginList(new ArrayList<BankOrderLineOrigin>());
        }
        this.getBankOrderLineOriginList().add(item);
        item.setBankOrderLine(this);
    }

    public void removeBankOrderLineOriginListItem(BankOrderLineOrigin item) {
        if (this.getBankOrderLineOriginList() == null) {
            return;
        }
        this.getBankOrderLineOriginList().remove((Object)item);
    }

    public void clearBankOrderLineOriginList() {
        if (this.getBankOrderLineOriginList() != null) {
            this.getBankOrderLineOriginList().clear();
        }
    }

    public Boolean getIsRejected() {
        return this.isRejected == null ? Boolean.FALSE : this.isRejected;
    }

    public void setIsRejected(Boolean isRejected) {
        this.isRejected = isRejected;
    }

    public LocalDate getRejectDate() {
        return this.rejectDate;
    }

    public void setRejectDate(LocalDate rejectDate) {
        this.rejectDate = rejectDate;
    }

    public InterbankCodeLine getInterbankCodeLine() {
        return this.interbankCodeLine;
    }

    public void setInterbankCodeLine(InterbankCodeLine interbankCodeLine) {
        this.interbankCodeLine = interbankCodeLine;
    }

    public BigDecimal getRejectAmount() {
        return this.rejectAmount == null ? BigDecimal.ZERO : this.rejectAmount;
    }

    public void setRejectAmount(BigDecimal rejectAmount) {
        this.rejectAmount = rejectAmount;
    }

    public Move getRejectMove() {
        return this.rejectMove;
    }

    public void setRejectMove(Move rejectMove) {
        this.rejectMove = rejectMove;
    }

    public BankOrderEconomicReason getBankOrderEconomicReason() {
        return this.bankOrderEconomicReason;
    }

    public void setBankOrderEconomicReason(BankOrderEconomicReason bankOrderEconomicReason) {
        this.bankOrderEconomicReason = bankOrderEconomicReason;
    }

    public Integer getFeesImputationModeSelect() {
        return this.feesImputationModeSelect == null ? 0 : this.feesImputationModeSelect;
    }

    public void setFeesImputationModeSelect(Integer feesImputationModeSelect) {
        this.feesImputationModeSelect = feesImputationModeSelect;
    }

    public Integer getPaymentModeSelect() {
        return this.paymentModeSelect == null ? 0 : this.paymentModeSelect;
    }

    public void setPaymentModeSelect(Integer paymentModeSelect) {
        this.paymentModeSelect = paymentModeSelect;
    }

    public Country getReceiverCountry() {
        return this.receiverCountry;
    }

    public void setReceiverCountry(Country receiverCountry) {
        this.receiverCountry = receiverCountry;
    }

    public String getReceiverAddressStr() {
        return this.receiverAddressStr;
    }

    public void setReceiverAddressStr(String receiverAddressStr) {
        this.receiverAddressStr = receiverAddressStr;
    }

    public String getPaymentReasonLine1() {
        return this.paymentReasonLine1;
    }

    public void setPaymentReasonLine1(String paymentReasonLine1) {
        this.paymentReasonLine1 = paymentReasonLine1;
    }

    public String getPaymentReasonLine2() {
        return this.paymentReasonLine2;
    }

    public void setPaymentReasonLine2(String paymentReasonLine2) {
        this.paymentReasonLine2 = paymentReasonLine2;
    }

    public String getPaymentReasonLine3() {
        return this.paymentReasonLine3;
    }

    public void setPaymentReasonLine3(String paymentReasonLine3) {
        this.paymentReasonLine3 = paymentReasonLine3;
    }

    public String getPaymentReasonLine4() {
        return this.paymentReasonLine4;
    }

    public void setPaymentReasonLine4(String paymentReasonLine4) {
        this.paymentReasonLine4 = paymentReasonLine4;
    }

    public String getSpecialInstructionsLine1() {
        return this.specialInstructionsLine1;
    }

    public void setSpecialInstructionsLine1(String specialInstructionsLine1) {
        this.specialInstructionsLine1 = specialInstructionsLine1;
    }

    public String getSpecialInstructionsLine2() {
        return this.specialInstructionsLine2;
    }

    public void setSpecialInstructionsLine2(String specialInstructionsLine2) {
        this.specialInstructionsLine2 = specialInstructionsLine2;
    }

    public String getSpecialInstructionsLine3() {
        return this.specialInstructionsLine3;
    }

    public void setSpecialInstructionsLine3(String specialInstructionsLine3) {
        this.specialInstructionsLine3 = specialInstructionsLine3;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BankOrderLine)) {
            return false;
        }
        BankOrderLine other = (BankOrderLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sequence", (Object)this.getSequence()).add("counter", (Object)this.getCounter()).add("bankOrderAmount", (Object)this.getBankOrderAmount()).add("companyCurrencyAmount", (Object)this.getCompanyCurrencyAmount()).add("bankOrderDate", (Object)this.getBankOrderDate()).add("receiverReference", (Object)this.getReceiverReference()).add("receiverLabel", (Object)this.getReceiverLabel()).add("isRejected", (Object)this.getIsRejected()).add("rejectDate", (Object)this.getRejectDate()).add("rejectAmount", (Object)this.getRejectAmount()).add("feesImputationModeSelect", (Object)this.getFeesImputationModeSelect()).omitNullValues().toString();
    }
}

