/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Sequence;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BANKPAYMENT_BANK_PAYMENT_CONFIG", indexes={@Index(columnList="default_signatory_user"), @Index(columnList="internal_bank_to_bank_account"), @Index(columnList="external_bank_to_bank_account"), @Index(columnList="sepa_credit_trans_sequence"), @Index(columnList="sepa_direct_debit_sequence"), @Index(columnList="int_credit_trans_sequence"), @Index(columnList="int_direct_debit_sequence"), @Index(columnList="int_treasury_trans_sequence"), @Index(columnList="nat_treasury_trans_sequence"), @Index(columnList="other_bank_order_sequence")})
@Track(fields={@TrackField(name="company", on={TrackEvent.UPDATE}), @TrackField(name="defaultSignatoryUser", on={TrackEvent.UPDATE}), @TrackField(name="generateMoveOnBankOrderValidation", on={TrackEvent.UPDATE}), @TrackField(name="internalBankToBankAccount", on={TrackEvent.UPDATE}), @TrackField(name="externalBankToBankAccount", on={TrackEvent.UPDATE}), @TrackField(name="sepaCreditTransSequence", on={TrackEvent.UPDATE}), @TrackField(name="sepaDirectDebitSequence", on={TrackEvent.UPDATE}), @TrackField(name="intCreditTransSequence", on={TrackEvent.UPDATE}), @TrackField(name="intDirectDebitSequence", on={TrackEvent.UPDATE}), @TrackField(name="intTreasuryTransSequence", on={TrackEvent.UPDATE}), @TrackField(name="natTreasuryTransSequence", on={TrackEvent.UPDATE}), @TrackField(name="otherBankOrderSequence", on={TrackEvent.UPDATE}), @TrackField(name="icsNumber", on={TrackEvent.UPDATE})})
public class BankPaymentConfig
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_BANK_PAYMENT_CONFIG_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_BANK_PAYMENT_CONFIG_SEQ", sequenceName="BANKPAYMENT_BANK_PAYMENT_CONFIG_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Company")
    @NotNull
    @JoinColumn(unique=true)
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Default signatory")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User defaultSignatoryUser;
    @Widget(title="Generate move when validating a bank order")
    private Boolean generateMoveOnBankOrderValidation = Boolean.FALSE;
    @Widget(title="Bank to bank account for internal order (unique company)")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account internalBankToBankAccount;
    @Widget(title="Bank to bank account for external order (multiple company)")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account externalBankToBankAccount;
    @Widget(title="SEPA credit transfers")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence sepaCreditTransSequence;
    @Widget(title="SEPA direct debits")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence sepaDirectDebitSequence;
    @Widget(title="International credit transfers")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence intCreditTransSequence;
    @Widget(title="International direct debits")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence intDirectDebitSequence;
    @Widget(title="International treasury transfers")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence intTreasuryTransSequence;
    @Widget(title="National treasury transfer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence natTreasuryTransSequence;
    @Widget(title="Other bank order types")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence otherBankOrderSequence;
    @Widget(title="ICS Number")
    @Size(min=13, max=13)
    private String icsNumber;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public User getDefaultSignatoryUser() {
        return this.defaultSignatoryUser;
    }

    public void setDefaultSignatoryUser(User defaultSignatoryUser) {
        this.defaultSignatoryUser = defaultSignatoryUser;
    }

    public Boolean getGenerateMoveOnBankOrderValidation() {
        return this.generateMoveOnBankOrderValidation == null ? Boolean.FALSE : this.generateMoveOnBankOrderValidation;
    }

    public void setGenerateMoveOnBankOrderValidation(Boolean generateMoveOnBankOrderValidation) {
        this.generateMoveOnBankOrderValidation = generateMoveOnBankOrderValidation;
    }

    public Account getInternalBankToBankAccount() {
        return this.internalBankToBankAccount;
    }

    public void setInternalBankToBankAccount(Account internalBankToBankAccount) {
        this.internalBankToBankAccount = internalBankToBankAccount;
    }

    public Account getExternalBankToBankAccount() {
        return this.externalBankToBankAccount;
    }

    public void setExternalBankToBankAccount(Account externalBankToBankAccount) {
        this.externalBankToBankAccount = externalBankToBankAccount;
    }

    public Sequence getSepaCreditTransSequence() {
        return this.sepaCreditTransSequence;
    }

    public void setSepaCreditTransSequence(Sequence sepaCreditTransSequence) {
        this.sepaCreditTransSequence = sepaCreditTransSequence;
    }

    public Sequence getSepaDirectDebitSequence() {
        return this.sepaDirectDebitSequence;
    }

    public void setSepaDirectDebitSequence(Sequence sepaDirectDebitSequence) {
        this.sepaDirectDebitSequence = sepaDirectDebitSequence;
    }

    public Sequence getIntCreditTransSequence() {
        return this.intCreditTransSequence;
    }

    public void setIntCreditTransSequence(Sequence intCreditTransSequence) {
        this.intCreditTransSequence = intCreditTransSequence;
    }

    public Sequence getIntDirectDebitSequence() {
        return this.intDirectDebitSequence;
    }

    public void setIntDirectDebitSequence(Sequence intDirectDebitSequence) {
        this.intDirectDebitSequence = intDirectDebitSequence;
    }

    public Sequence getIntTreasuryTransSequence() {
        return this.intTreasuryTransSequence;
    }

    public void setIntTreasuryTransSequence(Sequence intTreasuryTransSequence) {
        this.intTreasuryTransSequence = intTreasuryTransSequence;
    }

    public Sequence getNatTreasuryTransSequence() {
        return this.natTreasuryTransSequence;
    }

    public void setNatTreasuryTransSequence(Sequence natTreasuryTransSequence) {
        this.natTreasuryTransSequence = natTreasuryTransSequence;
    }

    public Sequence getOtherBankOrderSequence() {
        return this.otherBankOrderSequence;
    }

    public void setOtherBankOrderSequence(Sequence otherBankOrderSequence) {
        this.otherBankOrderSequence = otherBankOrderSequence;
    }

    public String getIcsNumber() {
        return this.icsNumber;
    }

    public void setIcsNumber(String icsNumber) {
        this.icsNumber = icsNumber;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BankPaymentConfig)) {
            return false;
        }
        BankPaymentConfig other = (BankPaymentConfig)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals((Object)this.getCompany(), (Object)other.getCompany());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{-1318916116, this.getCompany()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("generateMoveOnBankOrderValidation", (Object)this.getGenerateMoveOnBankOrderValidation()).add("icsNumber", (Object)this.getIcsNumber()).omitNullValues().toString();
    }
}

