/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.bankpayment.db.EbicsCertificate;
import com.axelor.apps.base.db.Bank;
import com.axelor.apps.base.db.Language;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_EBICS_BANK", indexes={@Index(columnList="fullName"), @Index(columnList="name"), @Index(columnList="bank"), @Index(columnList="language")})
@Track(fields={@TrackField(name="fullName", on={TrackEvent.UPDATE}), @TrackField(name="hostId", on={TrackEvent.UPDATE}), @TrackField(name="name", on={TrackEvent.UPDATE}), @TrackField(name="bank", on={TrackEvent.UPDATE}), @TrackField(name="fax", on={TrackEvent.UPDATE}), @TrackField(name="emailAddress", on={TrackEvent.UPDATE}), @TrackField(name="url", on={TrackEvent.UPDATE}), @TrackField(name="language", on={TrackEvent.UPDATE}), @TrackField(name="certValidityPeriodSelect", on={TrackEvent.UPDATE}), @TrackField(name="ebicsCertificateList", on={TrackEvent.UPDATE}), @TrackField(name="protocolSelect", on={TrackEvent.UPDATE}), @TrackField(name="useX509ExtensionBasicConstraints", on={TrackEvent.UPDATE}), @TrackField(name="useX509ExtensionSubjectKeyIdentifier", on={TrackEvent.UPDATE}), @TrackField(name="useX509ExtensionAuthorityKeyIdentifier", on={TrackEvent.UPDATE}), @TrackField(name="useX509ExtensionExtendedKeyUsage", on={TrackEvent.UPDATE})})
public class EbicsBank
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_EBICS_BANK_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_EBICS_BANK_SEQ", sequenceName="BANKPAYMENT_EBICS_BANK_SEQ", allocationSize=1)
    private Long id;
    @NameColumn
    private String fullName;
    @Widget(title="Host ID")
    private String hostId;
    @Widget(title="Name")
    private String name;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Bank bank;
    @Widget(title="Fax")
    private String fax;
    @Widget(title="Email")
    private String emailAddress;
    @Widget(title="URL")
    private String url;
    @Widget(title="Language")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Language language;
    @Widget(title="Certificate validity period(Years)", selection="bankpayment.ebics.bank.certificate.validity.period.select")
    private Integer certValidityPeriodSelect = 5;
    @Widget(title="Certificates")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="ebicsBank", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EbicsCertificate> ebicsCertificateList;
    @Widget(title="Protocol", selection="bankpayment.ebics.bank.protocol.select")
    private String protocolSelect = "ssl";
    @Widget(title="Use X509 extension BasicConstraints")
    private Boolean useX509ExtensionBasicConstraints = Boolean.FALSE;
    @Widget(title="Use X509 extension SubjectKeyIdentifier")
    private Boolean useX509ExtensionSubjectKeyIdentifier = Boolean.TRUE;
    @Widget(title="Use X509 extension AuthorityKeyIdentifier")
    private Boolean useX509ExtensionAuthorityKeyIdentifier = Boolean.TRUE;
    @Widget(title="Use X509 extension ExtendedKeyUsage")
    private Boolean useX509ExtensionExtendedKeyUsage = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public EbicsBank() {
    }

    public EbicsBank(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Integer getCertValidityPeriodSelect() {
        return this.certValidityPeriodSelect == null ? 0 : this.certValidityPeriodSelect;
    }

    public void setCertValidityPeriodSelect(Integer certValidityPeriodSelect) {
        this.certValidityPeriodSelect = certValidityPeriodSelect;
    }

    public List<EbicsCertificate> getEbicsCertificateList() {
        return this.ebicsCertificateList;
    }

    public void setEbicsCertificateList(List<EbicsCertificate> ebicsCertificateList) {
        this.ebicsCertificateList = ebicsCertificateList;
    }

    public void addEbicsCertificateListItem(EbicsCertificate item) {
        if (this.getEbicsCertificateList() == null) {
            this.setEbicsCertificateList(new ArrayList<EbicsCertificate>());
        }
        this.getEbicsCertificateList().add(item);
        item.setEbicsBank(this);
    }

    public void removeEbicsCertificateListItem(EbicsCertificate item) {
        if (this.getEbicsCertificateList() == null) {
            return;
        }
        this.getEbicsCertificateList().remove((Object)item);
    }

    public void clearEbicsCertificateList() {
        if (this.getEbicsCertificateList() != null) {
            this.getEbicsCertificateList().clear();
        }
    }

    public String getProtocolSelect() {
        return this.protocolSelect;
    }

    public void setProtocolSelect(String protocolSelect) {
        this.protocolSelect = protocolSelect;
    }

    public Boolean getUseX509ExtensionBasicConstraints() {
        return this.useX509ExtensionBasicConstraints == null ? Boolean.FALSE : this.useX509ExtensionBasicConstraints;
    }

    public void setUseX509ExtensionBasicConstraints(Boolean useX509ExtensionBasicConstraints) {
        this.useX509ExtensionBasicConstraints = useX509ExtensionBasicConstraints;
    }

    public Boolean getUseX509ExtensionSubjectKeyIdentifier() {
        return this.useX509ExtensionSubjectKeyIdentifier == null ? Boolean.FALSE : this.useX509ExtensionSubjectKeyIdentifier;
    }

    public void setUseX509ExtensionSubjectKeyIdentifier(Boolean useX509ExtensionSubjectKeyIdentifier) {
        this.useX509ExtensionSubjectKeyIdentifier = useX509ExtensionSubjectKeyIdentifier;
    }

    public Boolean getUseX509ExtensionAuthorityKeyIdentifier() {
        return this.useX509ExtensionAuthorityKeyIdentifier == null ? Boolean.FALSE : this.useX509ExtensionAuthorityKeyIdentifier;
    }

    public void setUseX509ExtensionAuthorityKeyIdentifier(Boolean useX509ExtensionAuthorityKeyIdentifier) {
        this.useX509ExtensionAuthorityKeyIdentifier = useX509ExtensionAuthorityKeyIdentifier;
    }

    public Boolean getUseX509ExtensionExtendedKeyUsage() {
        return this.useX509ExtensionExtendedKeyUsage == null ? Boolean.FALSE : this.useX509ExtensionExtendedKeyUsage;
    }

    public void setUseX509ExtensionExtendedKeyUsage(Boolean useX509ExtensionExtendedKeyUsage) {
        this.useX509ExtensionExtendedKeyUsage = useX509ExtensionExtendedKeyUsage;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EbicsBank)) {
            return false;
        }
        EbicsBank other = (EbicsBank)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("fullName", (Object)this.getFullName()).add("hostId", (Object)this.getHostId()).add("name", (Object)this.getName()).add("fax", (Object)this.getFax()).add("emailAddress", (Object)this.getEmailAddress()).add("url", (Object)this.getUrl()).add("certValidityPeriodSelect", (Object)this.getCertValidityPeriodSelect()).add("protocolSelect", (Object)this.getProtocolSelect()).add("useX509ExtensionBasicConstraints", (Object)this.getUseX509ExtensionBasicConstraints()).add("useX509ExtensionSubjectKeyIdentifier", (Object)this.getUseX509ExtensionSubjectKeyIdentifier()).add("useX509ExtensionAuthorityKeyIdentifier", (Object)this.getUseX509ExtensionAuthorityKeyIdentifier()).omitNullValues().toString();
    }
}

