/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.bankpayment.db.BankStatementFileFormat;
import com.axelor.apps.bankpayment.db.EbicsBank;
import com.axelor.apps.bankpayment.db.EbicsPartnerService;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_EBICS_PARTNER", indexes={@Index(columnList="ebics_bank"), @Index(columnList="partnerId"), @Index(columnList="default_signatory_ebics_user"), @Index(columnList="transport_ebics_user"), @Index(columnList="psrbank_statement_file_format")})
public class EbicsPartner
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_EBICS_PARTNER_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_EBICS_PARTNER_SEQ", sequenceName="BANKPAYMENT_EBICS_PARTNER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Mode", selection="bankpayment.ebics.partner.ebics.type.select")
    private Integer ebicsTypeSelect = 0;
    @Widget(title="Ebics bank")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EbicsBank ebicsBank;
    @Widget(title="Partner id")
    @NameColumn
    @NotNull
    @Size(max=35)
    private String partnerId;
    @Widget(title="Default signatory")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EbicsUser defaultSignatoryEbicsUser;
    @Widget(title="Date of last execution")
    private LocalDateTime bankStatementLastExeDateT;
    @Widget(title="Get mode", selection="bankpayment.ebics.bank.bank.statement.period.mode.select")
    private Integer bankStatementGetModeSelect = 1;
    @Widget(title="Start date")
    private LocalDate bankStatementStartDate;
    @Widget(title="End date")
    private LocalDate bankStatementEndDate;
    @Widget(title="Ebics user for transport")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EbicsUser transportEbicsUser;
    @Widget(title="Bank accounts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<BankDetails> bankDetailsSet;
    @Widget(title="Payment Status Report file format")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankStatementFileFormat pSRBankStatementFileFormat;
    @Widget(title="Enable PSR")
    private Boolean usePSR = Boolean.FALSE;
    @Widget(title="Test mode")
    private Boolean testMode = Boolean.FALSE;
    @Widget(title="Filter receiver bank details")
    private Boolean filterReceiverBD = Boolean.FALSE;
    @Widget(title="Order type to filter", selection="bankpayment.bank.order.type.select")
    private Integer orderTypeSelect = 0;
    @Widget(title="Authorized Bank Accounts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<BankDetails> receiverBankDetailsSet;
    @Widget(title="Bank order services")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="bankOrderEbicsPartner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EbicsPartnerService> boEbicsPartnerServiceList;
    @Widget(title="Bank statement services")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="bankStatementEbicsPartner", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EbicsPartnerService> bsEbicsPartnerServiceList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getEbicsTypeSelect() {
        return this.ebicsTypeSelect == null ? 0 : this.ebicsTypeSelect;
    }

    public void setEbicsTypeSelect(Integer ebicsTypeSelect) {
        this.ebicsTypeSelect = ebicsTypeSelect;
    }

    public EbicsBank getEbicsBank() {
        return this.ebicsBank;
    }

    public void setEbicsBank(EbicsBank ebicsBank) {
        this.ebicsBank = ebicsBank;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public EbicsUser getDefaultSignatoryEbicsUser() {
        return this.defaultSignatoryEbicsUser;
    }

    public void setDefaultSignatoryEbicsUser(EbicsUser defaultSignatoryEbicsUser) {
        this.defaultSignatoryEbicsUser = defaultSignatoryEbicsUser;
    }

    public LocalDateTime getBankStatementLastExeDateT() {
        return this.bankStatementLastExeDateT;
    }

    public void setBankStatementLastExeDateT(LocalDateTime bankStatementLastExeDateT) {
        this.bankStatementLastExeDateT = bankStatementLastExeDateT;
    }

    public Integer getBankStatementGetModeSelect() {
        return this.bankStatementGetModeSelect == null ? 0 : this.bankStatementGetModeSelect;
    }

    public void setBankStatementGetModeSelect(Integer bankStatementGetModeSelect) {
        this.bankStatementGetModeSelect = bankStatementGetModeSelect;
    }

    public LocalDate getBankStatementStartDate() {
        return this.bankStatementStartDate;
    }

    public void setBankStatementStartDate(LocalDate bankStatementStartDate) {
        this.bankStatementStartDate = bankStatementStartDate;
    }

    public LocalDate getBankStatementEndDate() {
        return this.bankStatementEndDate;
    }

    public void setBankStatementEndDate(LocalDate bankStatementEndDate) {
        this.bankStatementEndDate = bankStatementEndDate;
    }

    public EbicsUser getTransportEbicsUser() {
        return this.transportEbicsUser;
    }

    public void setTransportEbicsUser(EbicsUser transportEbicsUser) {
        this.transportEbicsUser = transportEbicsUser;
    }

    public Set<BankDetails> getBankDetailsSet() {
        return this.bankDetailsSet;
    }

    public void setBankDetailsSet(Set<BankDetails> bankDetailsSet) {
        this.bankDetailsSet = bankDetailsSet;
    }

    public void addBankDetailsSetItem(BankDetails item) {
        if (this.getBankDetailsSet() == null) {
            this.setBankDetailsSet(new HashSet<BankDetails>());
        }
        this.getBankDetailsSet().add(item);
    }

    public void removeBankDetailsSetItem(BankDetails item) {
        if (this.getBankDetailsSet() == null) {
            return;
        }
        this.getBankDetailsSet().remove((Object)item);
    }

    public void clearBankDetailsSet() {
        if (this.getBankDetailsSet() != null) {
            this.getBankDetailsSet().clear();
        }
    }

    public BankStatementFileFormat getpSRBankStatementFileFormat() {
        return this.pSRBankStatementFileFormat;
    }

    public void setpSRBankStatementFileFormat(BankStatementFileFormat pSRBankStatementFileFormat) {
        this.pSRBankStatementFileFormat = pSRBankStatementFileFormat;
    }

    public Boolean getUsePSR() {
        return this.usePSR == null ? Boolean.FALSE : this.usePSR;
    }

    public void setUsePSR(Boolean usePSR) {
        this.usePSR = usePSR;
    }

    public Boolean getTestMode() {
        return this.testMode == null ? Boolean.FALSE : this.testMode;
    }

    public void setTestMode(Boolean testMode) {
        this.testMode = testMode;
    }

    public Boolean getFilterReceiverBD() {
        return this.filterReceiverBD == null ? Boolean.FALSE : this.filterReceiverBD;
    }

    public void setFilterReceiverBD(Boolean filterReceiverBD) {
        this.filterReceiverBD = filterReceiverBD;
    }

    public Integer getOrderTypeSelect() {
        return this.orderTypeSelect == null ? 0 : this.orderTypeSelect;
    }

    public void setOrderTypeSelect(Integer orderTypeSelect) {
        this.orderTypeSelect = orderTypeSelect;
    }

    public Set<BankDetails> getReceiverBankDetailsSet() {
        return this.receiverBankDetailsSet;
    }

    public void setReceiverBankDetailsSet(Set<BankDetails> receiverBankDetailsSet) {
        this.receiverBankDetailsSet = receiverBankDetailsSet;
    }

    public void addReceiverBankDetailsSetItem(BankDetails item) {
        if (this.getReceiverBankDetailsSet() == null) {
            this.setReceiverBankDetailsSet(new HashSet<BankDetails>());
        }
        this.getReceiverBankDetailsSet().add(item);
    }

    public void removeReceiverBankDetailsSetItem(BankDetails item) {
        if (this.getReceiverBankDetailsSet() == null) {
            return;
        }
        this.getReceiverBankDetailsSet().remove((Object)item);
    }

    public void clearReceiverBankDetailsSet() {
        if (this.getReceiverBankDetailsSet() != null) {
            this.getReceiverBankDetailsSet().clear();
        }
    }

    public List<EbicsPartnerService> getBoEbicsPartnerServiceList() {
        return this.boEbicsPartnerServiceList;
    }

    public void setBoEbicsPartnerServiceList(List<EbicsPartnerService> boEbicsPartnerServiceList) {
        this.boEbicsPartnerServiceList = boEbicsPartnerServiceList;
    }

    public void addBoEbicsPartnerServiceListItem(EbicsPartnerService item) {
        if (this.getBoEbicsPartnerServiceList() == null) {
            this.setBoEbicsPartnerServiceList(new ArrayList<EbicsPartnerService>());
        }
        this.getBoEbicsPartnerServiceList().add(item);
        item.setBankOrderEbicsPartner(this);
    }

    public void removeBoEbicsPartnerServiceListItem(EbicsPartnerService item) {
        if (this.getBoEbicsPartnerServiceList() == null) {
            return;
        }
        this.getBoEbicsPartnerServiceList().remove((Object)item);
    }

    public void clearBoEbicsPartnerServiceList() {
        if (this.getBoEbicsPartnerServiceList() != null) {
            this.getBoEbicsPartnerServiceList().clear();
        }
    }

    public List<EbicsPartnerService> getBsEbicsPartnerServiceList() {
        return this.bsEbicsPartnerServiceList;
    }

    public void setBsEbicsPartnerServiceList(List<EbicsPartnerService> bsEbicsPartnerServiceList) {
        this.bsEbicsPartnerServiceList = bsEbicsPartnerServiceList;
    }

    public void addBsEbicsPartnerServiceListItem(EbicsPartnerService item) {
        if (this.getBsEbicsPartnerServiceList() == null) {
            this.setBsEbicsPartnerServiceList(new ArrayList<EbicsPartnerService>());
        }
        this.getBsEbicsPartnerServiceList().add(item);
        item.setBankStatementEbicsPartner(this);
    }

    public void removeBsEbicsPartnerServiceListItem(EbicsPartnerService item) {
        if (this.getBsEbicsPartnerServiceList() == null) {
            return;
        }
        this.getBsEbicsPartnerServiceList().remove((Object)item);
    }

    public void clearBsEbicsPartnerServiceList() {
        if (this.getBsEbicsPartnerServiceList() != null) {
            this.getBsEbicsPartnerServiceList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EbicsPartner)) {
            return false;
        }
        EbicsPartner other = (EbicsPartner)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("ebicsTypeSelect", (Object)this.getEbicsTypeSelect()).add("partnerId", (Object)this.getPartnerId()).add("bankStatementLastExeDateT", (Object)this.getBankStatementLastExeDateT()).add("bankStatementGetModeSelect", (Object)this.getBankStatementGetModeSelect()).add("bankStatementStartDate", (Object)this.getBankStatementStartDate()).add("bankStatementEndDate", (Object)this.getBankStatementEndDate()).add("usePSR", (Object)this.getUsePSR()).add("testMode", (Object)this.getTestMode()).add("filterReceiverBD", (Object)this.getFilterReceiverBD()).add("orderTypeSelect", (Object)this.getOrderTypeSelect()).omitNullValues().toString();
    }
}

