/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_EBICS_REQUEST_LOG", indexes={@Index(columnList="ebics_user"), @Index(columnList="response_file")})
public class EbicsRequestLog
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_EBICS_REQUEST_LOG_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_EBICS_REQUEST_LOG_SEQ", sequenceName="BANKPAYMENT_EBICS_REQUEST_LOG_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="User")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EbicsUser ebicsUser;
    @Widget(title="Request type")
    private String requestType;
    @Widget(title="Request time")
    private LocalDateTime requestTime;
    @Widget(title="Response code")
    private String responseCode;
    @Widget(title="File")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile responseFile;
    @Widget(title="Request trace")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String requestTraceText;
    @Widget(title="Response trace")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String responseTraceText;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EbicsUser getEbicsUser() {
        return this.ebicsUser;
    }

    public void setEbicsUser(EbicsUser ebicsUser) {
        this.ebicsUser = ebicsUser;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public LocalDateTime getRequestTime() {
        return this.requestTime;
    }

    public void setRequestTime(LocalDateTime requestTime) {
        this.requestTime = requestTime;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public MetaFile getResponseFile() {
        return this.responseFile;
    }

    public void setResponseFile(MetaFile responseFile) {
        this.responseFile = responseFile;
    }

    public String getRequestTraceText() {
        return this.requestTraceText;
    }

    public void setRequestTraceText(String requestTraceText) {
        this.requestTraceText = requestTraceText;
    }

    public String getResponseTraceText() {
        return this.responseTraceText;
    }

    public void setResponseTraceText(String responseTraceText) {
        this.responseTraceText = responseTraceText;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EbicsRequestLog)) {
            return false;
        }
        EbicsRequestLog other = (EbicsRequestLog)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("requestType", (Object)this.getRequestType()).add("requestTime", (Object)this.getRequestTime()).add("responseCode", (Object)this.getResponseCode()).omitNullValues().toString();
    }
}

