/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.certificate;

import com.axelor.apps.bankpayment.db.EbicsBank;
import com.axelor.apps.bankpayment.db.EbicsCertificate;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.certificate.KeyStoreManager;
import com.axelor.apps.bankpayment.ebics.certificate.KeyUtil;
import com.axelor.apps.bankpayment.ebics.certificate.X509Generator;
import com.axelor.apps.bankpayment.ebics.service.EbicsCertificateService;
import com.axelor.inject.Beans;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import org.apache.xml.security.Init;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertificateManager {
    private X509Generator generator;
    private EbicsUser user;
    private X509Certificate a005Certificate;
    private X509Certificate e002Certificate;
    private X509Certificate x002Certificate;
    private PrivateKey a005PrivateKey;
    private PrivateKey x002PrivateKey;
    private PrivateKey e002PrivateKey;

    public CertificateManager(EbicsUser user) {
        this.user = user;
        this.generator = new X509Generator();
    }

    public void create() throws GeneralSecurityException, IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, this.user.getEbicsPartner().getEbicsBank().getCertValidityPeriodSelect());
        Init.init();
        Security.addProvider((Provider)new BouncyCastleProvider());
        EbicsPartner ebicsPartner = this.user.getEbicsPartner();
        if (this.user.getUserTypeSelect() == 0 && ebicsPartner.getEbicsTypeSelect() == 1 || ebicsPartner.getEbicsTypeSelect() == 0) {
            this.createA005Certificate(new Date(calendar.getTimeInMillis()));
        }
        this.createX002Certificate(new Date(calendar.getTimeInMillis()));
        this.createE002Certificate(new Date(calendar.getTimeInMillis()));
        this.setUserCertificates();
    }

    private void setUserCertificates() throws IOException, CertificateEncodingException {
        EbicsPartner ebicsPartner = this.user.getEbicsPartner();
        if (this.user.getUserTypeSelect() == 0 && ebicsPartner.getEbicsTypeSelect() == 1 || ebicsPartner.getEbicsTypeSelect() == 0) {
            this.user.setA005Certificate(this.updateCertificate(this.a005Certificate, this.user.getA005Certificate(), this.a005PrivateKey.getEncoded(), "signature"));
        }
        this.user.setX002Certificate(this.updateCertificate(this.x002Certificate, this.user.getX002Certificate(), this.x002PrivateKey.getEncoded(), "authentication"));
        this.user.setE002Certificate(this.updateCertificate(this.e002Certificate, this.user.getE002Certificate(), this.e002PrivateKey.getEncoded(), "encryption"));
    }

    private EbicsCertificate updateCertificate(X509Certificate certificate, EbicsCertificate cert, byte[] privateKey, String type) throws CertificateEncodingException, IOException {
        if (cert == null) {
            cert = new EbicsCertificate();
            cert.setTypeSelect(type);
        }
        EbicsCertificateService certificateService = (EbicsCertificateService)Beans.get(EbicsCertificateService.class);
        cert = certificateService.updateCertificate(certificate, cert, true);
        cert.setPrivateKey(privateKey);
        return cert;
    }

    public void createA005Certificate(Date end) throws GeneralSecurityException, IOException {
        KeyPair keypair = KeyUtil.makeKeyPair(2048);
        EbicsBank ebicsBank = this.user.getEbicsPartner().getEbicsBank();
        this.a005Certificate = this.generator.generateA005Certificate(keypair, this.user.getDn(), new Date(), end, ebicsBank.getUseX509ExtensionBasicConstraints(), ebicsBank.getUseX509ExtensionSubjectKeyIdentifier(), ebicsBank.getUseX509ExtensionAuthorityKeyIdentifier(), ebicsBank.getUseX509ExtensionExtendedKeyUsage());
        this.a005PrivateKey = keypair.getPrivate();
    }

    public void createX002Certificate(Date end) throws GeneralSecurityException, IOException {
        KeyPair keypair = KeyUtil.makeKeyPair(2048);
        EbicsBank ebicsBank = this.user.getEbicsPartner().getEbicsBank();
        this.x002Certificate = this.generator.generateX002Certificate(keypair, this.user.getDn(), new Date(), end, ebicsBank.getUseX509ExtensionBasicConstraints(), ebicsBank.getUseX509ExtensionSubjectKeyIdentifier(), ebicsBank.getUseX509ExtensionAuthorityKeyIdentifier(), ebicsBank.getUseX509ExtensionExtendedKeyUsage());
        this.x002PrivateKey = keypair.getPrivate();
    }

    public void createE002Certificate(Date end) throws GeneralSecurityException, IOException {
        KeyPair keypair = KeyUtil.makeKeyPair(2048);
        EbicsBank ebicsBank = this.user.getEbicsPartner().getEbicsBank();
        this.e002Certificate = this.generator.generateE002Certificate(keypair, this.user.getDn(), new Date(), end, ebicsBank.getUseX509ExtensionBasicConstraints(), ebicsBank.getUseX509ExtensionSubjectKeyIdentifier(), ebicsBank.getUseX509ExtensionAuthorityKeyIdentifier(), ebicsBank.getUseX509ExtensionExtendedKeyUsage());
        this.e002PrivateKey = keypair.getPrivate();
    }

    public void save(String path) throws GeneralSecurityException, IOException {
        char[] pwd = null;
        if (this.user.getPassword() != null) {
            pwd = this.user.getPassword().toCharArray();
        }
        this.writePKCS12Certificate(path + "/" + this.user.getUserId(), pwd);
    }

    public void load(String path) throws GeneralSecurityException, IOException {
        KeyStoreManager loader = new KeyStoreManager();
        if (this.user.getPassword() != null) {
            loader.load(path, this.user.getPassword().toCharArray());
        } else {
            loader.load(path, null);
        }
        this.a005Certificate = loader.getCertificate(this.user.getUserId() + "-A005");
        this.x002Certificate = loader.getCertificate(this.user.getUserId() + "-X002");
        this.e002Certificate = loader.getCertificate(this.user.getUserId() + "-E002");
        this.a005PrivateKey = loader.getPrivateKey(this.user.getUserId() + "-A005");
        this.x002PrivateKey = loader.getPrivateKey(this.user.getUserId() + "-X002");
        this.e002PrivateKey = loader.getPrivateKey(this.user.getUserId() + "-E002");
        this.setUserCertificates();
    }

    public void writePKCS12Certificate(String filename, char[] password) throws GeneralSecurityException, IOException {
        if (filename == null || "".equals(filename)) {
            throw new IOException("The file name cannot be empty");
        }
        if (!filename.toLowerCase().endsWith(".p12")) {
            filename = filename + ".p12";
        }
        FileOutputStream fos = new FileOutputStream(filename);
        this.writePKCS12Certificate(password, fos);
        fos.close();
    }

    public void writePKCS12Certificate(char[] password, OutputStream fos) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
        keystore.load(null, null);
        keystore.setKeyEntry(this.user.getUserId() + "-A005", this.a005PrivateKey, password, new X509Certificate[]{this.a005Certificate});
        keystore.setKeyEntry(this.user.getUserId() + "-X002", this.x002PrivateKey, password, new X509Certificate[]{this.x002Certificate});
        keystore.setKeyEntry(this.user.getUserId() + "-E002", this.e002PrivateKey, password, new X509Certificate[]{this.e002Certificate});
        keystore.store(fos, password);
    }
}

