/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.io;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;

public class FileCache {
    private Map<String, File> cache;
    private boolean isTraceEnabled;

    public FileCache(boolean isTraceEnabled) {
        this.isTraceEnabled = isTraceEnabled;
        this.cache = new Hashtable<String, File>();
    }

    public boolean add(File file) {
        if (this.cache.containsKey(file.getName())) {
            return false;
        }
        this.cache.put(file.getName(), file);
        return true;
    }

    public boolean remove(String filename) {
        if (!this.cache.containsKey(filename)) {
            return false;
        }
        this.cache.remove(filename);
        return true;
    }

    public void clear() {
        if (this.isTraceEnabled) {
            for (File file : this.cache.values()) {
                file.delete();
            }
        }
        this.cache.clear();
    }

    public void setTraceEnabled(boolean enabled) {
        this.isTraceEnabled = enabled;
    }
}

