/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.io;

import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.interfaces.ContentFactory;
import com.axelor.apps.bankpayment.ebics.io.ByteArrayContentFactory;
import com.axelor.exception.AxelorException;
import javax.crypto.spec.SecretKeySpec;

public class Splitter {
    private byte[] input;
    private byte[] content;
    private int segmentSize;
    private int numSegments;

    public Splitter(byte[] input) {
        this.input = input;
    }

    public final void readInput(boolean isCompressionEnabled, SecretKeySpec keySpec) throws AxelorException {
        try {
            if (isCompressionEnabled) {
                this.input = EbicsUtils.zip(this.input);
            }
            this.content = EbicsUtils.encrypt(this.input, keySpec);
            this.segmentation();
        }
        catch (Exception e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }

    private void segmentation() {
        this.numSegments = this.content.length / 0x100000;
        if (this.content.length % 0x100000 != 0) {
            ++this.numSegments;
        }
        this.segmentSize = this.content.length / this.numSegments;
    }

    public ContentFactory getContent(int segmentNumber) {
        int offset = this.segmentSize * (segmentNumber - 1);
        byte[] segment = this.content.length < this.segmentSize + offset ? new byte[this.content.length - offset] : new byte[this.segmentSize];
        System.arraycopy(this.content, offset, segment, 0, segment.length);
        return new ByteArrayContentFactory(segment);
    }

    public byte[] getContent() {
        return this.content;
    }

    public int getSegmentNumber() {
        return this.numSegments;
    }
}

