/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.script;

import com.axelor.apps.bankpayment.db.EbicsBank;
import com.axelor.apps.bankpayment.db.EbicsCertificate;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.service.EbicsCertificateService;
import com.axelor.apps.base.db.Bank;
import com.axelor.apps.base.service.BankService;
import com.google.inject.Inject;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;

public class EbicsUserImport {
    @Inject
    private EbicsCertificateService certificateService;
    @Inject
    private BankService bankService;

    public Object importEbicsUser(Object bean, Map<String, Object> context) {
        EbicsBank ebicsBank;
        assert (bean instanceof EbicsUser);
        EbicsUser user = (EbicsUser)((Object)bean);
        this.updateCertificate(user.getA005Certificate());
        this.updateCertificate(user.getE002Certificate());
        this.updateCertificate(user.getX002Certificate());
        EbicsPartner partner = user.getEbicsPartner();
        if (partner != null && (ebicsBank = partner.getEbicsBank()).getVersion() == 0) {
            for (EbicsCertificate cert : ebicsBank.getEbicsCertificateList()) {
                this.updateCertificate(cert);
            }
            Bank bank = ebicsBank.getBank();
            if (bank.getVersion() == 0) {
                this.bankService.computeFullName(bank);
                this.bankService.splitBic(bank);
            }
        }
        return user;
    }

    private void updateCertificate(EbicsCertificate cert) {
        if (cert == null) {
            return;
        }
        String pem = cert.getPemString();
        if (pem == null) {
            return;
        }
        try {
            X509Certificate certificate = this.certificateService.convertToCertificate(pem);
            this.certificateService.updateCertificate(certificate, cert, false);
        }
        catch (IOException | CertificateException e) {
            e.printStackTrace();
        }
    }
}

