/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.service;

import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.EbicsRequestLog;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.db.repo.EbicsRequestLogRepository;
import com.axelor.apps.bankpayment.db.repo.EbicsUserRepository;
import com.axelor.apps.bankpayment.ebics.client.EbicsRootElement;
import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.service.EbicsService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.time.LocalDateTime;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.jdom.JDOMException;

public class EbicsUserService {
    @Inject
    private EbicsService ebicsService;
    @Inject
    private EbicsRequestLogRepository requestLogRepo;
    @Inject
    private EbicsUserRepository ebicsUserRepo;

    public byte[] sign(EbicsUser ebicsUser, byte[] digest) throws IOException, GeneralSecurityException {
        Signature signature = Signature.getInstance("SHA256WithRSA", "BC");
        signature.initSign(this.ebicsService.getPrivateKey(ebicsUser.getA005Certificate().getPrivateKey()));
        signature.update(EbicsUserService.removeOSSpecificChars(digest));
        return signature.sign();
    }

    public byte[] authenticate(EbicsUser ebicsUser, byte[] digest) throws GeneralSecurityException {
        Signature signature = Signature.getInstance("SHA256WithRSA", "BC");
        signature.initSign(this.ebicsService.getPrivateKey(ebicsUser.getX002Certificate().getPrivateKey()));
        signature.update(digest);
        return signature.sign();
    }

    public static byte[] removeOSSpecificChars(byte[] content) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        block3: for (byte b : content) {
            switch (b) {
                case 10: 
                case 13: 
                case 26: {
                    continue block3;
                }
                default: {
                    output.write(b);
                }
            }
        }
        return output.toByteArray();
    }

    public byte[] decrypt(EbicsUser user, byte[] encryptedData, byte[] transactionKey) throws AxelorException, GeneralSecurityException, IOException {
        Cipher cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding", "BC");
        cipher.init(2, this.ebicsService.getPrivateKey(user.getE002Certificate().getPrivateKey()));
        int blockSize = cipher.getBlockSize();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int j = 0;
        while (j * blockSize < transactionKey.length) {
            outputStream.write(cipher.doFinal(transactionKey, j * blockSize, blockSize));
            ++j;
        }
        return this.decryptData(encryptedData, outputStream.toByteArray());
    }

    private byte[] decryptData(byte[] input, byte[] key) throws AxelorException {
        return EbicsUtils.decrypt(input, new SecretKeySpec(key, "EAS"));
    }

    @Transactional
    public void logRequest(long ebicsUserId, String requestType, String responseCode, EbicsRootElement[] rootElements) {
        EbicsRequestLog requestLog = new EbicsRequestLog();
        requestLog.setEbicsUser((EbicsUser)((Object)this.ebicsUserRepo.find(ebicsUserId)));
        LocalDateTime time = LocalDateTime.now();
        requestLog.setRequestTime(time);
        requestLog.setRequestType(requestType);
        requestLog.setResponseCode(responseCode);
        try {
            this.trace(requestLog, rootElements);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.requestLogRepo.save((Model)((Object)requestLog));
    }

    @Transactional
    public String getNextOrderId(EbicsUser user) throws AxelorException {
        String orderId = user.getNextOrderId();
        if (orderId == null) {
            EbicsPartner partner = user.getEbicsPartner();
            EbicsUser otherUser = (EbicsUser)((Object)this.ebicsUserRepo.all().filter("self.ebicsPartner = ?1 and self.id != ?2 and self.nextOrderId != null", new Object[]{partner, user.getId()}).order("-nextOrderId").fetchOne());
            char firstLetter = 'A';
            if (otherUser != null) {
                String otherOrderId = otherUser.getNextOrderId();
                firstLetter = otherOrderId.charAt(0);
                firstLetter = (char)(firstLetter + '\u0001');
            }
            orderId = String.valueOf(firstLetter) + "000";
            user.setNextOrderId(orderId);
            this.ebicsUserRepo.save((Model)((Object)user));
        } else {
            orderId = this.getNextOrderNumber(orderId);
            user.setNextOrderId(orderId);
            this.ebicsUserRepo.save((Model)((Object)user));
        }
        return orderId;
    }

    public String getNextOrderNumber(String orderId) throws AxelorException {
        if (Strings.isNullOrEmpty((String)orderId) || orderId.matches("[^a-z0-9 ]") || orderId.length() != 4) {
            throw new AxelorException(1, I18n.get((String)"Invalid order id \"%s\""), new Object[]{orderId});
        }
        if (orderId.substring(1).equals("ZZZ")) {
            throw new AxelorException(1, I18n.get((String)"Maximum order limit reach"));
        }
        char[] orderIds = orderId.toCharArray();
        if (orderIds[3] != 'Z') {
            orderIds[3] = this.getNextChar(orderIds[3]);
        } else {
            orderIds[3] = 48;
            if (orderIds[2] != 'Z') {
                orderIds[2] = this.getNextChar(orderIds[2]);
            } else {
                orderIds[2] = 48;
                if (orderIds[1] != 'Z') {
                    orderIds[1] = this.getNextChar(orderIds[1]);
                }
            }
        }
        return new String(orderIds);
    }

    private char getNextChar(char c) {
        if (c == '9') {
            return 'A';
        }
        return (char)(c + '\u0001');
    }

    private void trace(EbicsRequestLog requestLog, EbicsRootElement[] rootElements) throws AxelorException, JDOMException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        rootElements[0].save(bout);
        requestLog.setRequestTraceText(bout.toString());
        bout.close();
        bout = new ByteArrayOutputStream();
        rootElements[1].save(bout);
        requestLog.setResponseTraceText(bout.toString());
        bout.close();
    }
}

