/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.bankpayment.db.BankOrderFileFormat;
import com.axelor.apps.bankpayment.db.BankStatementFileFormat;
import com.axelor.apps.bankpayment.db.EbicsBank;
import com.axelor.apps.bankpayment.db.EbicsCertificate;
import com.axelor.apps.bankpayment.db.EbicsRequestLog;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.db.repo.EbicsBankRepository;
import com.axelor.apps.bankpayment.db.repo.EbicsCertificateRepository;
import com.axelor.apps.bankpayment.db.repo.EbicsRequestLogRepository;
import com.axelor.apps.bankpayment.db.repo.EbicsUserRepository;
import com.axelor.apps.bankpayment.ebics.certificate.CertificateManager;
import com.axelor.apps.bankpayment.ebics.service.EbicsCertificateService;
import com.axelor.apps.bankpayment.ebics.service.EbicsService;
import com.axelor.apps.base.service.imports.listener.ImporterListener;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.data.Listener;
import com.axelor.data.xml.XMLImporter;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.xmlbeans.impl.common.IOUtil;

@Singleton
public class EbicsController {
    @Transactional
    public void generateCertificate(ActionRequest request, ActionResponse response) {
        EbicsUser ebicsUser = (EbicsUser)((Object)((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).find(((EbicsUser)((Object)request.getContext().asType(EbicsUser.class))).getId()));
        if (ebicsUser.getStatusSelect() != 0 && ebicsUser.getStatusSelect() != 4) {
            return;
        }
        CertificateManager cm = new CertificateManager(ebicsUser);
        try {
            cm.create();
            ebicsUser.setStatusSelect(1);
            ((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).save((Model)((Object)ebicsUser));
        }
        catch (IOException | GeneralSecurityException e) {
            e.printStackTrace();
        }
        response.setReload(true);
    }

    public void generateDn(ActionRequest request, ActionResponse response) {
        EbicsUser ebicsUser = (EbicsUser)((Object)((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).find(((EbicsUser)((Object)request.getContext().asType(EbicsUser.class))).getId()));
        response.setValue("dn", (Object)((EbicsService)Beans.get(EbicsService.class)).makeDN(ebicsUser));
    }

    public void sendINIRequest(ActionRequest request, ActionResponse response) {
        EbicsUser ebicsUser = (EbicsUser)((Object)((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).find(((EbicsUser)((Object)request.getContext().asType(EbicsUser.class))).getId()));
        try {
            ((EbicsService)Beans.get(EbicsService.class)).sendINIRequest(ebicsUser, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setFlash(this.stripClass(e.getLocalizedMessage()));
        }
        response.setReload(true);
    }

    public void sendHIARequest(ActionRequest request, ActionResponse response) {
        EbicsUser ebicsUser = (EbicsUser)((Object)((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).find(((EbicsUser)((Object)request.getContext().asType(EbicsUser.class))).getId()));
        try {
            ((EbicsService)Beans.get(EbicsService.class)).sendHIARequest(ebicsUser, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setFlash(this.stripClass(e.getLocalizedMessage()));
        }
        response.setReload(true);
    }

    public void sendHPBRequest(ActionRequest request, ActionResponse response) {
        EbicsUser ebicsUser = (EbicsUser)((Object)((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).find(((EbicsUser)((Object)request.getContext().asType(EbicsUser.class))).getId()));
        try {
            X509Certificate[] certificates = ((EbicsService)Beans.get(EbicsService.class)).sendHPBRequest(ebicsUser, null);
            this.confirmCertificates(ebicsUser, certificates, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setFlash(this.stripClass(e.getLocalizedMessage()));
        }
        response.setReload(true);
    }

    private void confirmCertificates(EbicsUser user, X509Certificate[] certificates, ActionResponse response) {
        try {
            EbicsBank bank = user.getEbicsPartner().getEbicsBank();
            response.setView(ActionView.define((String)"Confirm certificates").model("com.axelor.apps.bankpayment.db.EbicsCertificate").add("form", "ebics-certificate-confirmation-form").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("popup", "true").context("ebicsBank", (Object)bank).context("url", (Object)bank.getUrl()).context("hostId", (Object)bank.getHostId()).context("e002Hash", (Object)DigestUtils.sha256Hex((byte[])certificates[0].getEncoded()).toUpperCase()).context("x002Hash", (Object)DigestUtils.sha256Hex((byte[])certificates[1].getEncoded()).toUpperCase()).context("certificateE002", (Object)((EbicsCertificateService)Beans.get(EbicsCertificateService.class)).convertToPEMString(certificates[0])).context("certificateX002", (Object)((EbicsCertificateService)Beans.get(EbicsCertificateService.class)).convertToPEMString(certificates[1])).map());
        }
        catch (Exception e) {
            response.setFlash("Error in certificate confirmation ");
        }
    }

    public void sendSPRRequest(ActionRequest request, ActionResponse response) {
        EbicsUser ebicsUser = (EbicsUser)((Object)((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).find(((EbicsUser)((Object)request.getContext().asType(EbicsUser.class))).getId()));
        try {
            ((EbicsService)Beans.get(EbicsService.class)).sendSPRRequest(ebicsUser, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setFlash(this.stripClass(e.getLocalizedMessage()));
        }
        response.setReload(true);
    }

    public void sendFULRequest(ActionRequest request, ActionResponse response) {
        EbicsUser ebicsUser = (EbicsUser)((Object)((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).find(((EbicsUser)((Object)request.getContext().asType(EbicsUser.class))).getId()));
        try {
            MetaFile testDataMetaFile = ebicsUser.getTestDataFile();
            MetaFile testSignatureMetaFile = ebicsUser.getTestSignatureFile();
            BankOrderFileFormat bankOrderFileFormat = ebicsUser.getTestBankOrderFileFormat();
            if (testDataMetaFile != null && bankOrderFileFormat != null) {
                File testSignatureFile = null;
                if (ebicsUser.getEbicsPartner().getEbicsTypeSelect() == 1 && testSignatureMetaFile != null) {
                    testSignatureFile = MetaFiles.getPath((MetaFile)testSignatureMetaFile).toFile();
                }
                ((EbicsService)Beans.get(EbicsService.class)).sendFULRequest(ebicsUser, ebicsUser.getTestSignatoryEbicsUser(), null, MetaFiles.getPath((MetaFile)testDataMetaFile).toFile(), bankOrderFileFormat, testSignatureFile);
            } else {
                response.setFlash(I18n.get((String)"Test mode is not enabled or test file is missing"));
            }
        }
        catch (Exception e) {
            response.setFlash(this.stripClass(e.getLocalizedMessage()));
        }
        response.setReload(true);
    }

    public void sendFDLRequest(ActionRequest request, ActionResponse response) {
        EbicsUser ebicsUser = (EbicsUser)((Object)((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).find(((EbicsUser)((Object)request.getContext().asType(EbicsUser.class))).getId()));
        try {
            BankStatementFileFormat bankStatementFileFormat = ebicsUser.getTestBankStatementFileFormat();
            if (ebicsUser.getEbicsPartner().getTestMode().booleanValue() && bankStatementFileFormat != null) {
                ((EbicsService)Beans.get(EbicsService.class)).sendFDLRequest(ebicsUser, null, null, null, bankStatementFileFormat.getStatementFileFormatSelect());
                this.downloadFile(response, ebicsUser);
            } else {
                response.setFlash(I18n.get((String)"Test mode is not enabled or test file is missing"));
            }
        }
        catch (Exception e) {
            response.setFlash(this.stripClass(e.getLocalizedMessage()));
        }
        response.setReload(true);
    }

    public void sendHTDRequest(ActionRequest request, ActionResponse response) {
        EbicsUser ebicsUser = (EbicsUser)((Object)((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).find(((EbicsUser)((Object)request.getContext().asType(EbicsUser.class))).getId()));
        try {
            ((EbicsService)Beans.get(EbicsService.class)).sendHTDRequest(ebicsUser, null, null, null);
            this.downloadFile(response, ebicsUser);
        }
        catch (Exception e) {
            response.setFlash(this.stripClass(e.getLocalizedMessage()));
        }
        response.setReload(true);
    }

    public void sendPTKRequest(ActionRequest request, ActionResponse response) {
        EbicsUser ebicsUser = (EbicsUser)((Object)((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).find(((EbicsUser)((Object)request.getContext().asType(EbicsUser.class))).getId()));
        try {
            ((EbicsService)Beans.get(EbicsService.class)).sendPTKRequest(ebicsUser, null, null, null);
            this.downloadFile(response, ebicsUser);
        }
        catch (Exception e) {
            response.setFlash(this.stripClass(e.getLocalizedMessage()));
        }
        response.setReload(true);
    }

    public void sendHPDRequest(ActionRequest request, ActionResponse response) {
        EbicsUser ebicsUser = (EbicsUser)((Object)((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).find(((EbicsUser)((Object)request.getContext().asType(EbicsUser.class))).getId()));
        try {
            ((EbicsService)Beans.get(EbicsService.class)).sendHPDRequest(ebicsUser, null, null, null);
            this.downloadFile(response, ebicsUser);
        }
        catch (Exception e) {
            response.setFlash(this.stripClass(e.getLocalizedMessage()));
        }
        response.setReload(true);
    }

    private String stripClass(String msg) {
        return msg.replace(AxelorException.class.getName() + ":", "");
    }

    public void addCertificates(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        EbicsBank ebicsBank = (EbicsBank)((Object)context.get((Object)"ebicsBank"));
        ebicsBank = (EbicsBank)((Object)((EbicsBankRepository)((Object)Beans.get(EbicsBankRepository.class))).find(ebicsBank.getId()));
        try {
            X509Certificate certificate = ((EbicsCertificateService)Beans.get(EbicsCertificateService.class)).convertToCertificate((String)context.get((Object)"certificateE002"));
            ((EbicsCertificateService)Beans.get(EbicsCertificateService.class)).createCertificate(certificate, ebicsBank, "encryption");
            certificate = ((EbicsCertificateService)Beans.get(EbicsCertificateService.class)).convertToCertificate((String)context.get((Object)"certificateX002"));
            ((EbicsCertificateService)Beans.get(EbicsCertificateService.class)).createCertificate(certificate, ebicsBank, "authentication");
        }
        catch (IOException | CertificateException e) {
            e.printStackTrace();
            throw new AxelorException((Throwable)e, 4, I18n.get((String)"Error in adding bank certificate"));
        }
        response.setCanClose(true);
    }

    public void loadCertificate(ActionRequest request, ActionResponse response) throws AxelorException, CertificateEncodingException, IOException {
        EbicsCertificate ebicsCertificate = (EbicsCertificate)((Object)request.getContext().asType(EbicsCertificate.class));
        ebicsCertificate = (EbicsCertificate)((Object)((EbicsCertificateRepository)((Object)Beans.get(EbicsCertificateRepository.class))).find(ebicsCertificate.getId()));
        byte[] certs = ebicsCertificate.getCertificate();
        if (certs != null && certs.length > 0) {
            X509Certificate certificate = EbicsCertificateService.getCertificate(certs, ebicsCertificate.getTypeSelect());
            ebicsCertificate = ((EbicsCertificateService)Beans.get(EbicsCertificateService.class)).updateCertificate(certificate, ebicsCertificate, true);
            response.setValue("validFrom", (Object)ebicsCertificate.getValidFrom());
            response.setValue("validTo", (Object)ebicsCertificate.getValidTo());
            response.setValue("issuer", (Object)ebicsCertificate.getIssuer());
            response.setValue("subject", (Object)ebicsCertificate.getSubject());
            response.setValue("publicKeyModulus", (Object)ebicsCertificate.getPublicKeyModulus());
            response.setValue("publicKeyExponent", (Object)ebicsCertificate.getPublicKeyExponent());
            response.setValue("fullName", (Object)ebicsCertificate.getFullName());
            response.setValue("pemString", (Object)ebicsCertificate.getPemString());
            response.setValue("sha2has", (Object)ebicsCertificate.getSha2has());
        }
    }

    public void updateEditionDate(ActionRequest request, ActionResponse response) {
        EbicsUser ebicsUser = (EbicsUser)((Object)request.getContext().asType(EbicsUser.class));
        ebicsUser = (EbicsUser)((Object)((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).find(ebicsUser.getId()));
        ((EbicsCertificateService)Beans.get(EbicsCertificateService.class)).updateEditionDate(ebicsUser);
        response.setReload(true);
    }

    @Transactional
    public void importEbicsUsers(ActionRequest request, ActionResponse response) {
        String config = "/data-import/import-ebics-user-config.xml";
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(config);
            File configFile = File.createTempFile("config", ".xml");
            FileOutputStream fout = new FileOutputStream(configFile);
            IOUtil.copyCompletely((InputStream)inputStream, (OutputStream)fout);
            Path path = MetaFiles.getPath((String)((String)((Map)request.getContext().get((Object)"dataFile")).get("filePath")));
            File tempDir = Files.createTempDir();
            File importFile = new File(tempDir, "ebics-user.xml");
            Files.copy((File)path.toFile(), (File)importFile);
            XMLImporter importer = new XMLImporter(configFile.getAbsolutePath(), tempDir.getAbsolutePath());
            ImporterListener listner = new ImporterListener("EbicsUser");
            importer.addListener((Listener)listner);
            importer.run();
            FileUtils.forceDelete((File)configFile);
            FileUtils.forceDelete((File)tempDir);
            response.setValue("importLog", (Object)listner.getImportLog());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printCertificates(ActionRequest request, ActionResponse response) throws AxelorException {
        EbicsUser ebicsUser = (EbicsUser)((Object)request.getContext().asType(EbicsUser.class));
        ArrayList<Long> certIds = new ArrayList<Long>();
        if (ebicsUser.getA005Certificate() != null) {
            certIds.add(ebicsUser.getA005Certificate().getId());
        }
        if (ebicsUser.getE002Certificate() != null) {
            certIds.add(ebicsUser.getE002Certificate().getId());
        }
        if (ebicsUser.getX002Certificate() != null) {
            certIds.add(ebicsUser.getX002Certificate().getId());
        }
        if (certIds.isEmpty()) {
            throw new AxelorException((Model)((Object)ebicsUser), 1, I18n.get((String)"Please add certificates to print"));
        }
        String title = I18n.get((String)"EbicsCertificate");
        ReportSettings report = ReportFactory.createReport((String)"EbicsCertificate.rptdesign", (String)(title + "-${date}${time}"));
        report.addParam("CertificateId", (Object)Joiner.on((String)",").join(certIds));
        report.addParam("EbicsUserId", (Object)ebicsUser.getId());
        report.toAttach((Model)((Object)ebicsUser));
        report.generate();
        response.setView(ActionView.define((String)title).add("html", report.getFileLink()).map());
    }

    private void downloadFile(ActionResponse response, EbicsUser user) {
        EbicsRequestLog requestLog = (EbicsRequestLog)((Object)((EbicsRequestLogRepository)((Object)Beans.get(EbicsRequestLogRepository.class))).all().filter("self.ebicsUser = ?1", new Object[]{user}).order("-id").fetchOne());
        if (requestLog != null && requestLog.getResponseFile() != null) {
            response.setView(ActionView.define((String)requestLog.getRequestType()).add("html", "ws/rest/" + EbicsRequestLog.class.getCanonicalName() + "/" + requestLog.getId() + "/responseFile/download").param("download", "dtrue").map());
        }
    }
}

