/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.h003.EbicsRequestDocument;
import com.axelor.apps.account.ebics.schema.h003.FDLOrderParamsType;
import com.axelor.apps.account.ebics.schema.h003.FileFormatType;
import com.axelor.apps.account.ebics.schema.h003.MutableHeaderType;
import com.axelor.apps.account.ebics.schema.h003.ParameterDocument;
import com.axelor.apps.account.ebics.schema.h003.StandardOrderParamsType;
import com.axelor.apps.account.ebics.schema.h003.StaticHeaderOrderDetailsType;
import com.axelor.apps.account.ebics.schema.h003.StaticHeaderType;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.certificate.KeyUtil;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.OrderAttribute;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.apps.bankpayment.ebics.xml.InitializationRequestElement;
import com.axelor.exception.AxelorException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DInitializationRequestElement
extends InitializationRequestElement {
    private Date startRange;
    private Date endRange;

    public DInitializationRequestElement(EbicsSession session, OrderType type, Date startRange, Date endRange) throws AxelorException {
        super(session, type, DInitializationRequestElement.generateName(type));
        this.startRange = startRange;
        this.endRange = endRange;
    }

    @Override
    public void buildInitialization() throws AxelorException {
        StaticHeaderOrderDetailsType orderDetails;
        MutableHeaderType mutable = EbicsXmlFactory.createMutableHeaderType("Initialisation", null);
        StaticHeaderType.Product product = EbicsXmlFactory.createProduct(this.session.getProduct().getLanguage(), this.session.getProduct().getName());
        StaticHeaderType.BankPubKeyDigests.Authentication authentication = EbicsXmlFactory.createAuthentication("X002", "http://www.w3.org/2001/04/xmlenc#sha256", this.decodeHex(KeyUtil.getKeyDigest(this.session.getBankX002Key())));
        StaticHeaderType.BankPubKeyDigests.Encryption encryption = EbicsXmlFactory.createEncryption("E002", "http://www.w3.org/2001/04/xmlenc#sha256", this.decodeHex(KeyUtil.getKeyDigest(this.session.getBankE002Key())));
        StaticHeaderType.BankPubKeyDigests bankPubKeyDigests = EbicsXmlFactory.createBankPubKeyDigests(authentication, encryption);
        StaticHeaderOrderDetailsType.OrderType orderType = EbicsXmlFactory.createOrderType(this.type.getOrderType());
        EbicsUser ebicsUser = this.session.getUser();
        EbicsPartner ebicsPartner = ebicsUser.getEbicsPartner();
        OrderAttribute orderAttribute = new OrderAttribute(this.type, ebicsPartner.getEbicsTypeSelect());
        orderAttribute.build();
        if (this.type.equals(OrderType.FDL)) {
            FileFormatType fileFormat = EbicsXmlFactory.createFileFormatType(Locale.FRANCE.getCountry().toUpperCase(), this.session.getSessionParam("FORMAT"));
            FDLOrderParamsType fDLOrderParamsType = EbicsXmlFactory.createFDLOrderParamsType(fileFormat);
            if (this.startRange != null && this.endRange != null) {
                FDLOrderParamsType.DateRange range = EbicsXmlFactory.createDateRange(this.startRange, this.endRange);
                fDLOrderParamsType.setDateRange(range);
            }
            if (Boolean.getBoolean(this.session.getSessionParam("TEST"))) {
                ParameterDocument.Parameter.Value value = EbicsXmlFactory.createValue("String", "TRUE");
                ParameterDocument.Parameter parameter = EbicsXmlFactory.createParameter("TEST", value);
                fDLOrderParamsType.setParameterArray(new ParameterDocument.Parameter[]{parameter});
            }
            orderDetails = EbicsXmlFactory.createStaticHeaderOrderDetailsType(ebicsUser.getNextOrderId(), orderAttribute.getOrderAttributes(), orderType, fDLOrderParamsType);
        } else {
            StandardOrderParamsType standardOrderParamsType = EbicsXmlFactory.createStandardOrderParamsType();
            orderDetails = EbicsXmlFactory.createStaticHeaderOrderDetailsType(ebicsUser.getNextOrderId(), orderAttribute.getOrderAttributes(), orderType, standardOrderParamsType);
        }
        StaticHeaderType xstatic = EbicsXmlFactory.createStaticHeaderType(this.session.getBankID(), this.nonce, ebicsPartner.getPartnerId(), product, ebicsUser.getSecurityMedium(), ebicsUser.getUserId(), Calendar.getInstance(), orderDetails, bankPubKeyDigests);
        EbicsRequestDocument.EbicsRequest.Header header = EbicsXmlFactory.createEbicsRequestHeader(true, mutable, xstatic);
        EbicsRequestDocument.EbicsRequest.Body body = EbicsXmlFactory.createEbicsRequestBody();
        EbicsRequestDocument.EbicsRequest request = EbicsXmlFactory.createEbicsRequest(1, "H003", header, body);
        this.document = EbicsXmlFactory.createEbicsRequestDocument(request);
    }
}

