/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.bankpayment.ebics.client.EbicsRootElement;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.exception.AxelorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class DefaultEbicsRootElement
implements EbicsRootElement {
    protected XmlObject document;
    protected EbicsSession session;
    private static Map<String, String> suggestedPrefixes;

    public DefaultEbicsRootElement(EbicsSession session) {
        this.session = session;
        suggestedPrefixes = new HashMap<String, String>();
    }

    public DefaultEbicsRootElement() {
        this(null);
    }

    protected static void setSaveSuggestedPrefixes(String uri, String prefix) {
        suggestedPrefixes.put(uri, prefix);
    }

    public byte[] prettyPrint() throws AxelorException {
        SAXBuilder sxb = new SAXBuilder();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            Document document = sxb.build((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(this.toByteArray()), "UTF-8"));
            xmlOutputter.output(document, (OutputStream)output);
        }
        catch (IOException | JDOMException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
        return output.toByteArray();
    }

    public void insertSchemaLocation(String namespaceURI, String localPart, String prefix, String value) {
        XmlCursor cursor = this.document.newCursor();
        while (cursor.hasNextToken()) {
            if (cursor.isStart()) {
                cursor.toNextToken();
                cursor.insertAttributeWithValue(new QName(namespaceURI, localPart, prefix), value);
                break;
            }
            cursor.toNextToken();
        }
    }

    public static String generateName(OrderType type) {
        return type.getOrderType() + new BigInteger(130, new SecureRandom()).toString(32);
    }

    public static String generateName(String prefix) {
        return prefix + new BigInteger(130, new SecureRandom()).toString(32);
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        options.setSaveSuggestedPrefixes(suggestedPrefixes);
        return this.document.xmlText(options).getBytes();
    }

    @Override
    public void addNamespaceDecl(String prefix, String uri) {
        XmlCursor cursor = this.document.newCursor();
        while (cursor.hasNextToken()) {
            if (cursor.isStart()) {
                cursor.toNextToken();
                cursor.insertNamespace(prefix, uri);
                break;
            }
            cursor.toNextToken();
        }
    }

    @Override
    public void validate() throws AxelorException {
        ArrayList validationMessages = new ArrayList();
        boolean isValid = this.document.validate(new XmlOptions().setErrorListener(validationMessages));
        if (!isValid) {
            Iterator iter = validationMessages.iterator();
            String message = "";
            while (iter.hasNext()) {
                if (!message.equals("")) {
                    message = message + ";";
                }
                message = message + ((XmlError)iter.next()).getMessage();
            }
            throw new AxelorException(4, message);
        }
    }

    @Override
    public void save(OutputStream out) throws AxelorException, JDOMException {
        try {
            byte[] element = this.prettyPrint();
            out.write(element);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.println(this.document.toString());
    }
}

