/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.h003.EbicsRequestDocument;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.apps.bankpayment.ebics.xml.SignedInfo;
import com.axelor.exception.AxelorException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public abstract class InitializationRequestElement
extends DefaultEbicsRootElement {
    private String name;
    protected OrderType type;
    protected byte[] nonce;

    public InitializationRequestElement(EbicsSession session, OrderType type, String name) throws AxelorException {
        super(session);
        this.type = type;
        this.name = name;
        this.nonce = EbicsUtils.generateNonce();
    }

    @Override
    public void build() throws AxelorException {
        this.buildInitialization();
        SignedInfo signedInfo = new SignedInfo(this.session.getUser(), this.getDigest());
        signedInfo.build();
        ((EbicsRequestDocument)this.document).getEbicsRequest().setAuthSignature(signedInfo.getSignatureType());
        ((EbicsRequestDocument)this.document).getEbicsRequest().getAuthSignature().setSignatureValue(EbicsXmlFactory.createSignatureValueType(signedInfo.sign(this.toByteArray())));
    }

    @Override
    public String getName() {
        return this.name + ".xml";
    }

    @Override
    public byte[] toByteArray() {
        InitializationRequestElement.setSaveSuggestedPrefixes("http://www.ebics.org/H003", "");
        return super.toByteArray();
    }

    public byte[] getDigest() throws AxelorException {
        this.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
        try {
            return MessageDigest.getInstance("SHA-256", "BC").digest(EbicsUtils.canonize(this.toByteArray()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }

    public String getType() {
        return this.type.getOrderType();
    }

    protected byte[] decodeHex(byte[] hex) throws AxelorException {
        if (hex == null) {
            throw new AxelorException(4, "Bank digest is empty, HPB request must be performed before");
        }
        try {
            return Hex.decodeHex((char[])new String(hex).toCharArray());
        }
        catch (DecoderException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }

    protected byte[] generateTransactionKey() throws AxelorException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding", "BC");
            cipher.init(1, this.session.getBankE002Key());
            return cipher.doFinal(this.nonce);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }

    public abstract void buildInitialization() throws AxelorException;
}

