/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.h003.EbicsNoPubKeyDigestsRequestDocument;
import com.axelor.apps.account.ebics.schema.h003.EmptyMutableHeaderType;
import com.axelor.apps.account.ebics.schema.h003.NoPubKeyDigestsRequestStaticHeaderType;
import com.axelor.apps.account.ebics.schema.h003.OrderDetailsType;
import com.axelor.apps.account.ebics.schema.h003.ProductElementType;
import com.axelor.apps.account.ebics.schema.xmldsig.SignatureType;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.client.OrderAttribute;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.exception.AxelorException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Calendar;

public class NoPubKeyDigestsRequestElement
extends DefaultEbicsRootElement {
    public NoPubKeyDigestsRequestElement(EbicsSession session) {
        super(session);
    }

    public byte[] getDigest() throws AxelorException {
        this.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
        try {
            return MessageDigest.getInstance("SHA-256", "BC").digest(EbicsUtils.canonize(this.toByteArray()));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new AxelorException(e.getCause(), 0, e.getMessage());
        }
    }

    public void setAuthSignature(SignatureType authSignature) {
        ((EbicsNoPubKeyDigestsRequestDocument)this.document).getEbicsNoPubKeyDigestsRequest().setAuthSignature(authSignature);
    }

    public void setSignatureValue(byte[] signature) {
        ((EbicsNoPubKeyDigestsRequestDocument)this.document).getEbicsNoPubKeyDigestsRequest().getAuthSignature().setSignatureValue(EbicsXmlFactory.createSignatureValueType(signature));
    }

    @Override
    public void build() throws AxelorException {
        EbicsUser ebicsUser = this.session.getUser();
        EbicsPartner ebicsPartner = ebicsUser.getEbicsPartner();
        OrderAttribute orderAttribute = new OrderAttribute(OrderType.HPB, ebicsPartner.getEbicsTypeSelect());
        orderAttribute.build();
        ProductElementType product = EbicsXmlFactory.creatProductElementType(this.session.getProduct().getLanguage(), this.session.getProduct().getName());
        OrderDetailsType orderDetails = EbicsXmlFactory.createOrderDetailsType(orderAttribute.getOrderAttributes(), null, OrderType.HPB.getOrderType());
        NoPubKeyDigestsRequestStaticHeaderType xstatic = EbicsXmlFactory.createNoPubKeyDigestsRequestStaticHeaderType(this.session.getBankID(), EbicsUtils.generateNonce(), Calendar.getInstance(), ebicsPartner.getPartnerId(), ebicsUser.getUserId(), product, orderDetails, ebicsUser.getSecurityMedium());
        EmptyMutableHeaderType mutable = EbicsXmlFactory.createEmptyMutableHeaderType();
        EbicsNoPubKeyDigestsRequestDocument.EbicsNoPubKeyDigestsRequest.Header header = EbicsXmlFactory.createDigestsRequestHeader(true, mutable, xstatic);
        EbicsNoPubKeyDigestsRequestDocument.EbicsNoPubKeyDigestsRequest.Body body = EbicsXmlFactory.createDigestsRequestBody();
        EbicsNoPubKeyDigestsRequestDocument.EbicsNoPubKeyDigestsRequest request = EbicsXmlFactory.createEbicsNoPubKeyDigestsRequest(1, "H003", header, body);
        this.document = EbicsXmlFactory.createEbicsNoPubKeyDigestsRequestDocument(request);
    }

    @Override
    public byte[] toByteArray() {
        NoPubKeyDigestsRequestElement.setSaveSuggestedPrefixes("http://www.w3.org/2000/09/xmldsig#", "ds");
        NoPubKeyDigestsRequestElement.setSaveSuggestedPrefixes("http://www.ebics.org/H003", "");
        return super.toByteArray();
    }

    @Override
    public String getName() {
        return "NoPubKeyDigestsRequest.xml";
    }
}

